/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.combo_options;

import com.moulberry.flashback.combo_options.AudioCodec;
import com.moulberry.flashback.combo_options.ComboOption;
import com.moulberry.flashback.combo_options.VideoCodec;
import java.util.ArrayList;
import org.bytedeco.ffmpeg.avformat.AVOutputFormat;
import org.bytedeco.ffmpeg.global.avformat;

public enum VideoContainer implements ComboOption
{
    MP4("MP4", "mp4"),
    MKV("MKV", "mkv"),
    AVI("AVI", "avi"),
    MOV("MOV", "mov"),
    PNG_SEQUENCE("PNG Sequence", "png"),
    WEBP("WebP", "webp"),
    WEBM("WebM", "webm"),
    GIF("GIF", "gif");

    private final String text;
    private final String extension;
    private VideoCodec[] supportedVideoCodecs = null;
    private VideoCodec[] supportedVideoCodecsWithTransparency = null;
    private AudioCodec[] supportedAudioCodecs = null;

    private VideoContainer(String text, String extension) {
        this.text = text;
        this.extension = extension;
    }

    @Override
    public String text() {
        return this.text;
    }

    public String extension() {
        return this.extension;
    }

    public static VideoContainer[] findSupportedContainers(boolean transparency) {
        ArrayList<VideoContainer> containers = new ArrayList<VideoContainer>();
        for (VideoContainer videoContainer : VideoContainer.values()) {
            if (videoContainer != PNG_SEQUENCE && videoContainer.getSupportedVideoCodecs(transparency).length == 0) continue;
            containers.add(videoContainer);
        }
        return containers.toArray(new VideoContainer[0]);
    }

    public VideoCodec[] getSupportedVideoCodecs(boolean transparency) {
        VideoCodec[] codecs;
        VideoCodec[] videoCodecArray = codecs = transparency ? this.supportedVideoCodecsWithTransparency : this.supportedVideoCodecs;
        if (codecs == null) {
            ArrayList<VideoCodec> supportedCodecs = new ArrayList<VideoCodec>();
            if (this != PNG_SEQUENCE) {
                try (AVOutputFormat outputFormat = avformat.av_guess_format(this.extension, "test." + this.extension, null);){
                    for (VideoCodec codec : VideoCodec.values()) {
                        int ret;
                        if (codec == VideoCodec.AV1 && this != MP4 || codec.getEncoders().length == 0 || transparency && !codec.supportsTransparency() || (ret = avformat.avformat_query_codec(outputFormat, codec.codecId(), 0)) != 1) continue;
                        supportedCodecs.add(codec);
                    }
                }
            }
            codecs = supportedCodecs.toArray(new VideoCodec[0]);
            if (transparency) {
                this.supportedVideoCodecsWithTransparency = codecs;
            } else {
                this.supportedVideoCodecs = codecs;
            }
        }
        return codecs;
    }

    public AudioCodec[] getSupportedAudioCodecs() {
        if (this.supportedAudioCodecs == null) {
            ArrayList<AudioCodec> supportedCodecs = new ArrayList<AudioCodec>();
            if (this != PNG_SEQUENCE) {
                try (AVOutputFormat outputFormat = avformat.av_guess_format(this.extension, "test." + this.extension, null);){
                    for (AudioCodec codec : AudioCodec.values()) {
                        int ret;
                        if (codec.getEncoders().length == 0 || (ret = avformat.avformat_query_codec(outputFormat, codec.codecId(), 0)) != 1) continue;
                        supportedCodecs.add(codec);
                    }
                }
            }
            this.supportedAudioCodecs = supportedCodecs.toArray(new AudioCodec[0]);
        }
        return this.supportedAudioCodecs;
    }

    public String mimeType() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "video/mp4";
            case 1 -> "video/mkv";
            case 2 -> "video/x-msvideo";
            case 3 -> "video/quicktime";
            case 4 -> "image/png";
            case 5 -> "image/webp";
            case 6 -> "video/webm";
            case 7 -> "image/gif";
        };
    }
}

