/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.exporting;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.class_1011;
import net.minecraft.class_10865;
import net.minecraft.class_10868;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;

public class SaveableFramebuffer
implements AutoCloseable {
    private int pboId = -1;
    @Nullable
    public FloatBuffer audioBuffer;
    private boolean isDownloading = false;

    public void startDownload(GpuTexture gpuTexture, int width, int height) {
        if (this.isDownloading) {
            throw new IllegalStateException("Can't start downloading while already downloading");
        }
        this.isDownloading = true;
        if (this.pboId == -1) {
            this.pboId = GL30C.glGenBuffers();
            GL30C.glBindBuffer((int)35051, (int)this.pboId);
            GL30C.glBufferData((int)35051, (long)((long)width * (long)height * 4L), (int)35041);
            GL30C.glBindBuffer((int)35051, (int)0);
        }
        int fbo = ((class_10868)gpuTexture).method_68426(((class_10865)RenderSystem.getDevice()).method_68401(), null);
        GlStateManager._glBindFramebuffer((int)36160, (int)fbo);
        GL30C.glBindBuffer((int)35051, (int)this.pboId);
        GlStateManager._pixelStore((int)3333, (int)1);
        GlStateManager._pixelStore((int)3330, (int)0);
        GlStateManager._pixelStore((int)3332, (int)0);
        GlStateManager._pixelStore((int)3331, (int)0);
        GL30C.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (long)0L);
        GL30C.glBindBuffer((int)35051, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }

    public class_1011 finishDownload(int width, int height) {
        if (!this.isDownloading) {
            throw new IllegalStateException("Can't finish downloading before download has started");
        }
        this.isDownloading = false;
        class_1011 nativeImage = new class_1011(class_1011.class_1012.field_4997, width, height, false);
        GL30C.glBindBuffer((int)35051, (int)this.pboId);
        ByteBuffer buffer = GL30C.glMapBuffer((int)35051, (int)35000);
        if (buffer == null) {
            throw new IllegalStateException("OpenGL error occurred while mapping buffer");
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)buffer), (long)nativeImage.field_4988, (long)nativeImage.field_4987);
        GL30C.glUnmapBuffer((int)35051);
        GL30C.glBindBuffer((int)35051, (int)0);
        return nativeImage;
    }

    @Override
    public void close() {
        if (this.pboId != -1) {
            GL30C.glDeleteBuffers((int)this.pboId);
            this.pboId = -1;
        }
    }
}

