/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.flashback.mixin.visuals;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.state.EditorState;
import com.moulberry.flashback.state.EditorStateManager;
import com.moulberry.flashback.visuals.ReplayVisuals;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_638.class})
public class MixinClientLevel {
    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSkyColor(class_243 vec3, float f, CallbackInfoReturnable<Integer> cir) {
        EditorState editorState = EditorStateManager.getCurrent();
        if (editorState != null) {
            ReplayVisuals visuals = editorState.replayVisuals;
            if (!visuals.renderSky) {
                if (Flashback.isExporting() && Flashback.EXPORT_JOB.getSettings().transparent()) {
                    cir.setReturnValue((Object)0);
                } else {
                    float[] skyColour = visuals.skyColour;
                    int r = (int)(skyColour[0] * 255.0f);
                    int g = (int)(skyColour[1] * 255.0f);
                    int b = (int)(skyColour[2] * 255.0f);
                    cir.setReturnValue((Object)(0xFF000000 | r << 16 | g << 8 | b));
                }
            }
        }
    }

    @Inject(method={"tickNonPassenger"}, at={@At(value="RETURN")}, require=0)
    public void tickNonPassengerEnd(class_1297 entity, CallbackInfo ci) {
        if (Flashback.isInReplay()) {
            entity.field_6004 = class_3532.method_15393((float)(entity.field_6004 - entity.method_36455())) + entity.method_36455();
            entity.field_5982 = class_3532.method_15393((float)(entity.field_5982 - entity.method_36454())) + entity.method_36454();
        }
    }

    @Inject(method={"tickPassenger"}, at={@At(value="RETURN")}, require=0)
    public void tickPassengerEnd(class_1297 vehicle, class_1297 entity, CallbackInfo ci) {
        if (Flashback.isInReplay()) {
            entity.field_6004 = class_3532.method_15393((float)(entity.field_6004 - entity.method_36455())) + entity.method_36455();
            entity.field_5982 = class_3532.method_15393((float)(entity.field_5982 - entity.method_36454())) + entity.method_36454();
        }
    }
}

