/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11876;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.components.AbstractScreenListener;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.render.ScissorState;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;

public abstract class AbstractScrollbar<P extends GuiScreen>
extends AbstractScreenListener
implements GuiWidget {
    protected final List<Entry> entries = Lists.newCopyOnWriteArrayList();
    protected final List<EntryPosition> entryPositions = Lists.newCopyOnWriteArrayList();
    protected final P parent;
    protected final int containerWidth;
    protected final int width;
    protected final int height;
    protected int y0;
    protected int y1;
    protected int scrollHeight;
    protected double scrollTop;
    protected boolean scrolling;
    @Nullable
    protected Entry hoveredEntry;
    private int lastMaxScroll = 0;

    public AbstractScrollbar(P parent, int containerWidth, int y0, int y1) {
        this.parent = parent;
        this.containerWidth = containerWidth;
        this.width = ((GuiScreen)parent).getWidth();
        this.height = ((GuiScreen)parent).getHeight();
        this.y0 = y0;
        this.y1 = y1;
    }

    @Override
    public void render(@NotNull GuiRenderContext context, int mouseX, int mouseY, float delta) {
        this.hoveredEntry = this.isMouseOver(mouseX, mouseY) ? (Entry)this.getEntryAtPosition(mouseX, mouseY).orElse(null) : null;
        int trackX0 = this.getScrollbarPosition();
        int trackX1 = trackX0 + 6;
        int maxScroll = this.getMaxScroll();
        if (this.lastMaxScroll != maxScroll) {
            if (this.lastMaxScroll > 0) {
                double scrollPercent = this.scrollTop / (double)this.lastMaxScroll;
                this.setScrollTop((double)maxScroll * scrollPercent);
            } else {
                this.setScrollTop(0.0);
            }
        }
        this.lastMaxScroll = maxScroll;
        this.renderList(context, this.getContainerX0(), this.y0, mouseX, mouseY, delta);
        if (maxScroll > 0) {
            int scrollbarY0 = this.y0 + this.getScrollbarPadding();
            int scrollbarY1 = this.y1 - this.getScrollbarPadding();
            int trackBottom = (int)((float)((scrollbarY1 - scrollbarY0) * (scrollbarY1 - scrollbarY0)) / (float)this.scrollHeight);
            int trackTop = (int)this.scrollTop * (scrollbarY1 - scrollbarY0 - (trackBottom = class_3532.method_15340((int)trackBottom, (int)32, (int)(scrollbarY1 - scrollbarY0 - 8)))) / maxScroll + scrollbarY0;
            if (trackTop < scrollbarY0) {
                trackTop = scrollbarY0;
            }
            if (this.shouldRenderScrollbarBackground()) {
                context.fill(trackX0, scrollbarY0, trackX1, scrollbarY1, new Color(0, 0, 0));
            }
            context.fill(trackX0, trackTop, trackX1, trackTop + trackBottom, new Color(128, 128, 128));
            context.fill(trackX0, trackTop, trackX1 - 1, trackTop + trackBottom - 1, new Color(192, 192, 192));
        }
        if (this.isMouseOverScrollbar(mouseX, mouseY)) {
            context.requestCursor(this.scrolling ? class_11876.field_62456 : class_11876.field_62455);
        }
    }

    @Override
    public List<? extends GuiWidgetListener> widgets() {
        return this.entries;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        boolean entryScrolled = this.entries.stream().flatMap(entry -> entry.widgets().stream()).filter(entry -> entry.isMouseOver(mouseX, mouseY)).anyMatch(entry -> entry.mouseScrolled(mouseX, mouseY, delta));
        if (entryScrolled) {
            return true;
        }
        if (this.getMaxScroll() == 0) {
            return false;
        }
        this.setScrollTop(this.scrollTop - delta * (double)((float)this.scrollHeight / (float)this.entries.size()));
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean bl = this.scrolling = button == 0 && this.isMouseOverScrollbar(mouseX, mouseY);
        if (this.scrolling) {
            return true;
        }
        Optional<Entry> entry = this.getEntryAtPosition(mouseX, mouseY);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (entry.isPresent() && entry.get().mouseClicked(mouseX, mouseY, button)) {
            this.setFocused(entry.get());
            this.setDragging(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean entryDragged = this.entries.stream().flatMap(entry -> entry.widgets().stream()).filter(entry -> entry.isMouseOver(mouseX, mouseY)).anyMatch(entry -> entry.mouseDragged(mouseX, mouseY, button, deltaX, deltaY));
        if (entryDragged) {
            return true;
        }
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.y0) {
                this.setScrollTop(0.0);
            } else if (mouseY > (double)this.y1) {
                this.setScrollTop(this.getMaxScroll());
            } else {
                double maxScroll = Math.max(1, this.getMaxScroll());
                int diff = this.y1 - this.y0;
                int scrollStep = class_3532.method_15340((int)((int)((float)(diff * diff) / (float)this.scrollHeight)), (int)32, (int)diff);
                double multiplier = Math.max(1.0, maxScroll / (double)(diff - scrollStep));
                this.setScrollTop(this.scrollTop + deltaY * multiplier);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY >= (double)this.y0 && mouseY <= (double)this.y1 && mouseX >= (double)this.getContainerX0() && mouseX <= (double)this.getContainerX1();
    }

    public void addEntry(@NotNull Entry entry) {
        this.entries.add(entry);
        EntryPosition lastPosition = this.getLastEntryPosition();
        this.entryPositions.add(new EntryPosition(lastPosition.bottom, lastPosition.bottom + entry.getHeight()));
        this.scrollHeight += entry.getHeight();
    }

    public void clearEntries() {
        this.entries.clear();
        this.entryPositions.clear();
        this.scrollHeight = 0;
    }

    public void onEntryHeightChange() {
        this.scrollHeight = 0;
        this.entryPositions.clear();
        this.entries.forEach(entry -> {
            EntryPosition lastPosition = this.getLastEntryPosition();
            this.entryPositions.add(new EntryPosition(lastPosition.bottom, lastPosition.bottom + entry.getHeight()));
            this.scrollHeight += entry.getHeight();
        });
    }

    public void setScrollTop(double scrollTop) {
        this.scrollTop = class_3532.method_15350((double)scrollTop, (double)0.0, (double)this.getMaxScroll());
    }

    protected void renderList(@NotNull GuiRenderContext context, int x, int y, int mouseX, int mouseY, float delta) {
        ScissorState scissorState = context.getScissorState();
        ScissorState newScissorState = ScissorState.ofScaled(this.getContainerX0(), this.y0, this.containerWidth, this.y1 - this.y0);
        if (scissorState != null) {
            int parentX = scissorState.getX();
            int parentY = scissorState.getY();
            int parentRight = parentX + scissorState.getWidth();
            int parentTop = parentY + scissorState.getHeight();
            int childX = newScissorState.getX();
            int childY = newScissorState.getY();
            int childRight = childX + newScissorState.getWidth();
            int childTop = childY + newScissorState.getHeight();
            int clippedX = Math.max(childX, parentX);
            int clippedY = Math.max(childY, parentY);
            int clippedRight = Math.min(childRight, parentRight);
            int clippedTop = Math.min(childTop, parentTop);
            int clippedWidth = Math.max(0, clippedRight - clippedX);
            int clippedHeight = Math.max(0, clippedTop - clippedY);
            newScissorState = ScissorState.ofScaled(clippedX, clippedY, clippedWidth, clippedHeight);
        }
        context.applyScissorState(newScissorState);
        for (int index = 0; index < this.entries.size(); ++index) {
            Entry entry = this.entries.get(index);
            EntryPosition position = this.entryPositions.get(index);
            int entryTop = y - (int)this.scrollTop + position.top;
            int entryBottom = y - (int)this.scrollTop + position.bottom;
            entry.updatePosition(context, index, x, entryTop, this.containerWidth, mouseX, mouseY, Objects.equals(this.hoveredEntry, entry), delta);
            if (entryTop > this.y1 || entryBottom < this.y0) continue;
            entry.render(context, index, x, entryTop, this.containerWidth, mouseX, mouseY, Objects.equals(this.hoveredEntry, entry), delta);
        }
        context.applyScissorState(scissorState);
    }

    protected int getContainerX0() {
        return (this.width - this.containerWidth) / 2;
    }

    protected int getContainerX1() {
        return this.getContainerX0() + this.containerWidth;
    }

    protected int getScrollbarPosition() {
        return this.getContainerX1() + 13;
    }

    protected int getScrollbarPadding() {
        return 4;
    }

    protected boolean shouldRenderScrollbarBackground() {
        return true;
    }

    protected final boolean isMouseOverScrollbar(double mouseX, double mouseY) {
        return this.getMaxScroll() > 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6) && mouseY >= (double)this.y0 && mouseY <= (double)this.y1;
    }

    protected Optional<Entry> getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX < (double)this.getContainerX0() || mouseX > (double)this.getContainerX1()) {
            return Optional.empty();
        }
        double relativeY = mouseY - (double)this.y0 + this.scrollTop;
        if (relativeY < 0.0 || relativeY > (double)this.scrollHeight) {
            return Optional.empty();
        }
        for (int index = 0; index < this.entries.size(); ++index) {
            EntryPosition position = this.entryPositions.get(index);
            if (!(relativeY > (double)position.top) || !(relativeY <= (double)position.bottom)) continue;
            return Optional.of(this.entries.get(index));
        }
        return Optional.empty();
    }

    protected final int getMaxScroll() {
        return Math.max(0, this.scrollHeight - (this.y1 - this.y0));
    }

    @NotNull
    private EntryPosition getLastEntryPosition() {
        if (this.entryPositions.size() == 0) {
            return EntryPosition.EMPTY;
        }
        return this.entryPositions.get(this.entryPositions.size() - 1);
    }

    public abstract void init();

    @Nullable
    public GuiWidgetListener getFocusedWidget() {
        Entry entry = (Entry)this.getFocused();
        if (entry == null) {
            return null;
        }
        GuiWidgetListener widget = entry.getFocused();
        if (widget instanceof AbstractScrollbar) {
            return ((AbstractScrollbar)widget).getFocusedWidget();
        }
        if (widget instanceof GuiAbstractWidget) {
            GuiAbstractWidget abstractWidget = (GuiAbstractWidget)widget;
            if (!abstractWidget.isFocused()) {
                return null;
            }
            return widget;
        }
        return null;
    }

    public int getContainerWidth() {
        return this.containerWidth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public abstract class Entry
    extends AbstractScreenListener {
        protected int height;

        public Entry(int height) {
            this.height = height;
        }

        public void setHeight(int height) {
            if (this.height != height) {
                this.height = height;
                AbstractScrollbar.this.onEntryHeightChange();
            }
        }

        @Override
        public List<? extends GuiWidgetListener> widgets() {
            return Collections.emptyList();
        }

        public void updatePosition(@NotNull GuiRenderContext context, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
        }

        public abstract void render(@NotNull GuiRenderContext var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public int getHeight() {
            return this.height;
        }
    }

    static class EntryPosition {
        static EntryPosition EMPTY = new EntryPosition(0, 0);
        private int top;
        private int bottom;

        public EntryPosition(int top, int bottom) {
            this.top = top;
            this.bottom = bottom;
        }

        public String toString() {
            return "AbstractScrollbar.EntryPosition(top=" + this.top + ", bottom=" + this.bottom + ")";
        }
    }
}

