/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.capture;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.event.EventPriority;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourcePacketEvent;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.socket.UdpConnection;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;
import su.plo.voice.proto.data.audio.source.SelfSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SelfSourceInfoPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ*\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J2\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010 \u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\r2\u0006\u0010 \u001a\u00020%H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lsu/plo/voice/server/audio/capture/SelfActivationHelper;", "", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "<init>", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;)V", "lastPlayerActivationIds", "", "Ljava/util/UUID;", "sourceIdToPlayerId", "playerIdToSourceIds", "", "cleanupPlayer", "", "playerId", "sendAudioInfo", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "source", "Lsu/plo/voice/api/server/audio/source/ServerAudioSource;", "playerPacket", "Lsu/plo/voice/proto/packets/udp/serverbound/PlayerAudioPacket;", "sourcePacket", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "activationId", "packet", "dataChanged", "", "updateSelfSourceInfo", "sourceInfo", "Lsu/plo/voice/proto/data/audio/source/SourceInfo;", "onSourceAudioPacket", "event", "Lsu/plo/voice/api/server/event/audio/source/ServerSourceAudioPacketEvent;", "onSourceSendPacket", "Lsu/plo/voice/api/server/event/audio/source/ServerSourcePacketEvent;", "onClientDisconnected", "Lsu/plo/voice/api/server/event/connection/UdpClientDisconnectedEvent;", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nSelfActivationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelfActivationHelper.kt\nsu/plo/voice/server/audio/capture/SelfActivationHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1863#2,2:148\n1#3:150\n*S KotlinDebug\n*F\n+ 1 SelfActivationHelper.kt\nsu/plo/voice/server/audio/capture/SelfActivationHelper\n*L\n42#1:148,2\n*E\n"})
public final class SelfActivationHelper {
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final Map<UUID, UUID> lastPlayerActivationIds;
    @NotNull
    private final Map<UUID, UUID> sourceIdToPlayerId;
    @NotNull
    private final Map<UUID, Set<UUID>> playerIdToSourceIds;

    public SelfActivationHelper(@NotNull PlasmoBaseVoiceServer voiceServer) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        this.voiceServer = voiceServer;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
        this.lastPlayerActivationIds = concurrentMap;
        ConcurrentMap concurrentMap2 = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap2, "newConcurrentMap(...)");
        this.sourceIdToPlayerId = concurrentMap2;
        ConcurrentMap concurrentMap3 = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap3, "newConcurrentMap(...)");
        this.playerIdToSourceIds = concurrentMap3;
    }

    public final void cleanupPlayer(@NotNull UUID playerId) {
        block1: {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            this.lastPlayerActivationIds.remove(playerId);
            Set<UUID> set = this.playerIdToSourceIds.remove(playerId);
            if (set == null) break block1;
            Set<UUID> playerSources = set;
            boolean bl = false;
            Iterable $this$forEach$iv = playerSources;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID it = (UUID)element$iv;
                boolean bl2 = false;
                this.sourceIdToPlayerId.remove(it);
            }
        }
    }

    public final void sendAudioInfo(@NotNull VoicePlayer player, @NotNull ServerAudioSource<?> source2, @NotNull PlayerAudioPacket playerPacket, @NotNull SourceAudioPacket sourcePacket) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(playerPacket, "playerPacket");
        Intrinsics.checkNotNullParameter(sourcePacket, "sourcePacket");
        UUID uUID = playerPacket.getActivationId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getActivationId(...)");
        this.sendAudioInfo(player, source2, uUID, sourcePacket, playerPacket.getData().length != sourcePacket.getData().length);
    }

    public final void sendAudioInfo(@NotNull VoicePlayer player, @NotNull ServerAudioSource<?> source2, @NotNull UUID activationId, @NotNull SourceAudioPacket packet, boolean dataChanged) {
        Set set;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(activationId, "activationId");
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.sourceIdToPlayerId.put(source2.getId(), player.getInstance().getUuid());
        Set it = set = this.playerIdToSourceIds.computeIfAbsent(player.getInstance().getUuid(), arg_0 -> SelfActivationHelper.sendAudioInfo$lambda$3(SelfActivationHelper::sendAudioInfo$lambda$2, arg_0));
        boolean bl = false;
        UUID uUID = source2.getId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getId(...)");
        it.add(uUID);
        UUID lastActivationId = this.lastPlayerActivationIds.put(player.getInstance().getUuid(), activationId);
        if (lastActivationId == null || !Intrinsics.areEqual(lastActivationId, activationId)) {
            this.updateSelfSourceInfo(player, source2);
        }
        this.voiceServer.getUdpConnectionManager().getConnectionByPlayerId(player.getInstance().getUuid()).ifPresent(arg_0 -> SelfActivationHelper.sendAudioInfo$lambda$5(new Function1<?, Unit>(source2, packet, dataChanged){
            final /* synthetic */ ServerAudioSource<?> $source;
            final /* synthetic */ SourceAudioPacket $packet;
            final /* synthetic */ boolean $dataChanged;
            {
                this.$source = $source;
                this.$packet = $packet;
                this.$dataChanged = $dataChanged;
            }

            public final void invoke(UdpConnection connection) {
                Intrinsics.checkNotNullParameter(connection, "connection");
                connection.sendPacket(new SelfAudioInfoPacket(this.$source.getId(), this.$packet.getSequenceNumber(), this.$dataChanged ? this.$packet.getData() : null, this.$packet.getDistance()));
            }
        }, arg_0));
    }

    public final void updateSelfSourceInfo(@NotNull VoicePlayer player, @NotNull ServerAudioSource<?> source2) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(source2, "source");
        source2.resolveSourceInfo().thenApply(arg_0 -> SelfActivationHelper.updateSelfSourceInfo$lambda$6(new Function1(this, player){
            final /* synthetic */ SelfActivationHelper this$0;
            final /* synthetic */ VoicePlayer $player;
            {
                this.this$0 = $receiver;
                this.$player = $player;
            }

            public final void invoke(SourceInfo it) {
                Intrinsics.checkNotNull(it);
                this.this$0.updateSelfSourceInfo(this.$player, it);
            }
        }, arg_0));
    }

    public final void updateSelfSourceInfo(@NotNull VoicePlayer player, @NotNull SourceInfo sourceInfo) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(sourceInfo, "sourceInfo");
        UUID uUID = this.lastPlayerActivationIds.get(player.getInstance().getUuid());
        if (uUID == null) {
            return;
        }
        UUID lastActivationId = uUID;
        player.sendPacket(new SelfSourceInfoPacket(new SelfSourceInfo(sourceInfo, player.getInstance().getUuid(), lastActivationId, -1L)));
    }

    @EventSubscribe(priority=EventPriority.HIGHEST)
    public final void onSourceAudioPacket(@NotNull ServerSourceAudioPacketEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        PlayerActivationInfo playerActivationInfo = event.getActivationInfo();
        if (playerActivationInfo == null) {
            return;
        }
        PlayerActivationInfo playerActivationInfo2 = playerActivationInfo;
        VoicePlayer player = playerActivationInfo2.component1();
        PlayerAudioPacket audioPacket = playerActivationInfo2.component2();
        ServerAudioSource<?> source2 = event.getSource();
        SourceAudioPacket packet = event.getPacket();
        Intrinsics.checkNotNull(source2);
        Intrinsics.checkNotNull(packet);
        this.sendAudioInfo(player, source2, audioPacket, packet);
    }

    @EventSubscribe(priority=EventPriority.HIGHEST)
    public final void onSourceSendPacket(@NotNull ServerSourcePacketEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ServerAudioSource<?> source2 = event.getSource();
        Packet<?> packet = event.getPacket();
        UUID uUID = this.sourceIdToPlayerId.get(source2.getId());
        if (uUID == null) {
            return;
        }
        UUID playerId = uUID;
        if (!this.lastPlayerActivationIds.containsKey(playerId)) {
            return;
        }
        Optional<?> optional = this.voiceServer.getPlayerManager().getPlayerById(playerId, false);
        Intrinsics.checkNotNullExpressionValue(optional, "getPlayerById(...)");
        VoicePlayer voicePlayer = (VoicePlayer)OptionalsKt.getOrNull(optional);
        if (voicePlayer == null) {
            this.cleanupPlayer(playerId);
            return;
        }
        VoicePlayer player = voicePlayer;
        if (packet instanceof SourceInfoPacket) {
            SourceInfo sourceInfo = ((SourceInfoPacket)packet).getSourceInfo();
            Intrinsics.checkNotNullExpressionValue(sourceInfo, "getSourceInfo(...)");
            this.updateSelfSourceInfo(player, sourceInfo);
        } else if (packet instanceof SourceAudioEndPacket) {
            player.sendPacket(new SourceAudioEndPacket(source2.getId(), ((SourceAudioEndPacket)packet).getSequenceNumber()));
        }
    }

    @EventSubscribe
    public final void onClientDisconnected(@NotNull UdpClientDisconnectedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cleanupPlayer(event.getConnection().getPlayer().getInstance().getUuid());
    }

    private static final Set sendAudioInfo$lambda$2(UUID uUID) {
        Intrinsics.checkNotNullParameter(uUID, "<unused var>");
        return new CopyOnWriteArraySet();
    }

    private static final Set sendAudioInfo$lambda$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final void sendAudioInfo$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit updateSelfSourceInfo$lambda$6(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }
}

