/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.tree;

import com.misterpemodder.shulkerboxtooltip.impl.tree.CategoryConfigNode;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ConfigNode;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueConfigNode<C, T, V>
implements ConfigNode<C> {
    private String name;
    private class_2561 title;
    private class_2561 tooltip;
    private class_2561 prefix;
    private Class<? extends T> type;
    private Class<? extends V> valueType;
    private boolean requiresRestart;
    private ValueReader<C, V> valueReader;
    private ValueWriter<C, V> valueWriter;
    @Nullable
    private ValueReader<class_2487, V> nbtReader;
    @Nullable
    private ValueWriter<class_2487, V> nbtWriter;
    @Nullable
    private ValueValidator<V> validator;
    private V defaultValue;
    private V editingValue;
    private CategoryConfigNode<C> category;

    private ValueConfigNode() {
    }

    public static <C, T, V> Builder<C, T, V> builder() {
        return new Builder();
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    @NotNull
    public Class<? extends V> getValueType() {
        return this.valueType;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public V getActiveValue(C config) {
        return this.valueReader.read(config);
    }

    public void setActiveValue(C config, V value) {
        this.valueWriter.write(config, value);
    }

    public V getEditingValue(C config) {
        if (this.editingValue == null) {
            this.setEditingValue(this.getActiveValue(config));
        }
        return this.editingValue;
    }

    public void setEditingValue(V value) {
        this.editingValue = value;
    }

    @Override
    public void resetToDefault() {
        this.setEditingValue(this.getDefaultValue());
    }

    @Override
    public void resetToActive(C config) {
        this.setEditingValue(this.getActiveValue(config));
    }

    @Override
    public boolean isDefaultValue(C config) {
        return Objects.equals(this.getDefaultValue(), this.getEditingValue(config));
    }

    @Override
    public boolean isActiveValue(C config) {
        return Objects.equals(this.getActiveValue(config), this.getEditingValue(config));
    }

    @Override
    public class_2561 validate(C config) {
        return this.validator == null ? null : this.validator.validate(this.getEditingValue(config));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public class_2561 getTooltip() {
        return this.tooltip;
    }

    @Override
    @Nullable
    public class_2561 getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean restartRequired(C config) {
        return this.requiresRestart && !this.isActiveValue(config);
    }

    @Override
    public void writeToNbt(C config, class_2487 compound) {
        if (this.nbtWriter == null) {
            return;
        }
        this.nbtWriter.write(compound, this.getActiveValue(config));
    }

    @Override
    public void readFromNbt(C config, class_2487 compound) {
        if (this.nbtReader == null) {
            return;
        }
        this.setActiveValue(config, this.nbtReader.read(compound));
    }

    @Override
    public void copy(C from, C to) {
        this.setActiveValue(to, this.getActiveValue(from));
    }

    @Override
    public void writeEditingToConfig(C config) {
        this.setActiveValue(config, this.getEditingValue(config));
    }

    public static class Builder<C, T, V> {
        private ValueConfigNode<C, T, V> node = new ValueConfigNode();

        private Builder() {
        }

        public Builder<C, T, V> type(Class<? extends T> type) {
            this.node.type = type;
            return this;
        }

        public Builder<C, T, V> valueType(Class<? extends V> valueType) {
            this.node.valueType = valueType;
            return this;
        }

        public Builder<C, T, V> name(String name) {
            this.node.name = name;
            return this;
        }

        public Builder<C, T, V> title(class_2561 title) {
            this.node.title = title;
            return this;
        }

        public Builder<C, T, V> tooltip(class_2561 tooltip) {
            this.node.tooltip = tooltip;
            return this;
        }

        public Builder<C, T, V> prefix(class_2561 prefix) {
            this.node.prefix = prefix;
            return this;
        }

        public Builder<C, T, V> defaultValue(V defaultValue) {
            this.node.defaultValue = defaultValue;
            return this;
        }

        public Builder<C, T, V> requiresRestart(boolean requiresRestart) {
            this.node.requiresRestart = requiresRestart;
            return this;
        }

        public Builder<C, T, V> valueReader(ValueReader<C, V> valueReader) {
            this.node.valueReader = valueReader;
            return this;
        }

        public Builder<C, T, V> valueWriter(ValueWriter<C, V> valueWriter) {
            this.node.valueWriter = valueWriter;
            return this;
        }

        public Builder<C, T, V> validator(ValueValidator<V> validator) {
            this.node.validator = validator;
            return this;
        }

        public Builder<C, T, V> nbtReader(ValueReader<class_2487, V> nbtReader) {
            this.node.nbtReader = nbtReader;
            return this;
        }

        public Builder<C, T, V> nbtWriter(ValueWriter<class_2487, V> nbtWriter) {
            this.node.nbtWriter = nbtWriter;
            return this;
        }

        public Builder<C, T, V> category(CategoryConfigNode<C> category) {
            this.node.category = category;
            return this;
        }

        public ValueConfigNode<C, T, V> build() {
            ValueConfigNode<C, T, V> n = this.node;
            Objects.requireNonNull(n.name);
            Objects.requireNonNull(n.type);
            Objects.requireNonNull(n.valueType);
            Objects.requireNonNull(n.title);
            Objects.requireNonNull(n.valueReader);
            Objects.requireNonNull(n.valueWriter);
            Objects.requireNonNull(n.category);
            this.node = null;
            return n;
        }
    }

    @FunctionalInterface
    public static interface ValueReader<S, V> {
        public V read(S var1);
    }

    @FunctionalInterface
    public static interface ValueWriter<S, V> {
        public void write(S var1, V var2);
    }

    public static interface ValueValidator<V> {
        @Nullable
        public class_2561 validate(V var1);
    }
}

