/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui.options.control;

import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlValueFormatter;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class SliderControlExtended
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;
    private final boolean displayIntValueWhileSliding;

    public SliderControlExtended(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode, boolean displayIntValueWhileSliding) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
        this.displayIntValueWhileSliding = displayIntValueWhileSliding;
    }

    public ControlElement<Integer> createElement(Dim2i dim) {
        return new Slider(this.option, dim, this.min, this.max, this.interval, this.mode, this.displayIntValueWhileSliding);
    }

    public Option<Integer> getOption() {
        return this.option;
    }

    public int getMaxWidth() {
        return 130;
    }

    private static class Slider
    extends ControlElement<Integer> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final ControlValueFormatter formatter;
        private final boolean displayIntValueWhileSliding;
        private final int min;
        private final int range;
        private final int interval;
        private double thumbPosition;

        public Slider(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter, boolean displayIntValueWhileSliding) {
            super(option, dim);
            this.min = min;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue((Integer)option.getValue());
            this.formatter = formatter;
            this.displayIntValueWhileSliding = displayIntValueWhileSliding;
        }

        public Dim2i getSliderBounds() {
            return new Dim2i(this.dim.getLimitX() - 96, this.dim.getCenterY() - 5, 90, 10);
        }

        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
            super.method_25394(guiGraphics, mouseX, mouseY, delta);
            if (this.option.isAvailable() && this.hovered) {
                this.renderSlider(guiGraphics);
            } else {
                this.renderStandaloneValue(guiGraphics);
            }
        }

        private void renderStandaloneValue(class_332 guiGraphics) {
            int sliderX = this.getSliderBounds().x();
            int sliderY = this.getSliderBounds().y();
            int sliderWidth = this.getSliderBounds().width();
            int sliderHeight = this.getSliderBounds().height();
            class_2561 label = this.formatter.format(((Integer)this.option.getValue()).intValue());
            int labelWidth = this.font.method_27525((class_5348)label);
            this.drawString(guiGraphics, label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider(class_332 guiGraphics) {
            int sliderX = this.getSliderBounds().x();
            int sliderY = this.getSliderBounds().y();
            int sliderWidth = this.getSliderBounds().width();
            int sliderHeight = this.getSliderBounds().height();
            this.thumbPosition = this.getThumbPositionForValue((Integer)this.option.getValue());
            double thumbOffset = class_3532.method_15350((double)((double)(this.getIntValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
            double thumbX = (double)sliderX + thumbOffset - 2.0;
            double trackY = (double)(sliderY + sliderHeight / 2) - 0.5;
            this.drawRect(guiGraphics, (int)thumbX, sliderY, (int)(thumbX + 4.0), sliderY + sliderHeight, -1);
            this.drawRect(guiGraphics, sliderX, (int)trackY, sliderX + sliderWidth, (int)(trackY + 1.0), -1);
            class_5250 label = this.displayIntValueWhileSliding ? class_2561.method_43470((String)String.valueOf(this.getIntValue())) : this.formatter.format(((Integer)this.option.getValue()).intValue());
            int labelWidth = this.font.method_27525((class_5348)label);
            this.drawString(guiGraphics, (class_2561)label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public int getIntValue() {
            return this.min + this.interval * (int)Math.round(this.getSnappedThumbPosition() / (double)this.interval);
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(int value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        public boolean method_25402(@NotNull class_11909 mouseButtonEvent, boolean bl) {
            if (this.option.isAvailable() && mouseButtonEvent.method_74245() == 0 && this.getSliderBounds().containsCursor(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799())) {
                this.setValueFromMouse(mouseButtonEvent.comp_4798());
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.getSliderBounds().x()) / (double)this.getSliderBounds().width());
        }

        private void setValue(double d) {
            this.thumbPosition = class_3532.method_15350((double)d, (double)0.0, (double)1.0);
            int value = this.getIntValue();
            if ((Integer)this.option.getValue() != value) {
                this.option.setValue((Object)value);
            }
        }

        public boolean method_25403(class_11909 mouseButtonEvent, double d, double e) {
            if (this.option.isAvailable() && mouseButtonEvent.method_74245() == 0) {
                this.setValueFromMouse(mouseButtonEvent.comp_4798());
                return true;
            }
            return false;
        }
    }
}

