/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.blur;

import eu.midnightdust.blur.config.BlurConfig;
import eu.midnightdust.blur.mixin.GuiGraphicsAccessor;
import eu.midnightdust.blur.mixin.GuiRenderStateAccessor;
import eu.midnightdust.blur.util.AnimationHandler;
import eu.midnightdust.blur.util.RainbowColor;
import eu.midnightdust.blur.util.TimingHandler;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.awt.Color;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Math;
import org.joml.Matrix3x2fStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blur {
    public static final String MOD_ID = "blur";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"blur");
    public static class_310 minecraft = class_310.method_1551();
    private static final TimingHandler timingHandler = new TimingHandler();
    public static final AnimationHandler blurAnimation = new AnimationHandler();
    public static final AnimationHandler backgroundAnimation = new AnimationHandler();
    public static boolean isProcessingRenderPass = false;
    public static boolean forceRenderedBackground = false;

    public static void init() {
        BlurConfig.init((String)MOD_ID, BlurConfig.class);
    }

    public static boolean canBlur(class_332 graphics) {
        return ((GuiRenderStateAccessor)((GuiGraphicsAccessor)graphics).getGuiRenderState()).getFirstStratumAfterBlur() == Integer.MAX_VALUE;
    }

    public static void onRender() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        if (Blur.minecraft.field_1755 != null) {
            LOGGER.debug("onRender: {}", (Object)Blur.minecraft.field_1755.getClass().getCanonicalName());
        } else {
            LOGGER.debug("onRender: null");
        }
        if (!isProcessingRenderPass) {
            isProcessingRenderPass = true;
            Blur.blurAnimation.enabled = false;
            Blur.backgroundAnimation.enabled = false;
            forceRenderedBackground = false;
        } else {
            LOGGER.debug("onRender has been called multiple times in one render pass: {}, has blur: {}, has background: {}", new Object[]{Blur.minecraft.field_1755, Blur.blurAnimation.enabled, Blur.backgroundAnimation.enabled});
        }
    }

    public static void renderBlurredBackground(class_332 context) {
        if (Blur.blurAnimation.progress < 0.001f) {
            return;
        }
        if (Blur.canBlur(context)) {
            context.method_71278();
        }
    }

    public static void renderBackground(class_332 context) {
        if (!forceRenderedBackground) {
            Blur.renderBlurredBackground(context);
            Blur.renderRotatedGradient(context);
            forceRenderedBackground = true;
        } else {
            LOGGER.debug("renderBackground has been called multiple times in one render pass: {}, has blur: {}, has background: {}", new Object[]{Blur.minecraft.field_1755, Blur.blurAnimation.enabled, Blur.backgroundAnimation.enabled});
        }
    }

    public static int getBackgroundGradiantColor(boolean second) {
        int alpha = (int)(Blur.backgroundAnimation.progress * (float)(second ? BlurConfig.gradientEndAlpha : BlurConfig.gradientStartAlpha));
        Color color = BlurConfig.rainbowMode ? Color.getHSBColor(second ? RainbowColor.hue : RainbowColor.hue2, 1.0f, 1.0f) : MidnightColorUtil.hex2Rgb((String)(second ? BlurConfig.gradientEnd : BlurConfig.gradientStart));
        int red = color.getRed();
        int blue = color.getBlue();
        int green = color.getGreen();
        return alpha << 24 | red << 16 | blue << 8 | green;
    }

    public static int getBackgroundGradiantRotation() {
        if (BlurConfig.rainbowMode) {
            return RainbowColor.rotation;
        }
        return BlurConfig.gradientRotation;
    }

    public static void renderRotatedGradient(class_332 context) {
        if (!BlurConfig.useGradient || Blur.backgroundAnimation.progress < 0.001f) {
            return;
        }
        int width = context.method_51421();
        int height = context.method_51443();
        float diagonal = Math.sqrt((float)((float)width * (float)width + (float)(height * height)));
        int smallestDimension = Math.min((int)width, (int)height);
        float rotation = Math.toRadians((float)Blur.getBackgroundGradiantRotation());
        int first_color = Blur.getBackgroundGradiantColor(false);
        int second_color = Blur.getBackgroundGradiantColor(true);
        context.method_51448().pushMatrix();
        Matrix3x2fStack posMatrix = context.method_51448();
        posMatrix.rotate(rotation);
        posMatrix.setTranslation((float)width / 2.0f, (float)height / 2.0f);
        posMatrix.scale(diagonal / (float)smallestDimension);
        context.method_25296(-width / 2, -height / 2, width / 2, height / 2, first_color, second_color);
        context.method_51448().popMatrix();
    }

    public static void onRenderEnd() {
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        if (Blur.minecraft.field_1755 != null) {
            LOGGER.debug("onRenderEnd: {}", (Object)Blur.minecraft.field_1755.getClass().getCanonicalName());
        } else {
            LOGGER.debug("onRenderEnd: null");
        }
        if (isProcessingRenderPass) {
            LOGGER.debug("processed render pass: {}, has blur: {}, has background: {}", new Object[]{Blur.minecraft.field_1755, Blur.blurAnimation.enabled, Blur.backgroundAnimation.enabled});
            String screenName = null;
            if (Blur.minecraft.field_1755 != null) {
                screenName = Blur.minecraft.field_1755.getClass().getCanonicalName();
            }
            if (screenName != null && BlurConfig.forceEnabledScreens.contains(screenName)) {
                Blur.blurAnimation.enabled = true;
                Blur.backgroundAnimation.enabled = true;
            }
            if (screenName != null && BlurConfig.forceDisabledScreens.contains(screenName)) {
                Blur.blurAnimation.enabled = false;
                Blur.backgroundAnimation.enabled = false;
            }
            long deltaTime = timingHandler.getDeltaTimeNanos();
            blurAnimation.updateAnimation(deltaTime, BlurConfig.blurAnimationCurve);
            backgroundAnimation.updateAnimation(deltaTime, BlurConfig.backgroundAnimationCurve);
            isProcessingRenderPass = false;
        } else {
            LOGGER.debug("onRenderEnd has been called multiple times in one render pass: {}, has blur: {}, has background: {}", new Object[]{Blur.minecraft.field_1755, Blur.blurAnimation.enabled, Blur.backgroundAnimation.enabled});
        }
    }

    public static class BlurFabric
    implements ModInitializer,
    ClientModInitializer {
        public void onInitialize() {
            Blur.init();
        }

        public void onInitializeClient() {
            ClientTickEvents.END_CLIENT_TICK.register(client -> RainbowColor.tick());
        }
    }
}

