/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.blur.config;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.EntryInfo;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.config.MidnightConfigListWidget;
import eu.midnightdust.lib.config.MidnightConfigScreen;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_8662;

public class BlurConfig
extends MidnightConfig {
    public static final String ANIMATIONS = "animations";
    public static final String STYLE = "style";
    public static final String SCREENS = "screens";
    @MidnightConfig.Entry
    @MidnightConfig.Hidden
    public static int configVersion = 2;
    @MidnightConfig.Comment(category="screens", centered=true)
    public static MidnightConfig.Comment _general;
    @MidnightConfig.Entry(category="screens")
    public static boolean blurContainers;
    @MidnightConfig.Entry(category="screens")
    public static boolean blurBooks;
    @MidnightConfig.Entry(category="screens")
    public static boolean blurSigns;
    @MidnightConfig.Entry(category="screens")
    public static boolean blurCommandBlocks;
    @MidnightConfig.Entry(category="screens")
    public static boolean blurTitleScreen;
    @MidnightConfig.Entry(category="screens")
    public static boolean darkenTitleScreen;
    @MidnightConfig.Comment(category="screens", centered=true)
    public static MidnightConfig.Comment _advanced;
    @MidnightConfig.Entry(category="screens")
    public static List<String> forceEnabledScreens;
    @MidnightConfig.Entry(category="screens")
    public static List<String> forceDisabledScreens;
    @MidnightConfig.Comment(category="style", centered=true)
    public static MidnightConfig.Comment _gradient;
    @MidnightConfig.Entry(category="style")
    public static boolean useGradient;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isColor=true, width=7, min=7.0)
    public static String gradientStart;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=255.0)
    public static int gradientStartAlpha;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isColor=true, width=7, min=7.0)
    public static String gradientEnd;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=255.0)
    public static int gradientEndAlpha;
    @MidnightConfig.Condition(requiredOption="useGradient", visibleButLocked=true)
    @MidnightConfig.Entry(category="style", isSlider=true, min=0.0, max=360.0)
    public static int gradientRotation;
    @MidnightConfig.Entry(category="style")
    public static boolean rainbowMode;
    @MidnightConfig.Comment(category="animations", centered=true)
    public static MidnightConfig.Comment _animations;
    @MidnightConfig.Entry(category="animations", min=0.0, max=2000.0, isSlider=true)
    public static int fadeTimeMillis;
    @MidnightConfig.Entry(category="animations", min=0.0, max=2000.0, isSlider=true)
    public static int fadeOutTimeMillis;
    @MidnightConfig.Entry(category="animations")
    public static Easing blurAnimationCurve;
    @MidnightConfig.Entry(category="animations")
    public static Easing backgroundAnimationCurve;

    public void onTabInit(String tabName, MidnightConfigListWidget list, MidnightConfigScreen screen) {
        if (Objects.equals(tabName, STYLE)) {
            EntryInfo centered = new EntryInfo(null, "blur");
            centered.comment = new MidnightConfig.Comment(this){

                public boolean centered() {
                    return true;
                }

                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                public String category() {
                    return "";
                }

                public String name() {
                    return "";
                }

                public String url() {
                    return "";
                }

                public String requiredMod() {
                    return "";
                }
            };
            RadiusSliderWidget slider = new RadiusSliderWidget(screen.field_22789 - 185, 0, 150, 20);
            class_8662 resetButton = class_8662.method_52723((class_2561)class_2561.method_43471((String)"controls.reset"), button -> {
                class_310.method_1551().field_1690.method_57702().method_41748((Object)5);
                screen.updateList();
            }, (boolean)true).method_52727(class_2960.method_60655((String)"midnightlib", (String)"icon/reset"), 12, 12).method_52726(20, 20).method_52724();
            resetButton.method_48229(screen.field_22789 - 205 + 150 + 25, 0);
            slider.resetButton = resetButton;
            slider.method_25346();
            list.addButton((List)Lists.newArrayList(), (class_2561)class_2561.method_43471((String)"%s.midnightconfig._blur".formatted("blur")), centered);
            list.addButton((List)Lists.newArrayList((Object[])new class_339[]{slider, resetButton}), (class_2561)class_2561.method_43471((String)"%s.midnightconfig.radius".formatted("blur")), new EntryInfo(null, "blur"));
        }
    }

    static {
        blurContainers = true;
        blurBooks = true;
        blurSigns = true;
        blurCommandBlocks = true;
        blurTitleScreen = false;
        darkenTitleScreen = false;
        forceEnabledScreens = Lists.newArrayList((Object[])new String[]{"dev.emi.emi.screen.RecipeScreen"});
        forceDisabledScreens = Lists.newArrayList((Object[])new String[]{"net.irisshaders.iris.gui.screen.ShaderPackScreen"});
        useGradient = true;
        gradientStart = "#000000";
        gradientStartAlpha = 75;
        gradientEnd = "#000000";
        gradientEndAlpha = 75;
        gradientRotation = 0;
        rainbowMode = false;
        fadeTimeMillis = 300;
        fadeOutTimeMillis = 300;
        blurAnimationCurve = Easing.FLAT;
        backgroundAnimationCurve = Easing.FLAT;
    }

    public static class RadiusSliderWidget
    extends class_357 {
        class_8662 resetButton;

        public RadiusSliderWidget(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), (double)((Integer)class_310.method_1551().field_1690.method_57702().method_41753()).intValue() / 20.0);
        }

        public void method_25346() {
            this.method_25355(class_2561.method_30163((String)String.valueOf(class_310.method_1551().field_1690.method_57702().method_41753())));
            if (this.resetButton != null) {
                this.resetButton.field_22763 = (Integer)class_310.method_1551().field_1690.method_57702().method_41753() != 5;
            }
        }

        public void method_25344() {
            class_310.method_1551().field_1690.method_57702().method_41748((Object)Double.valueOf(this.field_22753 * 20.0).intValue());
        }
    }

    public static enum Easing {
        FLAT(x -> x),
        SINE(x -> 0.5 - Math.cos(x * Math.PI) / 2.0),
        QUAD(x -> x * x),
        CUBIC(x -> x * x * x),
        QUART(x -> x * x * x * x),
        QUINT(x -> x * x * x * x * x),
        EXPO(x -> x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0)),
        CIRC(x -> 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0))),
        BACK(x -> 2.70158 * x * x * x - 1.70158 * x * x),
        ELASTIC(x -> x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * 2.0943951023931953)));

        final Function<Double, Number> function;

        private Easing(Function<Double, Number> function) {
            this.function = function;
        }

        public Double apply(Double x) {
            return this.function.apply(x).doubleValue();
        }
    }
}

