/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.blur.util;

import eu.midnightdust.blur.config.BlurConfig;
import org.joml.Math;

public class AnimationHandler {
    public float timeState = 0.0f;
    public float progress = 0.0f;
    public boolean enabled = false;

    public void updateAnimation(long delta, BlurConfig.Easing easing) {
        if (delta <= 0L) {
            return;
        }
        float newFadeTimeState = this.timeState;
        float newFadeProgress = this.progress;
        if (this.enabled) {
            if (BlurConfig.fadeTimeMillis > 0) {
                newFadeTimeState += (float)delta / (float)(BlurConfig.fadeTimeMillis * 1000000);
                newFadeTimeState = Math.clamp((float)0.0f, (float)1.0f, (float)newFadeTimeState);
                newFadeProgress = easing.apply(Double.valueOf(newFadeTimeState)).floatValue();
            } else {
                newFadeTimeState = 1.0f;
                newFadeProgress = 1.0f;
            }
        } else if (BlurConfig.fadeOutTimeMillis > 0) {
            newFadeTimeState -= (float)delta / (float)(BlurConfig.fadeOutTimeMillis * 1000000);
            newFadeTimeState = Math.clamp((float)0.0f, (float)1.0f, (float)newFadeTimeState);
            newFadeProgress = 1.0f - easing.apply(1.0 - (double)newFadeTimeState).floatValue();
        } else {
            newFadeTimeState = 0.0f;
            newFadeProgress = 0.0f;
        }
        this.timeState = Math.clamp((float)0.0f, (float)1.0f, (float)newFadeTimeState);
        this.progress = Math.clamp((float)0.0f, (float)1.0f, (float)newFadeProgress);
    }
}

