/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_703;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.particle.CustomParticle;
import pigcart.particlerain.particle.StreakParticle;

public final class WeatherParticleManager {
    private static final class_5819 random = class_5819.method_43047();
    private static final class_2338.class_2339 pos = new class_2338.class_2339();
    private static final class_2338.class_2339 heightmapPos = new class_2338.class_2339();
    public static int afterWeatherTicksLeft = 0;
    public static int spawnAttemptsUntilBlockFXIdle = 0;
    public static int ticksUntilSurfaceFXIdle = 0;
    public static int ticksUntilSkyFXIdle = 0;
    public static int particleCount = 0;

    public static int getParticleCount() {
        return particleCount;
    }

    public static void tick(class_638 level, class_243 cameraPos) {
        if (particleCount >= ConfigManager.config.perf.maxParticleAmount) {
            return;
        }
        WeatherParticleManager.tickSkyFX(level, cameraPos);
        WeatherParticleManager.tickSurfaceFX(level, cameraPos);
        if (afterWeatherTicksLeft > 0) {
            --afterWeatherTicksLeft;
        }
    }

    public static void onWeatherChange(boolean isRaining) {
        afterWeatherTicksLeft = isRaining ? 0 : random.method_43048(6000);
    }

    public static void tickBlockFX(class_2338.class_2339 sourcePos, class_2680 state) {
        class_638 level = class_310.method_1551().field_1687;
        if (spawnAttemptsUntilBlockFXIdle <= 0 && random.method_43057() < 0.9f) {
            return;
        }
        --spawnAttemptsUntilBlockFXIdle;
        if (!state.method_26220((class_1922)level, (class_2338)sourcePos).method_1110()) {
            return;
        }
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            Vector3f relativePos;
            class_2350 direction;
            if (!opts.enabled || !opts.weather.isCurrent(level)) continue;
            class_6880 biome = level.method_23753((class_2338)sourcePos);
            switch (opts.spawnPos) {
                case BLOCK_SIDES: {
                    class_2350 class_23502 = class_2350.class_2353.field_11062.method_10183(random);
                    break;
                }
                case BLOCK_BOTTOM: {
                    class_2350 class_23502 = class_2350.field_11033;
                    break;
                }
                case BLOCK_TOP: {
                    class_2350 class_23502 = class_2350.field_11036;
                    break;
                }
                default: {
                    class_2350 class_23502 = direction = null;
                }
            }
            if (direction == null) continue;
            class_2350 opposite = direction.method_10153();
            pos.method_10103(sourcePos.method_10263() + opposite.method_10148(), sourcePos.method_10264() + opposite.method_10164(), sourcePos.method_10260() + opposite.method_10165());
            class_2680 blockState = level.method_8320((class_2338)pos);
            class_3610 fluidState = blockState.method_26227();
            if (blockState.method_26220((class_1922)level, (class_2338)pos).method_1110() && fluidState.method_15769() || opts.spawnPos != ConfigData.SpawnPos.BLOCK_BOTTOM && opts.spawnPos != ConfigData.SpawnPos.BLOCK_SIDES && opts.spawnPos != ConfigData.SpawnPos.BLOCK_TOP || !opts.precipitation.contains(VersionUtil.getPrecipitationAt((class_1937)level, (class_6880<class_1959>)biome, (class_2338)sourcePos)) || !(opts.density > random.method_43057()) || !opts.biomeList.contains(biome) || !opts.blockList.contains(level.method_8320((class_2338)pos).method_41520()) || opts.needsSkyAccess && sourcePos.method_10264() < level.method_8624(class_2902.class_2903.field_13197, sourcePos.method_10263(), sourcePos.method_10260())) continue;
            float p1 = random.method_43057();
            float p2 = random.method_43057();
            if (direction.method_10171().equals((Object)class_2350.class_2352.field_11056)) {
                double max = blockState.method_26220((class_1922)level, (class_2338)pos).method_1102(direction.method_10166(), (double)p1, (double)p2);
                if (direction == class_2350.field_11036) {
                    max = Math.max(max, (double)fluidState.method_15763((class_1922)level, (class_2338)pos));
                }
                if (max == Double.NEGATIVE_INFINITY) continue;
                relativePos = new Vector3f(p2 - 0.5f, (float)(max += 0.01) - 0.5f, p1 - 0.5f);
            } else {
                double min = blockState.method_26220((class_1922)level, (class_2338)pos).method_35593(direction.method_10166(), (double)p1, (double)p2);
                if (min == Double.POSITIVE_INFINITY) continue;
                relativePos = new Vector3f(p2 - 0.5f, (float)(min -= 0.01) - 0.5f, p1 - 0.5f);
            }
            relativePos.rotate((Quaternionfc)(switch (direction) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11036, class_2350.field_11033 -> new Quaternionf();
                case class_2350.field_11035, class_2350.field_11043 -> new Quaternionf().rotationXYZ(1.5707964f, 1.5707964f, 0.0f);
                case class_2350.field_11034, class_2350.field_11039 -> new Quaternionf().rotationXYZ(-1.5707964f, 0.0f, -1.5707964f);
            }));
            float x = (float)pos.method_10263() + relativePos.x + 0.5f;
            float y = (float)pos.method_10264() + relativePos.y + 0.5f;
            float z = (float)pos.method_10260() + relativePos.z + 0.5f;
            if (opts.usePresetParticle) {
                if (opts.presetParticleId.equals("particlerain:streak")) {
                    class_310.method_1551().field_1713.method_3058((class_703)new StreakParticle(level, x, y, z, direction, opts.blockList));
                } else {
                    level.method_8406(opts.presetParticle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                }
            } else {
                class_310.method_1551().field_1713.method_3058((class_703)new CustomParticle(level, (double)x, (double)y, (double)z, opts));
            }
            spawnAttemptsUntilBlockFXIdle = 10000;
        }
    }

    public static void tickSkyFX(class_638 level, class_243 cameraPos) {
        float speed;
        int density;
        if (ticksUntilSkyFXIdle <= 0) {
            density = 4;
            speed = 0.0f;
        } else {
            --ticksUntilSkyFXIdle;
            density = (int)((float)class_3532.method_48781((float)level.method_8478(1.0f), (int)ConfigManager.config.perf.particleDensity, (int)ConfigManager.config.perf.particleStormDensity) * level.method_8430(1.0f));
            speed = (float)class_310.method_1551().method_1560().method_18798().method_1033();
            density = (int)((float)density * (1.0f + speed));
        }
        for (int i = 0; i < density; ++i) {
            float height;
            if ((double)speed < 0.8) {
                height = class_3532.method_15379((float)(class_3532.method_27285((float)random.method_43057()) - class_3532.method_27285((float)random.method_43057()))) * -1.0f + 1.0f;
                height *= 1.0f;
            } else {
                height = random.method_43057();
            }
            float theta = (float)Math.PI * 2 * random.method_43057();
            float phi = (float)Math.acos(2.0f * height - 1.0f);
            float x = (float)ConfigManager.config.perf.particleDistance * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta) + (float)cameraPos.field_1352;
            float y = (float)ConfigManager.config.perf.particleDistance * class_3532.method_15362((float)phi) + (float)cameraPos.field_1351;
            float z = (float)ConfigManager.config.perf.particleDistance * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta) + (float)cameraPos.field_1350;
            pos.method_10102((double)x, (double)y, (double)z);
            if (ConfigManager.config.compat.doSpawnHeightLimit) {
                int cloudHeight;
                int n = cloudHeight = ConfigManager.config.compat.spawnHeightLimit == 0 ? VersionUtil.getCloudHeight(level, (class_2338)pos) : ConfigManager.config.compat.spawnHeightLimit;
                if (cloudHeight != 0 && y > (float)cloudHeight) {
                    y = cloudHeight;
                }
            }
            int heightmapY = level.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260());
            heightmapPos.method_10102((double)x, (double)(heightmapY - 1), (double)z);
            if (heightmapY > pos.method_10264()) continue;
            class_6880 biome = level.method_23753((class_2338)pos);
            class_1959.class_1963 precipitation = VersionUtil.getPrecipitationAt((class_1937)level, (class_6880<class_1959>)biome, (class_2338)(ConfigManager.config.compat.useHeightmapTemp ? heightmapPos : pos));
            for (ConfigData.ParticleData data : ConfigManager.config.particles) {
                if (!data.enabled || !data.spawnPos.equals((Object)ConfigData.SpawnPos.SKY) || !data.weather.isCurrent(level) || !data.precipitation.contains(precipitation) || !(data.density > random.method_43057()) || !data.biomeList.contains(biome) || !data.blockList.contains(level.method_8320((class_2338)heightmapPos).method_41520())) continue;
                if (data.usePresetParticle) {
                    level.method_8406(data.presetParticle, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                } else {
                    class_310.method_1551().field_1713.method_3058((class_703)new CustomParticle(level, (double)x, (double)y, (double)z, data));
                }
                ticksUntilSkyFXIdle = 100;
            }
        }
    }

    public static void tickSurfaceFX(class_638 level, class_243 cameraPos) {
        int density;
        if (ticksUntilSurfaceFXIdle <= 0) {
            density = 1;
        } else {
            density = ConfigManager.config.perf.particleDensity;
            --ticksUntilSurfaceFXIdle;
        }
        for (int i = 0; i < density; ++i) {
            double x = random.method_43385(cameraPos.field_1352, (double)ConfigManager.config.perf.surfaceRange);
            double z = random.method_43385(cameraPos.field_1350, (double)ConfigManager.config.perf.surfaceRange);
            int y = level.method_8624(class_2902.class_2903.field_13197, (int)x, (int)z);
            pos.method_10102(x, (double)(y - 1), z);
            class_2680 blockState = level.method_8320((class_2338)pos);
            class_6880 biome = level.method_23753((class_2338)pos);
            class_1959.class_1963 precipitation = VersionUtil.getPrecipitationAt((class_1937)level, (class_6880<class_1959>)biome, (class_2338)pos);
            for (ConfigData.ParticleData data : ConfigManager.config.particles) {
                if (!data.enabled || !data.spawnPos.equals((Object)ConfigData.SpawnPos.WORLD_SURFACE) || !data.weather.isCurrent(level) || !data.precipitation.contains(precipitation) || !(data.density > random.method_43057()) || !data.biomeList.contains(biome) || !data.blockList.contains(blockState.method_41520())) continue;
                if (data.usePresetParticle) {
                    level.method_8406(data.presetParticle, x, (double)y, z, 0.0, 0.0, 0.0);
                } else {
                    class_310.method_1551().field_1713.method_3058((class_703)new CustomParticle(level, x, (double)y, z, data));
                }
                ticksUntilSurfaceFXIdle = 100;
            }
        }
    }
}

