/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config.gui;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.gui.AbstractWidgetAccess;
import pigcart.particlerain.config.gui.Annotations;
import pigcart.particlerain.config.gui.ConfigScreen;
import pigcart.particlerain.config.gui.InputWidget;
import pigcart.particlerain.config.gui.LabelWidget;

public class Widgets {
    public static final int BUTTON_WIDTH = 150;
    public static final int BIG_BUTTON_WIDTH = 310;
    public static final int BUTTON_HEIGHT = 20;

    public static LabelWidget getLabel(class_2561 message) {
        return new LabelWidget(310, 20, message);
    }

    public static LabelWidget getOptionLabel(class_2561 message) {
        return new LabelWidget(150, 20, message).alignRight();
    }

    public static class_339 getBool(String name, boolean initialValue, Consumer<Boolean> onValueChange, Function<Object, class_2561> valueFormatter) {
        return new class_5676.class_5677(valueFormatter).method_32619((Object)initialValue).method_32624(new Object[]{initialValue, !initialValue}).method_32617(0, 0, 310, 20, (class_2561)class_2561.method_43471((String)name), (widget, value) -> onValueChange.accept((Boolean)value));
    }

    public static class_339 getBool(String name, boolean initialValue, Consumer<Boolean> onValueChange) {
        return Widgets.getBool(name, initialValue, onValueChange, value -> (Boolean)value != false ? class_5244.field_24332.method_27661().method_27692(class_124.field_1060) : class_5244.field_24333.method_27661().method_27692(class_124.field_1061));
    }

    public static class_339 getEnum(String name, boolean displayOnlyValue, Object initialValue, Consumer<Object> onValueChange) {
        Object[] values = initialValue.getClass().getEnumConstants();
        if (values == null) {
            values = initialValue.getClass().getEnclosingClass().getEnumConstants();
        }
        class_5676.class_5677 builder = new class_5676.class_5677(value -> {
            String className = value.getClass().getSimpleName();
            if (className.isEmpty()) {
                className = value.getClass().getEnclosingClass().getSimpleName();
            }
            return class_2561.method_43471((String)("particlerain." + className + "." + String.valueOf(value)));
        }).method_32619(initialValue).method_32624(values);
        if (displayOnlyValue) {
            builder.method_71805(true);
        }
        return builder.method_32617(0, 0, 310, 20, (class_2561)class_2561.method_43471((String)name), (widget, value) -> onValueChange.accept(value));
    }

    public static class_339 getFloat(int width, int x, String name, float initialValue, Consumer<Float> onValueChange, Function<Object, class_2561> valueFormatter) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(6);
        InputWidget inputWidget = new InputWidget(width, x, df.format(initialValue), string -> onValueChange.accept(Float.valueOf(string)), valueFormatter);
        inputWidget.setFilter(InputWidget.NON_FLOAT);
        inputWidget.method_25355((class_2561)class_2561.method_43471((String)name));
        return inputWidget;
    }

    public static class_339 getInt(int width, int x, String name, int initialValue, Consumer<Integer> onValueChange, Function<Object, class_2561> valueFormatter) {
        InputWidget inputWidget = new InputWidget(width, x, String.valueOf(initialValue), string -> onValueChange.accept(Integer.valueOf(string)), valueFormatter);
        inputWidget.setFilter(InputWidget.NON_INTEGER);
        inputWidget.method_25355((class_2561)class_2561.method_43471((String)name));
        return inputWidget;
    }

    public static class_339 getString(int width, int x, String name, String initialValue, Consumer<String> onValueChange, Function<Object, class_2561> valueFormatter) {
        InputWidget inputWidget = new InputWidget(width, x, String.valueOf(initialValue), onValueChange, valueFormatter);
        inputWidget.setFilter(InputWidget.NON_PATH);
        inputWidget.method_25355((class_2561)class_2561.method_43471((String)name));
        return inputWidget;
    }

    public static class_339 getButton(class_2561 name, class_4185.class_4241 onPress) {
        return class_4185.method_46430((class_2561)name, (class_4185.class_4241)onPress).method_46434(0, 0, 310, 20).method_46431();
    }

    public static class_339 getSlider(final String name, float initialValue, final Consumer<Float> onValueChange, final float min, final float max, final float step, final Function<Object, class_2561> valueFormatter) {
        return new class_357(0, 0, 310, 20, (class_2561)class_2561.method_43471((String)name).method_27693(": ").method_10852(valueFormatter.apply(Float.valueOf(initialValue))), class_3532.method_16439((float)initialValue, (float)min, (float)max)){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43471((String)name).method_27693(": ").method_10852((class_2561)valueFormatter.apply(this.field_22753)));
            }

            protected void method_25344() {
                onValueChange.accept(Float.valueOf((float)Math.round(class_3532.method_16436((double)this.field_22753, (double)min, (double)max) / (double)step) * step));
            }
        };
    }

    public static class_339[] getHexColor(int width, int x, String name, Object initialValue, Consumer<Object> onValueChange, Function<Object, class_2561> valueFormatter) {
        String value = ConfigManager.ColorTypeAdapter.getString((Color)initialValue);
        Consumer<String> onChange = string -> {
            Color color = ConfigManager.ColorTypeAdapter.getColor(string);
            onValueChange.accept(color);
        };
        InputWidget input = (InputWidget)Widgets.getString(width, x, name, value, onChange, valueFormatter);
        input.setFilter(InputWidget.NON_HEX);
        return new class_339[]{Widgets.getOptionLabel((class_2561)class_2561.method_43471((String)name).method_27693(":")), input};
    }

    public static void addOptionWidgets(ConfigScreen screen) {
        Field[] fields;
        if (screen.config instanceof List) {
            Widgets.addListOptions(screen, (List)screen.config, (List)screen.configDefault, screen.configGenericType);
            return;
        }
        for (Field field : fields = screen.config.getClass().getFields()) {
            Object defaultValue;
            Object currentValue;
            if (field.isAnnotationPresent(Annotations.NoGUI.class)) continue;
            if (field.isAnnotationPresent(Annotations.OnlyVisibleIf.class)) {
                Annotations.OnlyVisibleIf annotation = field.getAnnotation(Annotations.OnlyVisibleIf.class);
                try {
                    Function function = (Function)annotation.value().getConstructors()[0].newInstance(new Object[0]);
                    boolean optionIsVisible = (Boolean)function.apply(screen.config);
                    if (!optionIsVisible) {
                        continue;
                    }
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (field.isAnnotationPresent(Annotations.Label.class)) {
                class_339[] widgets = new class_339[]{Widgets.getLabel((class_2561)class_2561.method_43471((String)field.getAnnotation(Annotations.Label.class).key()))};
                screen.add(widgets);
            }
            String name = "particlerain." + field.getName();
            field.setAccessible(true);
            Class<?> type = field.getType();
            try {
                currentValue = field.get(screen.config);
                defaultValue = field.get(screen.configDefault);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            Consumer<Object> onValueChange = value -> {
                try {
                    field.set(screen.config, value);
                    if (field.isAnnotationPresent(Annotations.OnChange.class)) {
                        Annotations.OnChange onChange = field.getAnnotation(Annotations.OnChange.class);
                        ((Runnable)onChange.value().getConstructors()[0].newInstance(new Object[0])).run();
                    }
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            Function valueFormatter = value -> class_2561.method_43470((String)value.toString());
            if (field.isAnnotationPresent(Annotations.Format.class)) {
                Annotations.Format format = field.getAnnotation(Annotations.Format.class);
                try {
                    valueFormatter = (Function)format.value().getConstructors()[0].newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (type.equals(ArrayList.class)) {
                Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                if (field.getName().equals("particles")) {
                    List particles = (List)currentValue;
                    for (int i = 0; i < particles.size(); i += 2) {
                        ConfigData.ParticleData leftParticle = (ConfigData.ParticleData)particles.get(i);
                        class_339 left = Widgets.getBool("particlerain." + leftParticle.id, leftParticle.enabled, value -> {
                            leftParticle.enabled = value;
                        });
                        left.method_25358(150);
                        if (i < particles.size() - 1) {
                            ConfigData.ParticleData rightParticle = (ConfigData.ParticleData)particles.get(i + 1);
                            class_339 right = Widgets.getBool("particlerain." + rightParticle.id, rightParticle.enabled, value -> {
                                rightParticle.enabled = value;
                            });
                            ((AbstractWidgetAccess)right).particle_rain$setOffset(left.method_25368() + 8);
                            right.method_25358(150);
                            screen.add(left, right);
                            continue;
                        }
                        screen.add(left);
                    }
                } else if (field.isAnnotationPresent(Annotations.NoSubMenu.class)) {
                    Widgets.addListOptions(screen, (List)currentValue, (List)defaultValue, listType);
                    continue;
                }
                class_339[] widgets = new class_339[]{Widgets.getButton((class_2561)class_2561.method_43471((String)name).method_27693("..."), bttn -> class_310.method_1551().method_1507((class_437)new ConfigScreen(screen.getFreshScreen(), currentValue, defaultValue, listType, (class_2561)class_2561.method_43471((String)name))))};
                screen.add(widgets);
                continue;
            }
            class_339[] widgets = Widgets.getOptionWidget(screen, field, name, currentValue, defaultValue, onValueChange, valueFormatter, type);
            screen.add(widgets);
        }
        Widgets.appendBespokeParticleOptions(screen);
    }

    private static class_339[] getOptionWidget(ConfigScreen screen, Field field, String name, Object currentValue, Object defaultValue, Consumer onValueChange, Function<Object, class_2561> valueFormatter, Class<?> type) {
        if (field.isAnnotationPresent(Annotations.Slider.class)) {
            Annotations.Slider slider = field.getAnnotation(Annotations.Slider.class);
            return new class_339[]{Widgets.getSlider(name, ((Float)currentValue).floatValue(), onValueChange, slider.min(), slider.max(), slider.step(), valueFormatter)};
        }
        if (type.equals(Boolean.TYPE)) {
            if (field.isAnnotationPresent(Annotations.BooleanFormat.class)) {
                Annotations.BooleanFormat format = field.getAnnotation(Annotations.BooleanFormat.class);
                class_5250 t = class_2561.method_43471((String)("particlerain." + format.t()));
                class_5250 f = class_2561.method_43471((String)("particlerain." + format.f()));
                valueFormatter = arg_0 -> Widgets.lambda$getOptionWidget$0((class_2561)t, (class_2561)f, arg_0);
                return new class_339[]{Widgets.getBool(name, (Boolean)currentValue, onValueChange, valueFormatter)};
            }
            return new class_339[]{Widgets.getBool(name, (Boolean)currentValue, onValueChange)};
        }
        if (type.equals(Float.TYPE)) {
            return new class_339[]{Widgets.getOptionLabel((class_2561)class_2561.method_43471((String)name).method_27693(":")), Widgets.getFloat(150, 158, "", ((Float)currentValue).floatValue(), onValueChange, valueFormatter)};
        }
        if (type.equals(Integer.TYPE)) {
            return new class_339[]{Widgets.getOptionLabel((class_2561)class_2561.method_43471((String)name).method_27693(":")), Widgets.getInt(150, 158, name, (Integer)currentValue, onValueChange, valueFormatter)};
        }
        if (type.equals(String.class)) {
            return new class_339[]{Widgets.getOptionLabel((class_2561)class_2561.method_43471((String)name).method_27693(":")), Widgets.getString(150, 158, name, (String)currentValue, onValueChange, valueFormatter)};
        }
        if (type.isEnum()) {
            return new class_339[]{Widgets.getEnum(name, false, currentValue, onValueChange)};
        }
        if (type.equals(URI.class)) {
            return new class_339[]{Widgets.getButton((class_2561)class_2561.method_43471((String)name), bttn -> class_310.method_1551().method_1507((class_437)new class_407(result -> {
                if (result) {
                    VersionUtil.openUri((URI)currentValue);
                }
                class_310.method_1551().method_1507((class_437)screen);
            }, currentValue.toString(), true)))};
        }
        if (type.equals(Color.class)) {
            return Widgets.getHexColor(310, 0, name, currentValue, onValueChange, valueFormatter);
        }
        if (type.getFields().length > 0) {
            return new class_339[]{Widgets.getButton((class_2561)class_2561.method_43471((String)name).method_27693("..."), bttn -> class_310.method_1551().method_1507((class_437)new ConfigScreen(screen, currentValue, defaultValue, (class_2561)class_2561.method_43471((String)name))))};
        }
        ParticleRain.LOGGER.error("Unable to create option for field {}", (Object)field.getName());
        return new class_339[]{Widgets.getLabel((class_2561)class_2561.method_43470((String)("Unable to create option for field " + field.getName())))};
    }

    private static <E> void addListOptions(ConfigScreen screen, List<E> list, List<?> defaultList, Class<?> listEntryType) {
        if (list.isEmpty()) {
            screen.add(new class_339[]{Widgets.getLabel((class_2561)class_2561.method_43471((String)"mco.configure.world.slot.empty"))});
        }
        int i = 0;
        while (i < list.size()) {
            E entry = list.get(i);
            Object defaultEntry = i < defaultList.size() ? defaultList.get(i) : Widgets.getNewValue(listEntryType);
            int index = i++;
            Consumer<Object> onValueChange = value -> list.set(index, value);
            class_339 listEntryWidget = Widgets.getListEntryWidget(screen, listEntryType, String.valueOf(index + 1), entry, defaultEntry, onValueChange);
            class_339 removeButton = Widgets.getButton((class_2561)class_2561.method_43470((String)"\u274c").method_27692(class_124.field_1061), bttn -> {
                list.remove(index);
                screen.refresh();
            });
            listEntryWidget.method_25358(288);
            removeButton.method_25358(20);
            ((AbstractWidgetAccess)removeButton).particle_rain$setOffset(290);
            screen.add(listEntryWidget, removeButton);
        }
        class_5250 addButtonText = class_2561.method_43471((String)"particlerain.addNew");
        class_339 addButton = Widgets.getButton((class_2561)addButtonText, bttn -> {
            Object newListEntry = Widgets.getNewValue(listEntryType);
            Object defaultEntry = Widgets.getNewValue(listEntryType);
            list.add(newListEntry);
            if (listEntryType.equals(ConfigData.ParticleData.class)) {
                class_310.method_1551().method_1507((class_437)new ConfigScreen(screen.getFreshScreen(), newListEntry, defaultEntry, (class_2561)addButtonText));
            } else {
                screen.refresh();
            }
        });
        if (!(list instanceof ArrayList)) {
            addButton.field_22763 = false;
        }
        screen.add(addButton);
    }

    private static class_339 getListEntryWidget(ConfigScreen screen, Class<?> type, String name, Object entry, Object defaultEntry, Consumer onValueChange) {
        if (type.equals(String.class)) {
            return Widgets.getString(310, 0, name, (String)entry, onValueChange, value -> class_2561.method_43470((String)value.toString()));
        }
        if (type.equals(ConfigData.ParticleData.class)) {
            String particleKey = "particlerain." + ((ConfigData.ParticleData)entry).id;
            return Widgets.getButton((class_2561)class_2561.method_43471((String)particleKey), bttn -> class_310.method_1551().method_1507((class_437)new ConfigScreen(screen.getFreshScreen(), entry, defaultEntry, (class_2561)class_2561.method_43471((String)particleKey))));
        }
        if (type.isEnum()) {
            return Widgets.getEnum(name, true, entry, onValueChange);
        }
        return Widgets.getLabel((class_2561)class_2561.method_43470((String)(type.getSimpleName() + " unimplemented")));
    }

    private static Object getNewValue(Class<?> type) {
        if (type.isEnum()) {
            return type.getEnumConstants()[0];
        }
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ParticleRain.LOGGER.error("Couldn't get new value for: {}", (Object)type.getSimpleName());
            throw new RuntimeException(e);
        }
    }

    private static void appendBespokeParticleOptions(ConfigScreen screen) {
        try {
            Object object = screen.config;
            if (object instanceof ConfigData.ParticleData) {
                String configId;
                ConfigData.ParticleData particleData = (ConfigData.ParticleData)object;
                if (particleData.usePresetParticle && ParticleRain.particleConfigIds.contains(configId = VersionUtil.parseId(particleData.presetParticleId).method_12832())) {
                    Field f = ConfigData.class.getField(configId);
                    f.setAccessible(true);
                    Object bespokeParticleConfig = f.get(ConfigManager.config);
                    Object defaultConfig = f.get(ConfigManager.getDefaultConfig());
                    class_339 button = Widgets.getButton((class_2561)class_2561.method_43471((String)"particlerain.appearance"), bttn -> class_310.method_1551().method_1507((class_437)new ConfigScreen(screen, bespokeParticleConfig, defaultConfig, (class_2561)class_2561.method_43471((String)"particlerain.appearance"))));
                    screen.list.add(button);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ class_2561 lambda$getOptionWidget$0(class_2561 t, class_2561 f, Object value) {
        return (Boolean)value != false ? t : f;
    }
}

