/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.config;

import net.minecraft.class_2960;
import randommcsomethin.fallingleaves.config.ConfigDefaults;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.particle.ParticleImplementation;

public class LeafSettingsEntry {
    public ParticleImplementation particleImplementation;
    public float spawnRateFactor;
    public boolean isConiferBlock;
    public boolean spawnBreakingLeaves;

    public LeafSettingsEntry(class_2960 identifier) {
        this.particleImplementation = ConfigDefaults.getImplementation(identifier);
        this.spawnRateFactor = ConfigDefaults.spawnRateFactor(identifier);
        this.isConiferBlock = ConfigDefaults.isConifer(identifier);
        this.spawnBreakingLeaves = ConfigDefaults.spawnBreakingLeaves(identifier);
    }

    public ParticleImplementation getImplementation() {
        if (Config.CONFIG.alwaysUseVanillaParticles) {
            return ParticleImplementation.VANILLA;
        }
        return this.particleImplementation;
    }

    public float getSpawnChance() {
        float spawnChance = this.isConiferBlock ? Config.CONFIG.getBaseConiferLeafSpawnChance() : Config.CONFIG.getBaseLeafSpawnChance();
        return this.spawnRateFactor * spawnChance;
    }

    public boolean isDefault(class_2960 identifier) {
        return this.particleImplementation == ConfigDefaults.getImplementation(identifier) && this.spawnRateFactor == ConfigDefaults.spawnRateFactor(identifier) && this.isConiferBlock == ConfigDefaults.isConifer(identifier) && this.spawnBreakingLeaves == ConfigDefaults.spawnBreakingLeaves(identifier);
    }

    public String toString() {
        return String.format("LeafSettingsEntry{particleImplementation=%s, spawnRateFactor=%s, isConiferBlock=%s, spawnBreakingLeaves=%s}", new Object[]{this.particleImplementation, Float.valueOf(this.spawnRateFactor), this.isConiferBlock, this.spawnBreakingLeaves});
    }
}

