/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.config.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class GsonConfigHelper {
    private final Path configPath;
    private final Gson gson;

    public GsonConfigHelper(String configName) {
        this(configName, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create());
    }

    public GsonConfigHelper(String configName, Gson gson) {
        this.configPath = FabricLoader.getInstance().getConfigDir().resolve(configName + ".json");
        this.gson = gson;
    }

    public boolean exists() {
        return Files.exists(this.configPath, new LinkOption[0]);
    }

    public <T> T load(Class<T> configType) throws IOException, JsonParseException {
        try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
            Object config = this.gson.fromJson((Reader)reader, configType);
            if (config == null) {
                throw new JsonParseException("config file is empty");
            }
            Object object = config;
            return (T)object;
        }
    }

    public void save(Object config) throws IOException, JsonIOException {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
            this.gson.toJson(config, (Appendable)writer);
        }
    }
}

