/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.util.UndashedUuid;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import net.lopymine.mtd.api.Response;
import net.lopymine.mtd.cache.KnownPlayerUUIDsConfigManager;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.config.cache.KnownPlayerUUIDsConfig;
import net.lopymine.mtd.exception.HttpResponseException;
import net.lopymine.mtd.skin.data.ParsedSkinData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MojangAPI {
    private static final Gson GSON = new GsonBuilder().setLenient().disableHtmlEscaping().create();
    public static boolean useFallbackAPI = false;

    private static String getUUIDEndpoint(String nickname) {
        if (useFallbackAPI) {
            return "https://api.mojang.com/users/profiles/minecraft/" + nickname;
        }
        return "https://api.minecraftservices.com/minecraft/profile/lookup/name/" + nickname;
    }

    public static Response<UUID> getUUID(String nickname, boolean canRetry) {
        boolean debugLogEnabled = MyTotemDollConfig.getInstance().isDebugLogEnabled();
        int statusCode = -1;
        String responseBody = "Not reached";
        try {
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(MojangAPI.getUUIDEndpoint(nickname))).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            statusCode = response.statusCode();
            responseBody = response.body();
            if (statusCode == 429) {
                if (debugLogEnabled) {
                    MyTotemDollClient.LOGGER.warn("Received Too Many Requests on {}", (Object)nickname);
                }
                return Response.empty(statusCode);
            }
            if (statusCode == 404) {
                if (debugLogEnabled) {
                    MyTotemDollClient.LOGGER.warn("Failed to find player profile with nickname {}", (Object)nickname);
                }
                return Response.empty(statusCode);
            }
            JsonObject jsonObject = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
            if (statusCode != 200) {
                if (jsonObject.has("errorMessage")) {
                    throw new HttpResponseException(statusCode, jsonObject.get("errorMessage").getAsString());
                }
                if (jsonObject.has("error")) {
                    throw new HttpResponseException(statusCode, jsonObject.get("error").getAsString());
                }
                throw new HttpResponseException(statusCode, "Unknown error, check status code.");
            }
            if (!jsonObject.has("id")) {
                throw new HttpResponseException(statusCode, "Response doesn't contains 'id'");
            }
            String uuidAsString = jsonObject.get("id").getAsString();
            UUID uuid = UndashedUuid.fromStringLenient((String)uuidAsString);
            return new Response<UUID>(statusCode, uuid);
        }
        catch (InterruptedException httpClient) {
        }
        catch (Exception e) {
            MyTotemDollClient.LOGGER.error("Failed to get UUID: ", (Throwable)e);
            MyTotemDollClient.LOGGER.error("Response Body: ");
            MyTotemDollClient.LOGGER.error(responseBody);
        }
        if (statusCode == 403) {
            MyTotemDollClient.LOGGER.error("Received 403 status code, using fallback API for UUIDs!");
            useFallbackAPI = true;
            if (canRetry) {
                return MojangAPI.getUUID(nickname, false);
            }
        }
        return Response.empty(statusCode);
    }

    public static Response<ParsedSkinData> getSkinData(String nickname) {
        KnownPlayerUUIDsConfig config = KnownPlayerUUIDsConfig.getInstance();
        Map<String, UUID> cache = config.getCache();
        UUID uuid = cache.get(nickname);
        if (uuid != null) {
            return MojangAPI.getSkinData(uuid, nickname);
        }
        Response<UUID> response = MojangAPI.getUUID(nickname, true);
        if (response.statusCode() == -1 && response.isEmpty()) {
            return Response.empty(response.statusCode());
        }
        if (response.statusCode() == 404 && response.isEmpty()) {
            return Response.empty(response.statusCode());
        }
        if (response.statusCode() == 429 && response.isEmpty()) {
            return Response.empty(response.statusCode());
        }
        if (response.isEmpty()) {
            return Response.empty(response.statusCode());
        }
        UUID value = response.value();
        cache.put(nickname, value);
        config.setDirty(true);
        KnownPlayerUUIDsConfigManager.save();
        return MojangAPI.getSkinData(value, nickname);
    }

    @Nullable
    public static Response<ParsedSkinData> getSkinData(UUID uuid, String nickname) {
        try {
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(String.format("https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false", uuid.toString()))).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject jsonObject = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
            if (jsonObject == null) {
                return Response.empty(response.statusCode());
            }
            if (response.statusCode() == 429) {
                return Response.empty(response.statusCode());
            }
            ParsedSkinData parsedSkinData = MojangAPI.parseSkinData(jsonObject);
            if (parsedSkinData.getSkinUrl() == null) {
                return Response.empty(response.statusCode());
            }
            return new Response<ParsedSkinData>(response.statusCode(), parsedSkinData);
        }
        catch (Exception e) {
            MyTotemDollClient.LOGGER.error("Failed to load skin textures for {}: ", (Object)nickname, (Object)e);
            return null;
        }
    }

    @NotNull
    private static ParsedSkinData parseSkinData(@NotNull JsonObject jsonObject) {
        String skinUrl = null;
        String capeUrl = null;
        String skinModel = "default";
        for (JsonElement jsonElement : jsonObject.get("properties").getAsJsonArray()) {
            JsonObject propertiesObject = jsonElement.getAsJsonObject();
            if (!propertiesObject.get("name").getAsString().equals("textures")) continue;
            JsonElement valueElement = propertiesObject.get("value");
            String jsonSkinData = new String(Base64.getDecoder().decode(valueElement.getAsString()), StandardCharsets.UTF_8);
            JsonObject jsonSkinObject = (JsonObject)GSON.fromJson(jsonSkinData, JsonObject.class);
            JsonObject skinTexturesObject = jsonSkinObject.get("textures").getAsJsonObject();
            JsonObject skinObject = skinTexturesObject.get("SKIN").getAsJsonObject();
            skinUrl = skinObject.get("url").getAsString();
            if (skinTexturesObject.has("CAPE")) {
                JsonObject capeObject = skinTexturesObject.get("CAPE").getAsJsonObject();
                capeUrl = capeObject.get("url").getAsString();
            }
            if (!skinObject.has("metadata")) break;
            JsonObject skinMetadataObject = skinObject.get("metadata").getAsJsonObject();
            skinModel = skinMetadataObject.get("model").getAsString();
            break;
        }
        return new ParsedSkinData(skinUrl, capeUrl, null, skinModel.equals("slim"));
    }
}

