/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.atlas.manager;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.atlas.AtlasSprite;
import net.lopymine.mtd.atlas.LockableAtlasTexture;
import net.lopymine.mtd.atlas.stitch.OnAtlasStitched;
import net.lopymine.mtd.atlas.stitch.StitchHooksManager;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.thread.MyTotemDollTaskExecutor;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3302;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyTotemDollAtlasManager {
    private static final StitchHooksManager STITCH_HOOKS_MANAGER = new StitchHooksManager();
    private static final AtomicInteger LATEST_ATLAS_VERSION = new AtomicInteger();
    public static final class_2960 ATLAS_ID = MyTotemDoll.id("main_atlas.png");
    public static final class_1921 ATLAS_RENDER_LAYER = class_1921.method_23580((class_2960)ATLAS_ID);
    @Nullable
    private static LockableAtlasTexture ATLAS_TEXTURE;

    @NotNull
    public static class_1059 createNotRegisteredInstance() {
        return new class_1059(ATLAS_ID);
    }

    public static class_1921 getRenderLayer() {
        return ATLAS_RENDER_LAYER;
    }

    public static LockableAtlasTexture getNullableAtlasTexture() {
        return ATLAS_TEXTURE;
    }

    public static void setAtlas(@NotNull class_1059 texture) {
        if (ATLAS_TEXTURE != null && ATLAS_TEXTURE.isLocked()) {
            LockableAtlasTexture atlasTexture = new LockableAtlasTexture(texture);
            ATLAS_TEXTURE.setUnlockHook(() -> MyTotemDollAtlasManager.set(atlasTexture));
            return;
        }
        MyTotemDollAtlasManager.set(new LockableAtlasTexture(texture));
    }

    @NotNull
    private static LockableAtlasTexture set(@NotNull LockableAtlasTexture texture) {
        class_1059 atlas = texture.getAtlas();
        ATLAS_TEXTURE = texture;
        class_310.method_1551().method_1531().method_4616(atlas.method_24106(), (class_1044)atlas);
        return ATLAS_TEXTURE;
    }

    public static void stitchAndUpdate(Set<AtlasSprite> sprites, @Nullable OnAtlasStitched onAtlasStitched) {
        MyTotemDollAtlasManager.stitchAndUpdate(sprites, MyTotemDollTaskExecutor.MAIN_EXECUTOR, onAtlasStitched);
    }

    public static void stitchAndUpdate(Set<AtlasSprite> sprites, Executor executor, @Nullable OnAtlasStitched onAtlasStitched) {
        MyTotemDollAtlasManager.stitchAndUpdate(sprites, null, executor, (Executor)class_310.method_1551(), onAtlasStitched);
    }

    public static void stitchAndUpdate(Set<AtlasSprite> sprites, @Nullable class_3302.class_4045 synchronizer, Executor prepareExecutor, Executor applyExecutor, @Nullable OnAtlasStitched onAtlasStitched) {
        int currentId = LATEST_ATLAS_VERSION.incrementAndGet();
        STITCH_HOOKS_MANAGER.addHook(onAtlasStitched);
        class_1059 atlasTexture = MyTotemDollAtlasManager.createNotRegisteredInstance();
        List<class_7764> contents = sprites.stream().map(AtlasSprite::getContents).filter(Objects::nonNull).toList();
        CompletionStage<Object> future = CompletableFuture.supplyAsync(() -> class_7766.method_45837((class_1059)atlasTexture).method_47663(contents, 0, prepareExecutor));
        if (synchronizer != null) {
            future = ((CompletableFuture)future).thenCompose(arg_0 -> ((class_3302.class_4045)synchronizer).method_18352(arg_0));
        }
        AtlasStitchingContext stitchingContext = new AtlasStitchingContext(currentId, atlasTexture, sprites);
        ((CompletableFuture)future).thenAcceptAsync(stitchingContext::upload, applyExecutor);
    }

    public static void close() {
        if (ATLAS_TEXTURE == null) {
            return;
        }
        ATLAS_TEXTURE.getAtlas().close();
    }

    private record AtlasStitchingContext(int version, class_1059 atlas, Set<AtlasSprite> atlasSprites) {
        public void upload(class_7766.class_7767 result) {
            int latestAtlasVersion = LATEST_ATLAS_VERSION.get();
            if (this.version != latestAtlasVersion) {
                MyTotemDollClient.LOGGER.warn("Skipped atlas stitching, waiting \"{}\"", (Object)latestAtlasVersion);
                return;
            }
            this.atlas.method_45848(result);
            this.atlasSprites.forEach(AtlasSprite::markUploaded);
            MyTotemDollAtlasManager.setAtlas(this.atlas);
            STITCH_HOOKS_MANAGER.runAllHooks();
        }
    }
}

