/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.client.command.refresh;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.lopymine.mtd.api.MojangAPI;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.client.command.builder.CommandTextBuilder;
import net.lopymine.mtd.doll.manager.TotemDollManager;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class RefreshCommand {
    @Nullable
    private static CompletableFuture<Float> RELOADING_ALL_FUTURE = null;
    private static final Map<String, CompletableFuture<Float>> RELOADING_FUTURES = new ConcurrentHashMap<String, CompletableFuture<Float>>();

    public static LiteralArgumentBuilder<FabricClientCommandSource> getInstance() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"refresh").then(ClientCommandManager.literal((String)"all").executes(RefreshCommand::reloadAll))).then(ClientCommandManager.literal((String)"player").then(ClientCommandManager.argument((String)"nickname", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(TotemDollManager.getAllLoadedKeys(), (SuggestionsBuilder)builder)).executes(RefreshCommand::reloadForPlayer)));
    }

    private static int reloadAll(CommandContext<FabricClientCommandSource> context) {
        if (RELOADING_ALL_FUTURE != null) {
            return 0;
        }
        class_2561 startFeedback = CommandTextBuilder.startBuilder("command.refresh.all.start", new Object[0]).build();
        ((FabricClientCommandSource)context.getSource()).sendFeedback(startFeedback);
        RELOADING_ALL_FUTURE = TotemDollManager.reloadData(seconds -> {
            class_2561 endFeedback = CommandTextBuilder.startBuilder("command.refresh.all.end", seconds).build();
            class_310.method_1551().execute(() -> ((FabricClientCommandSource)context.getSource()).sendFeedback(endFeedback));
        }).whenComplete((r, e) -> {
            RELOADING_ALL_FUTURE = null;
            if (e != null) {
                MyTotemDollClient.LOGGER.error("Failed to refresh all doll data: ", e);
            }
        });
        MojangAPI.useFallbackAPI = false;
        return 1;
    }

    private static int reloadForPlayer(CommandContext<FabricClientCommandSource> context) {
        String nickname = StringArgumentType.getString(context, (String)"nickname");
        CompletableFuture<Float> future = RELOADING_FUTURES.get(nickname);
        if (future != null) {
            return 0;
        }
        class_2561 startFeedback = CommandTextBuilder.startBuilder("command.refresh.player.start", nickname).build();
        ((FabricClientCommandSource)context.getSource()).sendFeedback(startFeedback);
        CompletableFuture<Float> f = TotemDollManager.reloadData(nickname, seconds -> {
            class_2561 endFeedback = CommandTextBuilder.startBuilder("command.refresh.player.end", nickname, seconds).build();
            class_310.method_1551().execute(() -> ((FabricClientCommandSource)context.getSource()).sendFeedback(endFeedback));
        });
        if (f != null) {
            CompletionStage fc = f.whenComplete((r, e) -> {
                RELOADING_FUTURES.remove(nickname);
                if (e != null) {
                    MyTotemDollClient.LOGGER.error("Failed to refresh doll data for \"{}\": ", (Object)nickname, e);
                }
            });
            RELOADING_FUTURES.put(nickname, (CompletableFuture<Float>)fc);
        }
        return 1;
    }
}

