/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.data;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import net.lopymine.mtd.doll.data.TotemDollSprites;
import net.lopymine.mtd.doll.model.TotemDollModel;
import net.lopymine.mtd.doll.renderer.DollRenderContext;
import net.lopymine.mtd.model.base.MModel;
import net.lopymine.mtd.model.base.MModelCollection;
import net.lopymine.mtd.model.bb.manager.BlockBenchModelManager;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotemDollRenderProperties {
    private boolean slim;
    @Nullable
    private String nickname;
    @Nullable
    private DollRenderContext renderContext;
    @NotNull
    private String[] disabledParts = new String[0];
    @NotNull
    private String[] enabledParts = new String[0];
    @Nullable
    private MModel standardMModel;
    @Nullable
    private MModel frameMModel;
    @NotNull
    private TotemDollSprites standardSprites;
    @Nullable
    private TotemDollSprites frameSprites;
    @NotNull
    private final Map<class_2960, MModel> cachedFrameMModels = new HashMap<class_2960, MModel>();
    @NotNull
    private final Int2ObjectMap<TotemDollSprites> cachedFrameTextures = new Int2ObjectArrayMap();

    public boolean equals(Object o) {
        if (!(o instanceof TotemDollRenderProperties)) {
            return false;
        }
        TotemDollRenderProperties that = (TotemDollRenderProperties)o;
        return this.isSlim() == that.isSlim() && this.getRenderContext() == that.getRenderContext() && Objects.equals(this.getNickname(), that.getNickname()) && Objects.deepEquals(this.getDisabledParts(), that.getDisabledParts()) && Objects.deepEquals(this.getEnabledParts(), that.getEnabledParts()) && Objects.equals((Object)this.getFrameMModel(), (Object)that.getFrameMModel()) && Objects.equals((Object)this.getStandardMModel(), (Object)that.getStandardMModel());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isSlim(), this.getRenderContext(), this.getNickname(), Arrays.hashCode(this.getDisabledParts()), Arrays.hashCode(this.getEnabledParts()), this.getFrameMModel(), this.getStandardMModel()});
    }

    public TotemDollModel createStandardModel() {
        return new TotemDollModel(this.standardMModel, this.isSlim());
    }

    public TotemDollModel createFrameModel() {
        return new TotemDollModel(this.frameMModel, this.isSlim());
    }

    public void consumeFrameMModel(@NotNull class_2960 id, Consumer<MModel> set) {
        MModel model = this.cachedFrameMModels.get(id);
        if (model == null) {
            BlockBenchModelManager.getModelAsyncAsResponse(id, response -> {
                if (!response.isEmpty()) {
                    MModel tempMModel = (MModel)((Object)((Object)response.value()));
                    this.cachedFrameMModels.put(id, tempMModel);
                    set.accept(tempMModel);
                }
            });
            return;
        }
        set.accept(model);
    }

    public void setFrameSprites(class_2960 skinTexture, class_2960 capeTexture, class_2960 elytraTexture, boolean slim, boolean remapCape) {
        int hash = Objects.hash(skinTexture, capeTexture, elytraTexture, slim);
        TotemDollSprites cachedSprites = (TotemDollSprites)this.cachedFrameTextures.get(hash);
        if (cachedSprites == null) {
            TotemDollSprites sprites = TotemDollSprites.of(skinTexture, capeTexture, elytraTexture, slim, remapCape);
            this.cachedFrameTextures.put(hash, (Object)sprites);
            this.setFrameSprites(sprites);
        }
        this.setFrameSprites(cachedSprites);
    }

    public void disable(MModelCollection collection) {
        if (!collection.setVisible(false)) {
            return;
        }
        String[] created = Arrays.copyOf(this.disabledParts, this.disabledParts.length + 1);
        created[created.length - 1] = collection.getId();
        this.disabledParts = created;
    }

    public void enable(MModelCollection collection) {
        if (!collection.setVisible(true)) {
            return;
        }
        String[] created = Arrays.copyOf(this.enabledParts, this.enabledParts.length + 1);
        created[created.length - 1] = collection.getId();
        this.enabledParts = created;
    }

    public void refresh() {
        this.refresh(this.standardSprites);
    }

    public void refresh(TotemDollSprites sprites) {
        this.standardSprites = sprites;
        this.enabledParts = new String[0];
        this.disabledParts = new String[0];
        this.slim = sprites.getArmsType().isSlim();
        this.frameMModel = null;
        this.renderContext = null;
    }

    public void clearCachedFrameMModels() {
        this.cachedFrameMModels.clear();
        this.frameMModel = null;
    }

    public void applyToModel(TotemDollModel model) {
        MModelCollection collection;
        for (String part : this.disabledParts) {
            collection = model.getCollectionOfPart(part);
            if (collection == null) continue;
            TotemDollModel.disableIfPresent(collection);
        }
        for (String part : this.enabledParts) {
            collection = model.getCollectionOfPart(part);
            if (collection == null) continue;
            TotemDollModel.enableIfPresent(collection);
        }
        model.setSlim(this.isSlim());
    }

    public TotemDollRenderProperties copyFrom(TotemDollRenderProperties properties) {
        this.setSlim(properties.isSlim());
        this.setRenderContext(properties.getRenderContext());
        this.setNickname(properties.getNickname());
        this.setDisabledParts((String[])properties.getDisabledParts().clone());
        this.setEnabledParts((String[])properties.getEnabledParts().clone());
        this.setStandardMModel(properties.getStandardMModel());
        this.setFrameMModel(properties.getFrameMModel());
        this.setStandardSprites(properties.getStandardSprites());
        this.setFrameSprites(properties.getFrameSprites());
        return this;
    }

    public TotemDollRenderProperties copy() {
        return new TotemDollRenderProperties().copyFrom(this);
    }

    @Generated
    public boolean isSlim() {
        return this.slim;
    }

    @Nullable
    @Generated
    public String getNickname() {
        return this.nickname;
    }

    @Nullable
    @Generated
    public DollRenderContext getRenderContext() {
        return this.renderContext;
    }

    @NotNull
    @Generated
    public String[] getDisabledParts() {
        return this.disabledParts;
    }

    @NotNull
    @Generated
    public String[] getEnabledParts() {
        return this.enabledParts;
    }

    @Nullable
    @Generated
    public MModel getStandardMModel() {
        return this.standardMModel;
    }

    @Nullable
    @Generated
    public MModel getFrameMModel() {
        return this.frameMModel;
    }

    @NotNull
    @Generated
    public TotemDollSprites getStandardSprites() {
        return this.standardSprites;
    }

    @Nullable
    @Generated
    public TotemDollSprites getFrameSprites() {
        return this.frameSprites;
    }

    @NotNull
    @Generated
    public Map<class_2960, MModel> getCachedFrameMModels() {
        return this.cachedFrameMModels;
    }

    @NotNull
    @Generated
    public Int2ObjectMap<TotemDollSprites> getCachedFrameTextures() {
        return this.cachedFrameTextures;
    }

    @Generated
    public void setSlim(boolean slim) {
        this.slim = slim;
    }

    @Generated
    public void setNickname(@Nullable String nickname) {
        this.nickname = nickname;
    }

    @Generated
    public void setRenderContext(@Nullable DollRenderContext renderContext) {
        this.renderContext = renderContext;
    }

    @Generated
    public void setDisabledParts(@NotNull String[] disabledParts) {
        if (disabledParts == null) {
            throw new NullPointerException("disabledParts is marked non-null but is null");
        }
        this.disabledParts = disabledParts;
    }

    @Generated
    public void setEnabledParts(@NotNull String[] enabledParts) {
        if (enabledParts == null) {
            throw new NullPointerException("enabledParts is marked non-null but is null");
        }
        this.enabledParts = enabledParts;
    }

    @Generated
    public void setStandardMModel(@Nullable MModel standardMModel) {
        this.standardMModel = standardMModel;
    }

    @Generated
    public void setFrameMModel(@Nullable MModel frameMModel) {
        this.frameMModel = frameMModel;
    }

    @Generated
    public void setStandardSprites(@NotNull TotemDollSprites standardSprites) {
        if (standardSprites == null) {
            throw new NullPointerException("standardSprites is marked non-null but is null");
        }
        this.standardSprites = standardSprites;
    }

    @Generated
    public void setFrameSprites(@Nullable TotemDollSprites frameSprites) {
        this.frameSprites = frameSprites;
    }
}

