/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.data;

import lombok.Generated;
import net.lopymine.mtd.atlas.AtlasSprite;
import net.lopymine.mtd.atlas.RemappedAtlasSprite;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasManager;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasSpriteManager;
import net.lopymine.mtd.config.totem.TotemDollArmsType;
import net.lopymine.mtd.doll.data.LoadingState;
import net.minecraft.class_12079;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotemDollSprites {
    @NotNull
    private LoadingState state = LoadingState.NOT_DOWNLOADED;
    @Nullable
    private AtlasSprite skinSprite;
    @Nullable
    private AtlasSprite capeSprite;
    @Nullable
    private AtlasSprite elytraSprite;
    private TotemDollArmsType standardArmsType;
    private TotemDollArmsType armsType;

    public TotemDollSprites(@Nullable AtlasSprite skinSprite, @Nullable AtlasSprite capeSprite, @Nullable AtlasSprite elytraSprite, TotemDollArmsType armsType) {
        this.skinSprite = skinSprite;
        this.capeSprite = capeSprite;
        this.elytraSprite = elytraSprite;
        this.armsType = armsType;
    }

    public static TotemDollSprites create() {
        return new TotemDollSprites(null, null, null, TotemDollArmsType.WIDE);
    }

    public static TotemDollSprites of(class_742 player) {
        return TotemDollSprites.of(player.method_52814());
    }

    public static TotemDollSprites of(class_8685 skinTextures) {
        class_12079.class_12081 cape = skinTextures.comp_1627();
        class_12079.class_12081 elytra = skinTextures.comp_1628();
        return TotemDollSprites.of(skinTextures.comp_1626().comp_3627(), cape == null ? null : cape.comp_3627(), elytra == null ? null : elytra.comp_3627(), skinTextures.comp_1629() == class_7920.field_41122, true);
    }

    public static TotemDollSprites of(class_2960 skinTexture, class_2960 capeTexture, class_2960 elytraTexture, boolean slim, boolean remapCape) {
        TotemDollSprites totemDollSprites = new TotemDollSprites(null, null, null, TotemDollArmsType.of(slim));
        if (skinTexture != null) {
            MyTotemDollAtlasSpriteManager.registerSpecialSkinSprite(skinTexture, false, totemDollSprites::setSkinSprite);
        }
        if (capeTexture != null) {
            if (remapCape) {
                RemappedAtlasSprite capeSprite = RemappedAtlasSprite.ofResource(capeTexture);
                MyTotemDollAtlasSpriteManager.registerSpecialRemappedSprite(capeSprite);
                totemDollSprites.setCapeSprite(capeSprite);
            } else {
                MyTotemDollAtlasSpriteManager.registerSpecialSkinSprite(capeTexture, false, totemDollSprites::setCapeSprite);
            }
        }
        if (elytraTexture != null) {
            MyTotemDollAtlasSpriteManager.registerSpecialSkinSprite(elytraTexture, false, totemDollSprites::setElytraSprite);
        }
        MyTotemDollAtlasManager.stitchAndUpdate(MyTotemDollAtlasSpriteManager.getSprites(), () -> totemDollSprites.setState(LoadingState.DOWNLOADED));
        return totemDollSprites;
    }

    public void setStandardArmsType(TotemDollArmsType standardArmsType) {
        this.armsType = standardArmsType;
        this.standardArmsType = standardArmsType;
    }

    public TotemDollArmsType getArmsType() {
        return this.armsType == null ? (this.standardArmsType == null ? TotemDollArmsType.WIDE : this.standardArmsType) : this.armsType;
    }

    public AtlasSprite getSkinSprite() {
        return this.skinSprite == null || !this.skinSprite.isUploaded() || this.state != LoadingState.DOWNLOADED ? MyTotemDollAtlasSpriteManager.STEVE_SKIN_SPRITE : this.skinSprite;
    }

    public AtlasSprite getElytraSprite() {
        AtlasSprite capeSprite = this.getCapeSprite();
        if (capeSprite != null && capeSprite.isUploaded()) {
            return capeSprite;
        }
        AtlasSprite elytraSprite = this.elytraSprite;
        if (elytraSprite != null && elytraSprite.isUploaded()) {
            return elytraSprite;
        }
        return MyTotemDollAtlasSpriteManager.ELYTRA_SPRITE;
    }

    public void destroy() {
        this.setState(LoadingState.DESTROYED);
        AtlasSprite skinSprite = this.skinSprite;
        AtlasSprite capeSprite = this.capeSprite;
        AtlasSprite elytraSprite = this.elytraSprite;
        this.skinSprite = null;
        this.capeSprite = null;
        this.elytraSprite = null;
        if (skinSprite != null) {
            skinSprite.closeAndUnregisterAnyway();
        }
        if (capeSprite != null) {
            capeSprite.close();
        }
        if (elytraSprite != null) {
            elytraSprite.close();
        }
    }

    public boolean canStartDownloading() {
        return this.state == LoadingState.ERROR || this.state == LoadingState.NOT_DOWNLOADED;
    }

    public TotemDollSprites copy() {
        TotemDollSprites totemDollSprites = new TotemDollSprites(this.skinSprite, this.capeSprite, this.elytraSprite, this.armsType);
        totemDollSprites.setState(this.state);
        return totemDollSprites;
    }

    @NotNull
    @Generated
    public LoadingState getState() {
        return this.state;
    }

    @Nullable
    @Generated
    public AtlasSprite getCapeSprite() {
        return this.capeSprite;
    }

    @Generated
    public TotemDollArmsType getStandardArmsType() {
        return this.standardArmsType;
    }

    @Generated
    public void setState(@NotNull LoadingState state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.state = state;
    }

    @Generated
    public void setSkinSprite(@Nullable AtlasSprite skinSprite) {
        this.skinSprite = skinSprite;
    }

    @Generated
    public void setCapeSprite(@Nullable AtlasSprite capeSprite) {
        this.capeSprite = capeSprite;
    }

    @Generated
    public void setElytraSprite(@Nullable AtlasSprite elytraSprite) {
        this.elytraSprite = elytraSprite;
    }

    @Generated
    public void setArmsType(TotemDollArmsType armsType) {
        this.armsType = armsType;
    }

    @Generated
    public TotemDollSprites(@NotNull LoadingState state, @Nullable AtlasSprite skinSprite, @Nullable AtlasSprite capeSprite, @Nullable AtlasSprite elytraSprite, TotemDollArmsType standardArmsType, TotemDollArmsType armsType) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        this.state = state;
        this.skinSprite = skinSprite;
        this.capeSprite = capeSprite;
        this.elytraSprite = elytraSprite;
        this.standardArmsType = standardArmsType;
        this.armsType = armsType;
    }
}

