/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.model;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.atlas.AtlasSprite;
import net.lopymine.mtd.atlas.LockableAtlasTexture;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasManager;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.doll.data.TotemDollSprites;
import net.lopymine.mtd.model.base.MModel;
import net.lopymine.mtd.model.base.MModelCollection;
import net.lopymine.mtd.model.bb.manager.BlockBenchModelManager;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public class TotemDollModel
extends class_3879<Object> {
    public static final class_2960 TWO_D_MODEL_ID = MyTotemDoll.id("dolls/2d_doll.bbmodel");
    public static final class_2960 THREE_D_MODEL_id = MyTotemDoll.id("dolls/3d_doll.bbmodel");
    private final MModel main;
    private final MModelCollection head;
    private final MModelCollection body;
    private final MModelCollection leftArmSlim;
    private final MModelCollection rightArmSlim;
    private final MModelCollection leftArmWide;
    private final MModelCollection rightArmWide;
    private final MModelCollection leftLeg;
    private final MModelCollection rightLeg;
    private final MModelCollection cape;
    private final MModelCollection elytra;
    private final MModelCollection ears;
    private final Map<String, MModelCollection> collections = new HashMap<String, MModelCollection>();
    private boolean slim;
    private Drawer drawer;

    public TotemDollModel(MModel root, boolean slim) {
        super((class_630)root, class_1921::method_23580);
        this.head = root.findModels("head");
        this.body = root.findModels("body");
        this.leftArmSlim = root.findModels("left_arm_slim");
        this.rightArmSlim = root.findModels("right_arm_slim");
        this.leftArmWide = root.findModels("left_arm_wide");
        this.rightArmWide = root.findModels("right_arm_wide");
        this.leftLeg = root.findModels("left_leg");
        this.rightLeg = root.findModels("right_leg");
        this.cape = root.findModels("cape");
        this.elytra = root.findModels("elytra");
        this.ears = root.findModels("ears");
        this.initCollectionsMap();
        this.main = root;
        this.slim = slim;
        TotemDollModel.disableIfPresent(this.leftArmSlim);
        TotemDollModel.disableIfPresent(this.rightArmSlim);
        TotemDollModel.disableIfPresent(this.leftArmWide);
        TotemDollModel.disableIfPresent(this.rightArmWide);
        this.resetPartsVisibility();
    }

    private void initCollectionsMap() {
        this.addCollectionToCollectionsMap(this.head);
        this.addCollectionToCollectionsMap(this.body);
        this.addCollectionToCollectionsMap(this.leftArmSlim);
        this.addCollectionToCollectionsMap(this.rightArmSlim);
        this.addCollectionToCollectionsMap(this.leftArmWide);
        this.addCollectionToCollectionsMap(this.rightArmWide);
        this.addCollectionToCollectionsMap(this.leftLeg);
        this.addCollectionToCollectionsMap(this.rightLeg);
        this.addCollectionToCollectionsMap(this.cape);
        this.addCollectionToCollectionsMap(this.elytra);
        this.addCollectionToCollectionsMap(this.ears);
    }

    private void addCollectionToCollectionsMap(MModelCollection collection) {
        if (collection.isEmpty()) {
            return;
        }
        this.collections.put(collection.getId(), collection);
    }

    public static MModel createDollModel() {
        MModel mmodel;
        MModel model = BlockBenchModelManager.getModel(MyTotemDollConfig.getInstance().getStandardTotemDollModelValue());
        MModel mModel = mmodel = model == null ? BlockBenchModelManager.getModel(THREE_D_MODEL_id) : model;
        if (mmodel == null) {
            throw new IllegalArgumentException("Failed to find standard doll model! [TotemDollModel.class]");
        }
        return mmodel;
    }

    public static void enableIfPresent(MModelCollection collection) {
        collection.setVisible(true);
    }

    public static void disableIfPresent(MModelCollection collection) {
        collection.setVisible(false);
    }

    public static void enableSkipRenderingIfPresent(MModelCollection collection) {
        collection.setSkipRendering(true);
    }

    public static void disableSkipRenderingIfPresent(MModelCollection collection) {
        collection.setSkipRendering(false);
    }

    public void resetPartsVisibility() {
        TotemDollModel.enableSkipRenderingIfPresent(this.cape);
        TotemDollModel.enableIfPresent(this.cape);
        TotemDollModel.enableSkipRenderingIfPresent(this.ears);
        TotemDollModel.enableIfPresent(this.ears);
        TotemDollModel.enableSkipRenderingIfPresent(this.elytra);
        TotemDollModel.disableIfPresent(this.elytra);
    }

    public void apply(TotemDollSprites textures) {
        this.slim = textures.getArmsType().isSlim();
        this.resetPartsVisibility();
    }

    public MModelCollection getLeftArm() {
        return this.slim ? this.leftArmSlim : this.leftArmWide;
    }

    public MModelCollection getRightArm() {
        return this.slim ? this.rightArmSlim : this.rightArmWide;
    }

    public Drawer getDrawer() {
        if (this.drawer == null) {
            this.drawer = new Drawer(this);
        }
        this.drawer.prepareForRender();
        return this.drawer;
    }

    @Nullable
    public MModelCollection getCollectionOfPart(String part) {
        return this.collections.get(part);
    }

    @Generated
    public MModel getMain() {
        return this.main;
    }

    @Generated
    public MModelCollection getHead() {
        return this.head;
    }

    @Generated
    public MModelCollection getBody() {
        return this.body;
    }

    @Generated
    public MModelCollection getLeftArmSlim() {
        return this.leftArmSlim;
    }

    @Generated
    public MModelCollection getRightArmSlim() {
        return this.rightArmSlim;
    }

    @Generated
    public MModelCollection getLeftArmWide() {
        return this.leftArmWide;
    }

    @Generated
    public MModelCollection getRightArmWide() {
        return this.rightArmWide;
    }

    @Generated
    public MModelCollection getLeftLeg() {
        return this.leftLeg;
    }

    @Generated
    public MModelCollection getRightLeg() {
        return this.rightLeg;
    }

    @Generated
    public MModelCollection getCape() {
        return this.cape;
    }

    @Generated
    public MModelCollection getElytra() {
        return this.elytra;
    }

    @Generated
    public MModelCollection getEars() {
        return this.ears;
    }

    @Generated
    public Map<String, MModelCollection> getCollections() {
        return this.collections;
    }

    @Generated
    public boolean isSlim() {
        return this.slim;
    }

    @Generated
    public void setSlim(boolean slim) {
        this.slim = slim;
    }

    @Generated
    public void setDrawer(Drawer drawer) {
        this.drawer = drawer;
    }

    public static class Drawer {
        private final Map<String, AtlasSprite> sprites = new HashMap<String, AtlasSprite>();
        private final TotemDollModel model;

        public Drawer(TotemDollModel model) {
            this.model = model;
        }

        public void requestDrawingPartWithSprite(String part, AtlasSprite sprite) {
            this.sprites.put(part, sprite);
        }

        public void draw(class_4587 matrices, class_4597 provider, AtlasSprite mainTexture, int light, int overlay, int color) {
            LockableAtlasTexture atlasTexture = MyTotemDollAtlasManager.getNullableAtlasTexture();
            if (atlasTexture == null) {
                MyTotemDollClient.LOGGER.error("Game tried to render doll model, but atlas not initialized yet!");
                return;
            }
            MModelCollection leftArm = this.model.getLeftArm();
            MModelCollection rightArm = this.model.getRightArm();
            TotemDollModel.enableIfPresent(leftArm);
            TotemDollModel.enableIfPresent(rightArm);
            class_1921 renderLayer = MyTotemDollAtlasManager.getRenderLayer();
            boolean wasLocked = atlasTexture.isLocked();
            if (!wasLocked) {
                atlasTexture.setLocked(true);
            }
            this.model.getMain().draw(matrices, provider, atlasTexture.getAtlas(), renderLayer, mainTexture, this.sprites, light, overlay, color);
            if (!wasLocked) {
                atlasTexture.setLocked(false);
            }
            TotemDollModel.disableIfPresent(leftArm);
            TotemDollModel.disableIfPresent(rightArm);
            this.sprites.clear();
        }

        public void prepareForRender() {
            this.sprites.clear();
        }
    }
}

