/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.gui.tooltip.tags;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import net.lopymine.mtd.tag.CustomModelTag;
import net.lopymine.mtd.tag.Tag;
import net.lopymine.mtd.tag.manager.TagsManager;
import net.lopymine.mtd.utils.DrawUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class TagsTooltipComponent
implements class_5684 {
    private final Map<class_2960, class_2561> rows = new HashMap<class_2960, class_2561>();
    @Nullable
    private CustomModelTag modelTag;
    @Nullable
    private class_2561 modelTagName;

    public TagsTooltipComponent(String tags) {
        Char2ObjectMap<Tag> registeredTags = TagsManager.getRegisteredTags();
        Map<Character, CustomModelTag> customModelIdsTags = TagsManager.getCustomModelIdsTags();
        TagsManager.getTags(tags).forEach(i -> {
            char c = (char)i;
            if (registeredTags.containsKey(c)) {
                this.rows.put(TagsManager.getTagIcon(c), TagsManager.getAppliedTagDescription(c));
            } else {
                CustomModelTag modelTag = (CustomModelTag)customModelIdsTags.get(Character.valueOf(c));
                if (modelTag != null) {
                    this.modelTag = modelTag;
                }
            }
        });
        if (this.modelTag != null) {
            this.modelTagName = class_2561.method_43470((String)(" > " + this.modelTag.getModelName() + " <")).method_27692(class_124.field_1078);
        }
    }

    public int method_32661(class_327 textRenderer) {
        return 10 * this.rows.size() + (this.modelTagName != null ? 10 : 0);
    }

    public int method_32664(class_327 textRenderer) {
        int maxWidth = 0;
        for (class_2561 text : this.rows.values()) {
            int textWidth = textRenderer.method_27525((class_5348)text) + 10;
            maxWidth = Math.max(maxWidth, textWidth);
        }
        return maxWidth;
    }

    public void method_32666(class_327 textRenderer, int x, int y, int w, int h, class_332 context) {
        int yOffset = 0;
        int space = textRenderer.method_27525((class_5348)class_5244.method_48320());
        for (Map.Entry<class_2960, class_2561> entry : this.rows.entrySet()) {
            DrawUtils.drawTexture(context, entry.getKey(), x + space, y + yOffset - 1, 0.0f, 0.0f, 10, 10, 10, 10);
            context.method_51439(textRenderer, entry.getValue(), x + space + 10 + 4, y + yOffset, -1, true);
            yOffset += 10;
        }
        if (this.modelTagName != null) {
            context.method_51439(textRenderer, this.modelTagName, x + space, y + yOffset, -1, true);
        }
    }
}

