/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.gui.widget.tag;

import lombok.Generated;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.config.other.vector.Vec2i;
import net.lopymine.mtd.gui.widget.tag.TagButtonWidget;
import net.lopymine.mtd.tag.Tag;
import net.minecraft.class_11909;
import net.minecraft.class_332;

public class DraggingTagButtonWidget
extends TagButtonWidget {
    private final int originalX;
    private final int originalY;
    private int originX;
    private int originY;
    private boolean dragging;

    public DraggingTagButtonWidget(Tag tag, int originX, int originY, int originalX, int originalY, int x, int y, TagButtonWidget.TagPressAction pressAction) {
        super(tag, x, y, pressAction);
        this.originX = originX;
        this.originY = originY;
        this.originalX = originalX;
        this.originalY = originalY;
    }

    public boolean method_25402(class_11909 button, boolean doubled) {
        if (!this.over(button.comp_4798(), button.comp_4799())) {
            return false;
        }
        if (this.isResetPosButton(button.method_74245())) {
            this.resetPosition();
            return true;
        }
        if (this.isDraggingButton(button.method_74245())) {
            this.setDragging(true);
            return true;
        }
        return super.method_25402(button, doubled);
    }

    public boolean method_25403(class_11909 button, double deltaX, double deltaY) {
        if (this.isDragging() && this.isDraggingButton(button.method_74245())) {
            return true;
        }
        return super.method_25403(button, deltaX, deltaY);
    }

    public boolean method_25406(class_11909 button) {
        if (this.isDragging()) {
            this.setDragging(false);
            this.setDraggingPosition((int)button.comp_4798(), (int)button.comp_4799());
            return true;
        }
        return false;
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderPlease(context, mouseX, mouseY);
    }

    private void renderPlease(class_332 context, int mouseX, int mouseY) {
        int x = this.isDragging() ? mouseX - this.method_25368() / 2 : this.method_46426();
        int y = this.isDragging() ? mouseY - this.method_25364() / 2 : this.method_46427();
        super.renderButton(context, x, y);
        if (!this.isDragging()) {
            this.requestTooltip();
        }
    }

    private void resetPosition() {
        this.setDraggingPosition(this.originalX, this.originalY);
    }

    private void setDraggingPosition(int draggingX, int draggingY) {
        MyTotemDollConfig config = MyTotemDollConfig.getInstance();
        Vec2i pos = config.getTagButtonPos();
        pos.setX(draggingX - this.method_25368() / 2 - this.originX);
        pos.setY(draggingY - this.method_25364() / 2 - this.originY);
        config.save();
        this.method_48229(draggingX, draggingY);
    }

    private boolean isDraggingButton(int button) {
        return button == 1;
    }

    private boolean isResetPosButton(int button) {
        return button == 2;
    }

    @Generated
    public int getOriginalX() {
        return this.originalX;
    }

    @Generated
    public int getOriginalY() {
        return this.originalY;
    }

    @Generated
    public int getOriginX() {
        return this.originX;
    }

    @Generated
    public int getOriginY() {
        return this.originY;
    }

    @Generated
    public boolean isDragging() {
        return this.dragging;
    }

    @Generated
    public void setOriginX(int originX) {
        this.originX = originX;
    }

    @Generated
    public void setOriginY(int originY) {
        this.originY = originY;
    }

    @Generated
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }
}

