/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.gui.widget.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.extension.ItemStackExtension;
import net.lopymine.mtd.gui.widget.list.AbstractVersionedEntryListWidget;
import net.lopymine.mtd.gui.widget.tag.CustomModelTagButtonWidget;
import net.lopymine.mtd.gui.widget.tag.TagButtonWidget;
import net.lopymine.mtd.tag.CustomModelTag;
import net.lopymine.mtd.tag.Tag;
import net.lopymine.mtd.tag.manager.TagsManager;
import net.lopymine.mtd.utils.DrawUtils;
import net.lopymine.mtd.utils.RenderUtils;
import net.lopymine.mtd.utils.tooltip.IRequestableTooltipScreen;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagMenuWidget
extends AbstractVersionedEntryListWidget<TagRow> {
    public static final class_2960 BACKGROUND = MyTotemDoll.id("textures/gui/tag_menu/background_new.png");

    public TagMenuWidget(int x, int y, Renamer renamer) {
        super(x, y, 30, 125, 16);
        List list = TagsManager.getRegisteredTags().values().stream().toList();
        for (int i = 0; i < list.size(); i += 2) {
            List<Tag> tags = TagMenuWidget.getRangeOfList(list, i);
            ArrayList<TagButtonWidget> widgets = new ArrayList<TagButtonWidget>();
            for (Tag tag : tags) {
                TagButtonWidget tagButtonWidget = TagMenuWidget.createTagButtonWidget(renamer, tag);
                widgets.add(tagButtonWidget);
            }
            this.method_25321((class_350.class_351)new TagRow(widgets));
        }
        List<CustomModelTag> customModelIds = TagsManager.getCustomModelIdsTags().values().stream().toList();
        if (!customModelIds.isEmpty()) {
            this.method_25321((class_350.class_351)new SeparatorRow((class_2561)MyTotemDoll.text("tag_menu.custom_models.title", new Object[0])));
        }
        ArrayList<TagButtonWidget> allCustomModelWidgets = new ArrayList<TagButtonWidget>();
        for (int i = 0; i < customModelIds.size(); i += 2) {
            List<CustomModelTag> tags = TagMenuWidget.getRangeOfList(customModelIds, i);
            ArrayList<TagButtonWidget> tagRowWidget = new ArrayList<TagButtonWidget>();
            for (CustomModelTag tag : tags) {
                CustomModelTagButtonWidget tagButtonWidget = TagMenuWidget.createCustomModelTagButtonWidget(renamer, tag, allCustomModelWidgets);
                tagRowWidget.add(tagButtonWidget);
                allCustomModelWidgets.add(tagButtonWidget);
            }
            this.method_25321((class_350.class_351)new TagRow(tagRowWidget));
        }
    }

    public int method_25322() {
        return 30;
    }

    protected void method_57715(class_332 context) {
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        TagRow entry = (TagRow)this.method_25308(mouseX, mouseY);
        if (entry != null && entry.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void updateButtons(class_1799 stack) {
        String tags = TagMenuWidget.getTags(stack);
        for (TagButtonWidget widget : this.getAllTagButtons()) {
            if (tags != null) {
                widget.setPressed(tags.contains(widget.getText()));
                continue;
            }
            widget.setPressed(false);
        }
    }

    public void updateCustomModelTagButtons(class_1799 stack) {
        this.updateCustomModelTagButtonsData(stack);
    }

    private void updateCustomModelTagButtonsData(class_1799 stack) {
        TotemDollData totemDollData = ItemStackExtension.getTotemDollData(stack);
        for (CustomModelTagButtonWidget widget : this.getCustomModelTagButtons()) {
            widget.updateData(totemDollData);
        }
    }

    private List<TagButtonWidget> getAllTagButtons() {
        return this.method_25396().stream().map(TagRow::method_25396).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<CustomModelTagButtonWidget> getCustomModelTagButtons() {
        return this.method_25396().stream().map(TagRow::method_25396).flatMap(Collection::stream).flatMap(widget -> {
            if (widget instanceof CustomModelTagButtonWidget) {
                CustomModelTagButtonWidget tagButtonWidget = (CustomModelTagButtonWidget)((Object)widget);
                return Stream.of(tagButtonWidget);
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    @NotNull
    private static TagButtonWidget createTagButtonWidget(Renamer renamer, Tag tag) {
        char character = tag.getTag();
        TagButtonWidget tagButtonWidget = new TagButtonWidget(tag, 0, 0, widget -> TagMenuWidget.updateItemStackName(renamer, widget, character));
        tagButtonWidget.setTooltip(TagsManager.getTagDescription(Character.valueOf(character)));
        return tagButtonWidget;
    }

    @NotNull
    private static CustomModelTagButtonWidget createCustomModelTagButtonWidget(Renamer renamer, CustomModelTag tag, List<TagButtonWidget> allCustomModelWidgets) {
        char character = tag.getTag();
        return new CustomModelTagButtonWidget(tag, 0, 0, tagButtonWidget -> {
            TagMenuWidget.updateItemStackName(renamer, tagButtonWidget, character);
            for (TagButtonWidget widget : allCustomModelWidgets) {
                if (((Object)((Object)widget)).equals((Object)tagButtonWidget)) continue;
                widget.setPressed(false);
                TagMenuWidget.updateItemStackName(renamer, widget, widget.getTag().getTag());
            }
        });
    }

    @NotNull
    private static <E> List<E> getRangeOfList(List<E> list, int startIndex) {
        ArrayList<E> tags = new ArrayList<E>();
        tags.add(list.get(startIndex));
        if (startIndex + 1 < list.size()) {
            tags.add(list.get(startIndex + 1));
        }
        return tags;
    }

    private static void updateItemStackName(Renamer renamer, TagButtonWidget b, char c) {
        String name = b.isPressed() ? TagsManager.addTag(renamer.getName(), Character.valueOf(c)) : TagsManager.removeTag(renamer.getName(), Character.valueOf(c));
        renamer.setName(name);
    }

    @Nullable
    private static String getTags(class_1799 stack) {
        class_2561 text = ItemStackExtension.getRealCustomName(stack);
        if (text == null) {
            return null;
        }
        String customName = text.getString();
        return TagsManager.getTagsFromName(customName);
    }

    public void method_48229(int x, int y) {
        super.method_48229(x, y);
        this.method_44382(this.method_44387());
    }

    public static interface Renamer {
        public String getName();

        public void setName(String var1);
    }

    public static class TagRow
    extends class_4265.class_4266<TagRow> {
        private final List<TagButtonWidget> buttons;

        public TagRow(List<TagButtonWidget> buttons) {
            this.buttons = buttons;
        }

        public List<TagButtonWidget> method_37025() {
            return this.buttons;
        }

        public List<TagButtonWidget> method_25396() {
            return this.buttons;
        }

        public void method_46421(int x) {
            super.method_46421(x);
            int pos = x;
            for (TagButtonWidget button : this.buttons) {
                button.method_46421(pos);
                pos += button.method_25368() + 2;
            }
        }

        public void method_46419(int y) {
            super.method_46419(y);
            for (TagButtonWidget button : this.buttons) {
                button.method_46419(y);
            }
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            for (TagButtonWidget widget : this.buttons) {
                widget.setCanBeHovered(hovered);
                widget.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }
    }

    public static class SeparatorRow
    extends TagRow {
        public static final class_2960 SEPARATOR = MyTotemDoll.id("textures/gui/tag_menu/separator.png");
        private final class_2561 text;

        public SeparatorRow(class_2561 text) {
            super(new ArrayList<TagButtonWidget>());
            this.text = text;
        }

        @Override
        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.render(context, this.method_46427(), this.method_46426(), this.method_25364(), hovered);
        }

        private void render(class_332 context, int y, int x, int entryHeight, boolean hovered) {
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1772;
            RenderUtils.enableBlend();
            DrawUtils.drawTexture(context, SEPARATOR, x - 1, y + entryHeight / 2 - 3, 0.0f, 0.0f, 32, 7, 32, 7);
            RenderUtils.disableBlend();
            if (hovered) {
                class_437 class_4372 = client.field_1755;
                if (!(class_4372 instanceof IRequestableTooltipScreen)) {
                    return;
                }
                IRequestableTooltipScreen tooltipScreen = (IRequestableTooltipScreen)class_4372;
                tooltipScreen.myTotemDoll$requestTooltip((c, mx, my, d) -> DrawUtils.drawTooltip(context, textRenderer.method_1728((class_5348)this.text, 10000).stream().map(class_5684::method_32662).collect(Collectors.toList()), mx, my));
            }
        }
    }
}

