/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.bb;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.lopymine.mtd.config.other.vector.Vec3f;
import net.lopymine.mtd.extension.DilationExtension;
import net.lopymine.mtd.utils.CodecUtils;
import net.minecraft.class_156;
import net.minecraft.class_2350;
import net.minecraft.class_4844;
import net.minecraft.class_5603;
import net.minecraft.class_5605;

public class BBCube {
    public static Codec<class_5605> DILATION_CODEC = Codec.FLOAT.xmap(class_5605::new, dilation -> Float.valueOf(DilationExtension.getRadiusX(dilation)));
    public static final Codec<BBCube> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("name", Codec.STRING, BBCube::getName), CodecUtils.option("from", Vec3f.CODEC, BBCube::getFrom), CodecUtils.option("to", Vec3f.CODEC, BBCube::getTo), CodecUtils.option("origin", Vec3f.CODEC, BBCube::getOrigin), CodecUtils.option("rotation", new Vec3f(), Vec3f.CODEC, BBCube::getRotation), CodecUtils.option("inflate", class_5605.field_27715, DILATION_CODEC, BBCube::getInflate), CodecUtils.option("autouv", Codec.INT, BBCube::getAutoUV), CodecUtils.option("uuid", class_4844.field_40825, BBCube::getUuid), CodecUtils.option("visibility", true, Codec.BOOL, BBCube::isVisible)).apply((Applicative)inst, BBCube::new));
    private String name;
    private Vec3f from;
    private Vec3f to;
    private Vec3f origin;
    private Vec3f rotation;
    private class_5605 inflate;
    private int autoUV;
    private BBCubeFaces faces;
    private UUID uuid;
    private boolean visible;

    public BBCube(String name, Vec3f from, Vec3f to, Vec3f origin, Vec3f rotation, class_5605 inflate, int autoUV, UUID uuid, boolean visible) {
        this.name = name;
        this.from = from;
        this.to = to;
        this.origin = origin;
        this.rotation = rotation;
        this.inflate = inflate;
        this.autoUV = autoUV;
        this.faces = new BBCubeFaces(new HashMap<class_2350, BBCubeFace>());
        this.uuid = uuid;
        this.visible = visible;
    }

    public class_5603 getTransformation() {
        return class_5603.method_32091((float)this.origin.x(), (float)this.origin.y(), (float)this.origin.z(), (float)((float)(-Math.toRadians(this.rotation.x()))), (float)((float)(-Math.toRadians(this.rotation.y()))), (float)((float)Math.toRadians(this.rotation.z())));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Vec3f getFrom() {
        return this.from;
    }

    @Generated
    public Vec3f getTo() {
        return this.to;
    }

    @Generated
    public Vec3f getOrigin() {
        return this.origin;
    }

    @Generated
    public Vec3f getRotation() {
        return this.rotation;
    }

    @Generated
    public class_5605 getInflate() {
        return this.inflate;
    }

    @Generated
    public int getAutoUV() {
        return this.autoUV;
    }

    @Generated
    public BBCubeFaces getFaces() {
        return this.faces;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public boolean isVisible() {
        return this.visible;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setFrom(Vec3f from) {
        this.from = from;
    }

    @Generated
    public void setTo(Vec3f to) {
        this.to = to;
    }

    @Generated
    public void setOrigin(Vec3f origin) {
        this.origin = origin;
    }

    @Generated
    public void setRotation(Vec3f rotation) {
        this.rotation = rotation;
    }

    @Generated
    public void setInflate(class_5605 inflate) {
        this.inflate = inflate;
    }

    @Generated
    public void setAutoUV(int autoUV) {
        this.autoUV = autoUV;
    }

    @Generated
    public void setFaces(BBCubeFaces faces) {
        this.faces = faces;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Generated
    public BBCube(String name, Vec3f from, Vec3f to, Vec3f origin, Vec3f rotation, class_5605 inflate, int autoUV, BBCubeFaces faces, UUID uuid, boolean visible) {
        this.name = name;
        this.from = from;
        this.to = to;
        this.origin = origin;
        this.rotation = rotation;
        this.inflate = inflate;
        this.autoUV = autoUV;
        this.faces = faces;
        this.uuid = uuid;
        this.visible = visible;
    }

    public static class BBCubeFaces {
        private Map<class_2350, BBCubeFace> faces;

        @Generated
        public Map<class_2350, BBCubeFace> getFaces() {
            return this.faces;
        }

        @Generated
        public void setFaces(Map<class_2350, BBCubeFace> faces) {
            this.faces = faces;
        }

        @Generated
        public BBCubeFaces(Map<class_2350, BBCubeFace> faces) {
            this.faces = faces;
        }
    }

    public static class UV {
        public static final Codec<UV> CODEC = Codec.FLOAT.listOf().comapFlatMap(coordinates -> class_156.method_33141((List)coordinates, (int)4).map(list -> new UV(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue(), ((Float)list.get(3)).floatValue())), vec -> List.of(Float.valueOf(vec.getFromU()), Float.valueOf(vec.getFromV()), Float.valueOf(vec.getToU()), Float.valueOf(vec.getToV())));
        private float fromU;
        private float fromV;
        private float toU;
        private float toV;

        public boolean isDummy() {
            return this.fromU == this.toU && this.fromV == this.toV;
        }

        @Generated
        public float getFromU() {
            return this.fromU;
        }

        @Generated
        public float getFromV() {
            return this.fromV;
        }

        @Generated
        public float getToU() {
            return this.toU;
        }

        @Generated
        public float getToV() {
            return this.toV;
        }

        @Generated
        public void setFromU(float fromU) {
            this.fromU = fromU;
        }

        @Generated
        public void setFromV(float fromV) {
            this.fromV = fromV;
        }

        @Generated
        public void setToU(float toU) {
            this.toU = toU;
        }

        @Generated
        public void setToV(float toV) {
            this.toV = toV;
        }

        @Generated
        public UV(float fromU, float fromV, float toU, float toV) {
            this.fromU = fromU;
            this.fromV = fromV;
            this.toU = toU;
            this.toV = toV;
        }
    }

    public static class BBCubeFace {
        public static final Codec<BBCubeFace> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("uv", UV.CODEC, BBCubeFace::getUv), CodecUtils.option("rotation", 0, Codec.INT, BBCubeFace::getRotation)).apply((Applicative)inst, BBCubeFace::new));
        private UV uv;
        private int rotation;

        @Generated
        public UV getUv() {
            return this.uv;
        }

        @Generated
        public int getRotation() {
            return this.rotation;
        }

        @Generated
        public void setUv(UV uv) {
            this.uv = uv;
        }

        @Generated
        public void setRotation(int rotation) {
            this.rotation = rotation;
        }

        @Generated
        public BBCubeFace(UV uv, int rotation) {
            this.uv = uv;
            this.rotation = rotation;
        }
    }
}

