/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.bb;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.lopymine.mtd.config.other.vector.Vec3f;
import net.lopymine.mtd.doll.renderer.DollRenderContext;
import net.lopymine.mtd.extension.ModelTransformationExtension;
import net.lopymine.mtd.model.bb.BBCube;
import net.lopymine.mtd.model.bb.BBGroup;
import net.lopymine.mtd.utils.CodecUtils;
import net.minecraft.class_2960;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class BBModel {
    private class_2960 location;
    private String name;
    private BBModelMeta meta;
    private BBModelResolution resolution;
    private List<BBCube> cubes;
    private List<BBGroup> groups;
    private boolean frontGuiLight;
    private class_809 transformation;

    @Nullable
    public BBCube getCube(UUID uuid) {
        for (BBCube cube : this.cubes) {
            if (!cube.getUuid().equals(uuid)) continue;
            return cube;
        }
        return null;
    }

    @Generated
    public void setLocation(class_2960 location) {
        this.location = location;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setMeta(BBModelMeta meta) {
        this.meta = meta;
    }

    @Generated
    public void setResolution(BBModelResolution resolution) {
        this.resolution = resolution;
    }

    @Generated
    public void setCubes(List<BBCube> cubes) {
        this.cubes = cubes;
    }

    @Generated
    public void setGroups(List<BBGroup> groups) {
        this.groups = groups;
    }

    @Generated
    public void setFrontGuiLight(boolean frontGuiLight) {
        this.frontGuiLight = frontGuiLight;
    }

    @Generated
    public void setTransformation(class_809 transformation) {
        this.transformation = transformation;
    }

    @Generated
    public class_2960 getLocation() {
        return this.location;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BBModelMeta getMeta() {
        return this.meta;
    }

    @Generated
    public BBModelResolution getResolution() {
        return this.resolution;
    }

    @Generated
    public List<BBCube> getCubes() {
        return this.cubes;
    }

    @Generated
    public List<BBGroup> getGroups() {
        return this.groups;
    }

    @Generated
    public boolean isFrontGuiLight() {
        return this.frontGuiLight;
    }

    @Generated
    public class_809 getTransformation() {
        return this.transformation;
    }

    @Generated
    public BBModel(class_2960 location, String name, BBModelMeta meta, BBModelResolution resolution, List<BBCube> cubes, List<BBGroup> groups, boolean frontGuiLight, class_809 transformation) {
        this.location = location;
        this.name = name;
        this.meta = meta;
        this.resolution = resolution;
        this.cubes = cubes;
        this.groups = groups;
        this.frontGuiLight = frontGuiLight;
        this.transformation = transformation;
    }

    public static class BBModelMeta {
        public static final Codec<BBModelMeta> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("format_version", Codec.STRING, BBModelMeta::getVersion), CodecUtils.option("model_format", Codec.STRING, BBModelMeta::getModel)).apply((Applicative)inst, BBModelMeta::new));
        private String version;
        private String model;

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setModel(String model) {
            this.model = model;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public BBModelMeta(String version, String model) {
            this.version = version;
            this.model = model;
        }
    }

    public static class BBModelResolution {
        public static final Codec<BBModelResolution> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("width", Codec.INT, BBModelResolution::getWidth), CodecUtils.option("height", Codec.INT, BBModelResolution::getHeight)).apply((Applicative)inst, BBModelResolution::new));
        private int width;
        private int height;

        @Generated
        public void setWidth(int width) {
            this.width = width;
        }

        @Generated
        public void setHeight(int height) {
            this.height = height;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public BBModelResolution(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    public static final class Transformations {
        private static final Vec3f DEFAULT_ROTATION = new Vec3f(0.0f, 0.0f, 0.0f);
        private static final Vec3f DEFAULT_TRANSLATION = new Vec3f(0.0f, 0.0f, 0.0f);
        private static final Vec3f DEFAULT_SCALE = new Vec3f(1.0f, 1.0f, 1.0f);
        public static final Codec<class_804> TRANSFORMATION_CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("rotation", DEFAULT_ROTATION, Vec3f.CODEC, o -> new Vec3f(o.comp_3747())), CodecUtils.option("translation", DEFAULT_TRANSLATION, Vec3f.CODEC, o -> new Vec3f(o.comp_3748())), CodecUtils.option("scale", DEFAULT_SCALE, Vec3f.CODEC, o -> new Vec3f(o.comp_3749()))).apply((Applicative)instance, Transformations::prepareTransformation));
        public static final Codec<class_809> MODEL_TRANSFORMATION_CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option(DollRenderContext.D_THIRD_PERSON_LEFT_HAND.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getTl(o)), CodecUtils.option(DollRenderContext.D_THIRD_PERSON_RIGHT_HAND.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getTr(o)), CodecUtils.option(DollRenderContext.D_FIRST_PERSON_LEFT_HAND.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getFl(o)), CodecUtils.option(DollRenderContext.D_FIRST_PERSON_RIGHT_HAND.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getFr(o)), CodecUtils.option(DollRenderContext.D_HEAD.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getHead(o)), CodecUtils.option(DollRenderContext.D_GUI.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getGui(o)), CodecUtils.option(DollRenderContext.D_GROUND.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getGround(o)), CodecUtils.option(DollRenderContext.D_FIXED.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getFixed(o)), CodecUtils.option(DollRenderContext.D_ON_SHELF.getId(), class_804.field_4284, TRANSFORMATION_CODEC, o -> ModelTransformationExtension.getOnShelf(o))).apply((Applicative)instance, class_809::new));

        private static class_804 prepareTransformation(Vec3f rotation, Vec3f translation, Vec3f scale) {
            translation.mul(0.0625f);
            return new class_804((Vector3fc)rotation, (Vector3fc)translation, (Vector3fc)scale);
        }
    }
}

