/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.model.bb.manager;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.fabricmc.loader.api.SemanticVersion;
import net.lopymine.mtd.api.Response;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasManager;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasSpriteManager;
import net.lopymine.mtd.config.other.vector.Vec3f;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.manager.StandardTotemDollManager;
import net.lopymine.mtd.doll.manager.TotemDollManager;
import net.lopymine.mtd.doll.model.TotemDollModel;
import net.lopymine.mtd.model.base.MCubeBuilder;
import net.lopymine.mtd.model.base.MModel;
import net.lopymine.mtd.model.base.MModelBuilder;
import net.lopymine.mtd.model.bb.BBCube;
import net.lopymine.mtd.model.bb.BBGroup;
import net.lopymine.mtd.model.bb.BBModel;
import net.lopymine.mtd.model.bb.BBOutliner;
import net.lopymine.mtd.model.bb.ModelState;
import net.lopymine.mtd.model.bb.manager.MModelFactory;
import net.lopymine.mtd.utils.CodecUtils;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4844;
import net.minecraft.class_5603;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBenchModelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"%s/BlockBenchModelManager".formatted("My Totem Doll"));
    private static final Map<class_2960, CompletableFuture<Response<MModelFactory>>> LOADED_MODELS = new ConcurrentHashMap<class_2960, CompletableFuture<Response<MModelFactory>>>();
    private static final Set<String> SUPPORTED_MODEL_FORMATS = Set.of("java_block", "free_rotation");

    @Nullable
    public static MModel getModel(class_2960 id) {
        return BlockBenchModelManager.createMModel(BlockBenchModelManager.getMModelFactoryAsResponse(id)).value();
    }

    @NotNull
    public static Response<MModelFactory> getMModelFactoryAsResponse(class_2960 id) {
        CompletableFuture future = LOADED_MODELS.computeIfAbsent(id, key -> CompletableFuture.completedFuture(BlockBenchModelManager.createMModelFactory(id)));
        if (!future.isDone()) {
            return Response.empty(99);
        }
        try {
            return future.getNow(Response.empty(-1));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load model, exception from future:", (Throwable)e);
            return Response.empty(-1);
        }
    }

    public static void consumeModelById(class_2960 id, Consumer<MModel> consumer) {
        BlockBenchModelManager.getModelAsyncAsResponse(id, response -> {
            MModel value = (MModel)((Object)((Object)response.value()));
            if (value != null) {
                consumer.accept(value);
            }
        });
    }

    public static void getModelAsyncAsResponse(class_2960 id, Consumer<Response<MModel>> consumer) {
        LOADED_MODELS.computeIfAbsent(id, key -> CompletableFuture.supplyAsync(() -> BlockBenchModelManager.createMModelFactory(id))).thenAccept(response -> consumer.accept(BlockBenchModelManager.createMModel(response)));
    }

    @NotNull
    private static Response<MModel> createMModel(@Nullable Response<MModelFactory> response) {
        try {
            if (response == null) {
                return Response.empty(-11);
            }
            MModelFactory factory = response.value();
            int statusCode = response.statusCode();
            if (factory == null) {
                return Response.empty(statusCode);
            }
            return Response.of(statusCode, (MModel)((Object)factory.get()));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load model, exception from future:", (Throwable)e);
            return Response.empty(-10);
        }
    }

    @NotNull
    private static Response<MModelFactory> createMModelFactory(class_2960 id) {
        Response<BBModel> response = BlockBenchModelManager.parseModel(id);
        int statusCode = response.statusCode();
        BBModel value = response.value();
        if (value == null) {
            return Response.empty(statusCode);
        }
        MModelFactory factory = BlockBenchModelManager.createMModelFactory(value);
        return Response.of(statusCode, factory);
    }

    @NotNull
    private static Response<BBModel> parseModel(class_2960 id) {
        try {
            JsonObject jsonObject = BlockBenchModelManager.readAsJsonObject(id);
            String name = (String)CodecUtils.decode("name", Codec.STRING, jsonObject);
            BBModel.BBModelMeta meta = CodecUtils.decode("meta", BBModel.BBModelMeta.CODEC, jsonObject);
            if (meta == null) {
                LOGGER.warn("Failed to parse metadata for model \"{}\"! Skipping.", (Object)name);
                return Response.empty(101);
            }
            if (!SUPPORTED_MODEL_FORMATS.contains(meta.getModel())) {
                LOGGER.warn("Found model with unsupported model format. Name: \"{}\", Model Format: \"{}\". Skipping.", (Object)meta.getModel(), (Object)name);
                return Response.empty(102);
            }
            SemanticVersion modelVersion = SemanticVersion.parse((String)meta.getVersion());
            if (modelVersion.compareTo((Object)SemanticVersion.parse((String)"5.0")) >= 0) {
                return BlockBenchModelManager.processBBModel50(id, jsonObject, name, meta);
            }
            if (modelVersion.compareTo((Object)SemanticVersion.parse((String)"4.10")) >= 0) {
                return BlockBenchModelManager.processBBModel410(id, jsonObject, name, meta);
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            LOGGER.warn("Failed to find bbmodel find with id \"{}\"", (Object)id.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load bbmodel find with id \"%s\"".formatted(id.toString()), (Throwable)e);
        }
        return Response.empty(100);
    }

    @NotNull
    private static Response<BBModel> processBBModel410(class_2960 id, JsonObject jsonObject, String name, BBModel.BBModelMeta meta) {
        BBModel.BBModelResolution resolution = CodecUtils.decode("resolution", BBModel.BBModelResolution.CODEC, jsonObject);
        if (resolution == null) {
            LOGGER.warn("Failed to parse resolution from 4.10 format for model \"{}\"! Skipping.", (Object)name);
            return Response.empty(103);
        }
        List<BBCube> cubes = BlockBenchModelManager.parseCubes(jsonObject);
        BBModelGroupsAndRootCubes result = BlockBenchModelManager.parseGroupsAndCubes410(jsonObject);
        return Response.of(0, BlockBenchModelManager.createFinalBBModel(id, jsonObject, name, meta, result.rootCubes(), result.groups(), resolution, cubes));
    }

    @NotNull
    private static Response<BBModel> processBBModel50(class_2960 id, JsonObject jsonObject, String name, BBModel.BBModelMeta meta) {
        BBModel.BBModelResolution resolution = CodecUtils.decode("resolution", BBModel.BBModelResolution.CODEC, jsonObject);
        if (resolution == null) {
            LOGGER.warn("Failed to parse resolution from 5.0 format for model \"{}\"! Skipping.", (Object)name);
            return Response.empty(103);
        }
        List<BBCube> cubes = BlockBenchModelManager.parseCubes(jsonObject);
        BBModelGroupsAndRootCubes result = BlockBenchModelManager.parseGroupsAndCubes50(jsonObject);
        return Response.of(0, BlockBenchModelManager.createFinalBBModel(id, jsonObject, name, meta, result.rootCubes(), result.groups(), resolution, cubes));
    }

    @NotNull
    private static List<BBCube> parseCubes(JsonObject jsonObject) {
        ArrayList<BBCube> cubes = new ArrayList<BBCube>();
        for (JsonElement jsonElement : jsonObject.get("elements").getAsJsonArray()) {
            JsonObject element = jsonElement.getAsJsonObject();
            if (!element.get("type").getAsString().equals("cube")) continue;
            CodecUtils.decode(BBCube.CODEC, (JsonElement)element, cube -> {
                cube.setFaces(BlockBenchModelManager.parseCubeFaces(element.get("faces").getAsJsonObject()));
                cubes.add((BBCube)cube);
            });
        }
        return cubes;
    }

    private static BBCube.BBCubeFaces parseCubeFaces(JsonObject faces) {
        BBCube.BBCubeFaces cubeFaces = new BBCube.BBCubeFaces(new HashMap<class_2350, BBCube.BBCubeFace>());
        for (class_2350 direction : class_2350.values()) {
            String id = direction.method_10151();
            JsonObject face = faces.get(id).getAsJsonObject();
            if (face.has("texture") && face.get("texture").isJsonNull()) continue;
            BBCube.UV uv = CodecUtils.decode("uv", BBCube.UV.CODEC, face);
            Integer decodedRotation = (Integer)CodecUtils.decode("rotation", Codec.INT, face);
            int rotation = decodedRotation == null ? 0 : decodedRotation;
            BBCube.BBCubeFace cubeFace = new BBCube.BBCubeFace(uv, rotation);
            cubeFaces.getFaces().put(direction, cubeFace);
        }
        return cubeFaces;
    }

    @NotNull
    private static BBModelGroupsAndRootCubes parseGroupsAndCubes50(JsonObject jsonObject) {
        ArrayList<UUID> rootCubes = new ArrayList<UUID>();
        ArrayList outliners = new ArrayList();
        for (Object jsonElement : jsonObject.get("outliner").getAsJsonArray()) {
            CodecUtils.decode(Codec.either(BBOutliner.CODEC, (Codec)class_4844.field_40825), (JsonElement)jsonElement, either -> {
                Optional left = either.left();
                left.ifPresent(outliners::add);
                Optional right = either.right();
                right.ifPresent(rootCubes::add);
            });
        }
        HashMap<UUID, BBGroup> map = new HashMap<UUID, BBGroup>();
        for (JsonElement jsonElement : jsonObject.get("groups").getAsJsonArray()) {
            CodecUtils.decode(BBGroup.CODEC, jsonElement, group -> map.put(group.getUuid(), (BBGroup)group));
        }
        ArrayList<BBGroup> groups = new ArrayList<BBGroup>();
        for (BBOutliner outliner : outliners) {
            BBGroup group2 = BlockBenchModelManager.convertOutlinerToBBGroup(outliner, map);
            if (group2.getName().equals("root")) {
                group2.setName("sub-root-" + String.valueOf(group2.getUuid()));
            }
            groups.add(group2);
        }
        return new BBModelGroupsAndRootCubes(rootCubes, groups);
    }

    private static BBGroup convertOutlinerToBBGroup(BBOutliner outliner, Map<UUID, BBGroup> map) {
        ArrayList<Either<BBGroup, UUID>> children = new ArrayList<Either<BBGroup, UUID>>();
        for (Either<BBOutliner, UUID> either : outliner.getChildren()) {
            Optional left = either.left();
            left.ifPresent(bbOutliner -> children.add(Either.left((Object)BlockBenchModelManager.convertOutlinerToBBGroup(bbOutliner, map))));
            Optional right = either.right();
            right.ifPresent(uuid -> children.add(Either.right((Object)uuid)));
        }
        BBGroup group = map.get(outliner.getUuid());
        group.setChildren(children);
        return group;
    }

    @NotNull
    private static BBModelGroupsAndRootCubes parseGroupsAndCubes410(JsonObject jsonObject) {
        ArrayList<UUID> rootCubes = new ArrayList<UUID>();
        ArrayList<BBGroup> groups = new ArrayList<BBGroup>();
        for (JsonElement jsonElement : jsonObject.get("outliner").getAsJsonArray()) {
            CodecUtils.decode(Codec.either(BBGroup.CODEC, (Codec)class_4844.field_40825), jsonElement, either -> {
                Optional left = either.left();
                left.ifPresent(group -> {
                    if (group.getName().equals("root")) {
                        group.setName("sub-root-" + String.valueOf(group.getUuid()));
                    }
                    groups.add((BBGroup)group);
                });
                Optional right = either.right();
                right.ifPresent(rootCubes::add);
            });
        }
        return new BBModelGroupsAndRootCubes(rootCubes, groups);
    }

    @NotNull
    private static BBModel createFinalBBModel(class_2960 id, JsonObject jsonObject, String name, BBModel.BBModelMeta meta, List<UUID> rootCubes, List<BBGroup> groups, BBModel.BBModelResolution resolution, List<BBCube> cubes) {
        BBGroup rootGroup = new BBGroup("root", new Vec3f(), new Vec3f(), 0, true, UUID.randomUUID(), rootCubes.stream().map(Either::right).toList());
        groups.add(0, rootGroup);
        class_809 display = CodecUtils.decode("display", class_809.field_4301, BBModel.Transformations.MODEL_TRANSFORMATION_CODEC, jsonObject);
        Boolean frontGuiLight = CodecUtils.decode("front_gui_light", false, Codec.BOOL, jsonObject);
        return new BBModel(id, name, meta, resolution, cubes, groups, frontGuiLight, display);
    }

    private static JsonObject readAsJsonObject(class_2960 id) throws IOException {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        InputStream open = resourceManager.open(id);
        return (JsonObject)new Gson().fromJson(new JsonReader((Reader)new InputStreamReader(open)), JsonObject.class);
    }

    private static MModelFactory createMModelFactory(@NotNull BBModel model) {
        MModelBuilder builder = MModelBuilder.builder(ModelState.ROOT);
        for (BBGroup group : model.getGroups()) {
            builder.addChild(group.getName(), BlockBenchModelManager.transformGroupsAndCubes(group, model), model.getLocation());
        }
        BBModel.BBModelResolution resolution = model.getResolution();
        builder.collectAllBuiltinTextures().forEach((id, updateConsumer) -> MyTotemDollAtlasSpriteManager.registerDynamicSprite(id, false, updateConsumer::accept));
        MyTotemDollAtlasManager.stitchAndUpdate(MyTotemDollAtlasSpriteManager.getSprites(), null);
        return () -> builder.withTransform(class_5603.method_32090((float)-16.0f, (float)-8.0f, (float)0.0f)).build(resolution.getWidth(), resolution.getHeight()).initAfterBuild(model);
    }

    private static MModelBuilder transformGroupsAndCubes(BBGroup group, BBModel model) {
        MModelBuilder builder = MModelBuilder.builder(ModelState.GROUP);
        for (Either<BBGroup, UUID> either : group.getChildren()) {
            UUID uuid;
            BBCube cube;
            Optional left = either.left();
            Optional right = either.right();
            if (left.isPresent()) {
                BBGroup get = (BBGroup)left.get();
                if (!get.isVisible()) continue;
                builder.addChild(get.getName(), BlockBenchModelManager.transformGroupsAndCubes(get, model), model.getLocation());
                continue;
            }
            if (!right.isPresent() || (cube = model.getCube(uuid = (UUID)right.get())) == null || !cube.isVisible()) continue;
            builder.addChild(cube.getUuid().toString(), BlockBenchModelManager.getChildCube(cube), model.getLocation());
        }
        return builder.withTransform(group.getTransformation());
    }

    private static MModelBuilder getChildCube(BBCube cube) {
        Vec3f from = cube.getFrom();
        Vec3f to = cube.getTo();
        MCubeBuilder cubeBuilder = MCubeBuilder.blockBenchBuilder(from.x(), from.y(), from.z(), to.x(), to.y(), to.z()).withDilation(cube.getInflate());
        BBCube.BBCubeFaces faces = cube.getFaces();
        Map<class_2350, BBCube.BBCubeFace> map = faces.getFaces();
        for (class_2350 value : class_2350.values()) {
            BBCube.UV uv;
            class_2350 direction = value == class_2350.field_11036 || value == class_2350.field_11033 || value == class_2350.field_11034 || value == class_2350.field_11039 ? value.method_10153() : value;
            BBCube.BBCubeFace face = map.get(direction);
            if (face == null || (uv = face.getUv()).isDummy()) continue;
            if (value == class_2350.field_11036 || value == class_2350.field_11033) {
                cubeBuilder.withSide(uv.getToU(), uv.getToV(), uv.getFromU(), uv.getFromV(), value, face.getRotation());
                continue;
            }
            cubeBuilder.withSide(uv.getFromU(), uv.getFromV(), uv.getToU(), uv.getToV(), value, face.getRotation());
        }
        return MModelBuilder.builder(ModelState.CUBE).addCube(cubeBuilder).withTransform(cube.getTransformation());
    }

    public static void reload() {
        LOADED_MODELS.clear();
        for (TotemDollData data : TotemDollManager.getAllLoadedDolls()) {
            data.clearAllFrameModelsCompletely();
            data.setShouldRecreateStandardModel(true);
        }
        TotemDollModel.createDollModel();
        StandardTotemDollManager.initializeStandardDollData();
    }

    private record BBModelGroupsAndRootCubes(List<UUID> rootCubes, List<BBGroup> groups) {
    }
}

