/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.modmenu;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.modmenu.NoConfigLibraryScreen;
import net.lopymine.mtd.yacl.YACLConfigurationScreen;

public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if (fabricLoader.isModLoaded("yet_another_config_lib_v3")) {
            ModContainer modContainer = (ModContainer)fabricLoader.getModContainer("yet_another_config_lib_v3").orElseThrow();
            Version version = modContainer.getMetadata().getVersion();
            try {
                Version requestsVersion = Version.parse((String)"3.8.0+1.21.9-fabric");
                if (version.compareTo((Object)requestsVersion) >= 0) {
                    return YACLConfigurationScreen::createScreen;
                }
            }
            catch (VersionParsingException e) {
                MyTotemDollClient.LOGGER.error("Failed to compare YACL version, tell mod author about this error: ", (Throwable)e);
            }
            return parent -> NoConfigLibraryScreen.createScreenAboutOldVersion(parent, version.getFriendlyString());
        }
        return NoConfigLibraryScreen::createScreen;
    }
}

