/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.optimization;

import java.util.ArrayList;
import java.util.List;
import net.lopymine.mtd.atlas.LockableAtlasTexture;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasManager;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.data.TotemDollRenderProperties;
import net.lopymine.mtd.doll.model.TotemDollModel;
import net.lopymine.mtd.doll.renderer.DollRenderContext;
import net.lopymine.mtd.doll.renderer.TotemDollRenderer;
import net.lopymine.mtd.extension.MatrixStackEntryExtension;
import net.lopymine.mtd.optimization.TotemDollRenderRequest;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4618;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class TotemDollRenderRequestsCollector {
    private static final TotemDollRenderRequestsCollector INSTANCE = new TotemDollRenderRequestsCollector();
    private final class_4587 matrices = new class_4587();
    private final List<TotemDollRenderRequest> requests = new ArrayList<TotemDollRenderRequest>();
    private final TotemDollRenderProperties tempProperties = new TotemDollRenderProperties();

    public static TotemDollRenderRequestsCollector getInstance() {
        return INSTANCE;
    }

    private TotemDollRenderRequestsCollector() {
    }

    public void requestRender(class_4587 matrices, TotemDollData data, class_742 holdingPlayer, DollRenderContext context, int light, int overlay, int outlineColor, @Nullable class_4597 provider) {
        class_4587.class_4665 entry = matrices.method_23760();
        this.requests.add(new TotemDollRenderRequest(entry.method_56822(), data, data.getRenderProperties().copy(), holdingPlayer, context, light, overlay, outlineColor, provider));
    }

    public void render() {
        LockableAtlasTexture atlasTexture = MyTotemDollAtlasManager.getNullableAtlasTexture();
        if (atlasTexture == null) {
            MyTotemDollClient.LOGGER.error("Game tried to render doll model requests, but atlas not initialized yet!");
            return;
        }
        atlasTexture.setLocked(true);
        class_4597.class_4598 mainProvider = class_310.method_1551().method_22940().method_23000();
        class_4618 outlineProvider = class_310.method_1551().method_22940().method_23003();
        for (TotemDollRenderRequest request : this.requests) {
            this.renderRequest(request, (class_4597)(request.provider() == null ? mainProvider : request.provider()), outlineProvider);
        }
        this.requests.clear();
        mainProvider.method_37104();
        atlasTexture.setLocked(false);
    }

    private void renderRequest(TotemDollRenderRequest request, class_4597 mainProvider, class_4618 outlineProvider) {
        this.matrices.method_22903();
        MatrixStackEntryExtension.copyFrom(this.matrices.method_23760(), request.copyPeek());
        TotemDollData data = request.data();
        this.tempProperties.copyFrom(data.getRenderProperties());
        data.getRenderProperties().copyFrom(request.renderProperties());
        data.clearFrameModel();
        TotemDollModel modelToRender = data.getModelToRender();
        modelToRender.resetPartsVisibility();
        data.getRenderProperties().applyToModel(modelToRender);
        TotemDollRenderer.renderDoll(this.matrices, data, request.holdingPlayer(), request.context(), mainProvider, request.light(), request.overlay());
        int argb = request.outlineColor();
        if (argb != 0) {
            outlineProvider.method_23286(argb);
            TotemDollRenderer.renderDoll(this.matrices, data, request.holdingPlayer(), request.context(), (class_4597)outlineProvider, request.light(), request.overlay());
        }
        data.getRenderProperties().copyFrom(this.tempProperties);
        this.matrices.method_22909();
    }
}

