/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.tag.manager;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.pack.TotemDollModelFinder;
import net.lopymine.mtd.tag.CustomModelTag;
import net.lopymine.mtd.tag.Tag;
import net.lopymine.mtd.tag.manager.TagsGenerator;
import net.lopymine.mtd.tag.manager.TagsSkinProviders;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagsManager {
    private static final Char2ObjectMap<CustomModelTag> CUSTOM_MODEL_IDS_TAGS = new Char2ObjectArrayMap();
    private static final Char2ObjectMap<Tag> PREPROCESSOR_TAGS = new Char2ObjectArrayMap();
    private static final Char2ObjectMap<Tag> POSTPROCESSOR_TAGS = new Char2ObjectArrayMap();

    public static Char2ObjectMap<Tag> getRegisteredTags() {
        Char2ObjectLinkedOpenHashMap tags = new Char2ObjectLinkedOpenHashMap(PREPROCESSOR_TAGS);
        tags.putAll(POSTPROCESSOR_TAGS);
        return tags;
    }

    public static Map<Character, CustomModelTag> getCustomModelIdsTags() {
        return CUSTOM_MODEL_IDS_TAGS;
    }

    public static void register() {
        TagsManager.registerPreprocessorTag(Tag.startBuilder('0').setAction(data -> data.getRenderProperties().setSlim(true)).build());
        TagsManager.registerPreprocessorTag(Tag.startBuilder('1').setAction(data -> data.getRenderProperties().setSlim(false)).build());
        TagsManager.registerPostprocessorTag(Tag.startBuilder('2').setAction(data -> data.getRenderProperties().disable(data.getModelToRender().getCape())).build());
        TagsManager.registerPostprocessorTag(Tag.startBuilder('3').setAction(data -> {
            data.getRenderProperties().disable(data.getModelToRender().getCape());
            data.getRenderProperties().enable(data.getModelToRender().getElytra());
        }).build());
    }

    public static void reloadCustomModelIdsTags() {
        Collection<Set<class_2960>> values = TotemDollModelFinder.getFoundedTotemModels().values();
        CharSet characters = TagsManager.getRegisteredTags().keySet();
        TagsGenerator generator = new TagsGenerator();
        CUSTOM_MODEL_IDS_TAGS.clear();
        TagsManager.registerBuiltinCustomModels();
        for (Set<class_2960> value : values) {
            for (class_2960 id : value) {
                Character next = null;
                while (generator.hasNext()) {
                    Character character = generator.next();
                    if (characters.contains(character)) continue;
                    next = character;
                    break;
                }
                if (next == null) {
                    return;
                }
                CUSTOM_MODEL_IDS_TAGS.put(next.charValue(), (Object)CustomModelTag.startBuilder(next.charValue(), id).setAction(data -> data.setFrameMModel(id)).build());
            }
        }
    }

    private static void registerBuiltinCustomModels() {
        TagsManager.registerBuiltinCustomModel('j', "2d_doll");
        TagsManager.registerBuiltinCustomModel('k', "3d_doll");
        TagsManager.registerBuiltinCustomModel('l', "3d_funko");
        TagsManager.registerBuiltinCustomModel('m', "gnom");
        TagsManager.registerBuiltinCustomModel('n', "mini_3d");
        TagsManager.registerBuiltinCustomModel('o', "parrot");
        TagsManager.registerBuiltinCustomModel('p', "player_bucket");
        TagsManager.registerBuiltinCustomModel('q', "pots");
        TagsManager.registerBuiltinCustomModel('r', "rat");
        TagsManager.registerBuiltinCustomModel('s', "stairs");
        TagsManager.registerBuiltinCustomModel('t', "wheelchair");
    }

    private static void registerBuiltinCustomModel(char ch, String modelName) {
        class_2960 modelId = MyTotemDoll.getDollModelId(modelName);
        CustomModelTag tag = CustomModelTag.startBuilder(ch, modelId).setAction(data -> data.setFrameMModel(modelId)).build();
        CUSTOM_MODEL_IDS_TAGS.put(ch, (Object)tag);
        TotemDollModelFinder.getBuiltinTotemModels().add(modelId);
    }

    public static void registerPostprocessorTag(Tag tag) {
        POSTPROCESSOR_TAGS.put(tag.getTag(), (Object)tag);
    }

    public static void registerPreprocessorTag(Tag tag) {
        PREPROCESSOR_TAGS.put(tag.getTag(), (Object)tag);
    }

    public static String getNicknameOrSkinProviderFromName(String name) {
        return TagsManager.getDataFromString(name)[0];
    }

    @Nullable
    public static String getTagsFromName(String name) {
        return TagsManager.getDataFromString(name)[1];
    }

    public static String[] getDataFromString(String name) {
        String[] split = name.split("\\|");
        String o = split[0].trim();
        if (TagsSkinProviders.isProvider(o) && split.length >= 2) {
            String value = split[1].trim();
            String tags = split.length >= 3 ? split[2].trim() : null;
            return new String[]{TagsManager.joinData(o, value), tags};
        }
        String tags = split.length >= 2 ? split[1].trim() : null;
        return new String[]{o, tags};
    }

    public static void processTags(String tags, @NotNull TotemDollData data) {
        TagsManager.processCustomModelIdsTags(tags, data);
        TagsManager.processPreTags(tags, data);
        TagsManager.processPostTags(tags, data);
    }

    public static void processCustomModelIdsTags(String tags, TotemDollData data) {
        TagsManager.processTags(tags, data, CUSTOM_MODEL_IDS_TAGS);
    }

    public static void processPreTags(String tags, @NotNull TotemDollData data) {
        TagsManager.processTags(tags, data, PREPROCESSOR_TAGS);
    }

    public static void processPostTags(String tags, @NotNull TotemDollData data) {
        TagsManager.processTags(tags, data, POSTPROCESSOR_TAGS);
    }

    public static <E extends Tag> void processTags(String tags, @NotNull TotemDollData data, Char2ObjectMap<E> map) {
        TagsManager.getTags(tags).forEach(i -> {
            Tag tag = (Tag)map.get((char)i);
            if (tag == null) {
                return;
            }
            tag.process(data);
        });
    }

    @NotNull
    public static IntStream getRegisteredTags(String tags) {
        Char2ObjectMap<Tag> registeredTags = TagsManager.getRegisteredTags();
        return tags.trim().chars().filter(i -> TagsManager.hasRegisteredTag(registeredTags, (char)i));
    }

    @NotNull
    public static IntStream getTags(String tags) {
        return tags.trim().chars();
    }

    public static String addTag(String string, Character tag) {
        String[] data = TagsManager.getDataFromString(string);
        if (data.length < 2) {
            return string;
        }
        String tags = data[1];
        Object unsortedTags = tags == null ? String.valueOf(tag) : tags + tag;
        data[1] = TagsManager.sortTags((String)unsortedTags);
        return TagsManager.joinData(data);
    }

    private static String sortTags(String unsortedTags) {
        return TagsManager.getTags(unsortedTags).sorted().mapToObj(i -> String.valueOf((char)i)).collect(Collectors.joining());
    }

    private static String joinData(String ... data) {
        return String.join((CharSequence)" | ", data);
    }

    public static String removeTag(String name, Character tag) {
        String[] data = TagsManager.getDataFromString(name);
        if (data.length < 2) {
            return name;
        }
        String tags = data[1];
        String string = data[1] = tags == null ? "" : tags.replace(String.valueOf(tag), "");
        if (data[1].isEmpty()) {
            return data[0].trim();
        }
        return TagsManager.joinData(data);
    }

    public static class_2960 getTagIcon(char c) {
        if (TagsManager.hasRegisteredTag(CUSTOM_MODEL_IDS_TAGS, c)) {
            return MyTotemDoll.id("textures/gui/tags/unknown.png");
        }
        return MyTotemDoll.id("textures/gui/tags/%s.png".formatted(Character.valueOf(c)));
    }

    public static class_2561 getTagDescription(Character character) {
        return MyTotemDoll.text("tags.%s".formatted(character), new Object[0]);
    }

    public static class_2561 getAppliedTagDescription(char c) {
        return MyTotemDoll.text("tags.%s.applied".formatted(Character.valueOf(c)), new Object[0]);
    }

    public static boolean hasAnyTag(String tags) {
        return TagsManager.getRegisteredTags(tags).findFirst().isPresent();
    }

    public static <E extends Tag> boolean hasRegisteredTag(Char2ObjectMap<E> registeredTags, char c) {
        return registeredTags.containsKey(c);
    }
}

