/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.yacl.custom.renderer;

import dev.isxander.yacl3.gui.image.ImageRenderer;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.config.totem.TotemDollSkinType;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.manager.StandardTotemDollManager;
import net.lopymine.mtd.doll.renderer.TotemDollRenderer;
import net.lopymine.mtd.extension.DrawContextExtension;
import net.lopymine.mtd.gui.BackgroundRenderer;
import net.lopymine.mtd.utils.ColorUtils;
import net.lopymine.mtd.utils.DrawUtils;
import net.lopymine.mtd.utils.plugin.TotemDollPlugin;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5489;
import org.jetbrains.annotations.Nullable;

public class TotemDollPreviewRenderer
implements ImageRenderer {
    private static final int STANDARD_SUGGESTION_TEXT_COLOR = ColorUtils.getArgb(255, 79, 64);
    private static final int HOLDING_PLAYER_COLOR = ColorUtils.getArgb(212, 120, 28);
    private TotemDollData data = StandardTotemDollManager.getStandardDoll();
    @Nullable
    private class_5489 suggestionText;
    @Nullable
    private TotemDollSkinType suggestionSkinType;
    private int lastRenderWidth;

    public int render(class_332 context, int x, int y, int renderWidth, float tickDelta) {
        int offset = 5;
        int width = renderWidth - offset * 2;
        this.renderDollStatus(context, x + offset, y + offset, width);
        this.updateSuggestion(width, this.lastRenderWidth != renderWidth);
        this.lastRenderWidth = renderWidth;
        int i = this.renderSuggestionText(context, x + offset, y + offset + 30 + 10, width);
        return this.renderDoll(context, x + offset, i, width) + offset - y;
    }

    private void updateSuggestion(int width, boolean resized) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        MyTotemDollConfig config = MyTotemDollConfig.getInstance();
        TotemDollSkinType skinType = config.getStandardTotemDollSkinType();
        String skinValue = config.getStandardTotemDollSkinValue();
        TotemDollSkinType type = this.suggestionSkinType;
        if (skinType.isNeedData() && skinValue.isEmpty() && skinType != TotemDollSkinType.STEVE || skinType == TotemDollSkinType.HOLDING_PLAYER) {
            this.suggestionSkinType = skinType;
        } else {
            this.suggestionSkinType = null;
            this.suggestionText = null;
        }
        if (this.suggestionSkinType != null && (type != this.suggestionSkinType || resized)) {
            this.suggestionText = class_5489.method_30890((class_327)textRenderer, (class_2561)this.suggestionSkinType.getSuggestionText(), (int)(width - 5));
        }
    }

    private int renderSuggestionText(class_332 context, int x, int y, int width) {
        int suggestionColor = this.getSuggestionColors();
        if (this.suggestionText == null) {
            return y;
        }
        DrawContextExtension.push(context);
        DrawContextExtension.translate(context, 0.0f, 0.0f, 10.0f);
        int i = this.suggestionText.method_73212(context, class_5489.class_11735.field_62009, x + 5, y + 5, 10, false, suggestionColor);
        DrawContextExtension.translate(context, 0.0f, 0.0f, -5.0f);
        BackgroundRenderer.drawTransparencyWidgetBackground(context, x, y, width, i - y + 5, true, suggestionColor);
        DrawContextExtension.pop(context);
        return i + 5 + 10;
    }

    private int getSuggestionColors() {
        if (this.suggestionSkinType == TotemDollSkinType.HOLDING_PLAYER) {
            return HOLDING_PLAYER_COLOR;
        }
        return STANDARD_SUGGESTION_TEXT_COLOR;
    }

    private void renderDollStatus(class_332 context, int x, int y, int width) {
        BackgroundRenderer.drawTransparencyWidgetBackground(context, x, y, width, 30, true, true);
        DrawUtils.drawCenteredText(context, (class_2561)MyTotemDoll.text("text.status", new Object[0]).method_10852(this.data.getStandardSprites().getState().getText()), x + 2, y + 15, width - 2);
    }

    private int renderDoll(class_332 context, int x, int y, int size) {
        MyTotemDollConfig config = MyTotemDollConfig.getInstance();
        BackgroundRenderer.drawTransparencyWidgetBackground(context, x, y, size, size, true, true);
        TotemDollRenderer.renderPreview(context, x, y, size, size, (float)size / 1.5f, config.isUseVanillaTotemModel() || TotemDollPlugin.isGoodStick(config.getStandardTotemDollSkinValue()) ? null : this.data.refreshAndApplyRenderProperties());
        return y + size + 2;
    }

    public void close() {
    }

    public void updateDoll() {
        this.data = StandardTotemDollManager.initializeStandardDollData();
    }

    public void updateDollState(boolean recreateModel) {
        this.data = StandardTotemDollManager.updateDoll(recreateModel);
    }
}

