/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wildfire.api.WildfireAPI;
import com.wildfire.api.impl.BreastArmorTexture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public interface IBreastArmorTexture {
    public static final IBreastArmorTexture DEFAULT = new IBreastArmorTexture(){};
    public static final Vector2ic DEFAULT_TEXTURE_SIZE = new Vector2i(64, 32);
    public static final Vector2ic DEFAULT_DIMENSIONS = new Vector2i(4, 5);
    public static final Vector2ic DEFAULT_LEFT_UV = new Vector2i(16, 17);
    public static final Vector2ic DEFAULT_RIGHT_UV = DEFAULT_LEFT_UV.add(DEFAULT_DIMENSIONS.x(), 0, new Vector2i());
    @ApiStatus.Internal
    public static final Codec<IBreastArmorTexture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WildfireAPI.VECTOR_2I_CODEC.optionalFieldOf("texture_size", (Object)DEFAULT_TEXTURE_SIZE).forGetter(IBreastArmorTexture::textureSize), (App)WildfireAPI.VECTOR_2I_CODEC.optionalFieldOf("left_uv", (Object)DEFAULT_LEFT_UV).forGetter(IBreastArmorTexture::leftUv), (App)WildfireAPI.VECTOR_2I_CODEC.optionalFieldOf("right_uv", (Object)new Vector2i(-1, -1)).forGetter(IBreastArmorTexture::rightUv), (App)WildfireAPI.VECTOR_2I_CODEC.optionalFieldOf("dimensions", (Object)DEFAULT_DIMENSIONS).forGetter(IBreastArmorTexture::dimensions)).apply((Applicative)instance, (size, leftUv, rightUv, dimensions) -> {
        Vector2ic right = rightUv;
        if (right.x() == -1 && right.y() == -1) {
            right = leftUv.add(dimensions.x(), 0, new Vector2i());
        }
        return new BreastArmorTexture((Vector2ic)size, (Vector2ic)leftUv, right, (Vector2ic)dimensions);
    }));

    @NotNull
    default public Vector2ic textureSize() {
        return DEFAULT_TEXTURE_SIZE;
    }

    @NotNull
    default public Vector2ic dimensions() {
        return DEFAULT_DIMENSIONS;
    }

    @NotNull
    default public Vector2ic leftUv() {
        return DEFAULT_LEFT_UV;
    }

    @NotNull
    default public Vector2ic rightUv() {
        return DEFAULT_RIGHT_UV;
    }
}

