/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wildfire.api.IGenderArmor;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireGenderClient;
import com.wildfire.main.config.Configuration;
import com.wildfire.main.config.enums.Gender;
import com.wildfire.main.entitydata.PlayerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public final class WildfireAPI {
    private static final Map<class_1792, IGenderArmor> GENDER_ARMORS = new HashMap<class_1792, IGenderArmor>();
    private static final Codec<Vector2ic> VEC2I_LEGACY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(Vector2ic::x), (App)Codec.INT.fieldOf("y").forGetter(Vector2ic::y)).apply((Applicative)instance, Vector2i::new));
    static final Codec<Vector2ic> VECTOR_2I_CODEC = Codec.withAlternative((Codec)Codec.INT_STREAM.comapFlatMap(stream -> class_156.method_29190((IntStream)stream, (int)2).map(Vector2i::new), vec2i -> IntStream.of(vec2i.x(), vec2i.y())), VEC2I_LEGACY_CODEC);

    @Deprecated(since="4.3.5", forRemoval=true)
    public static void addGenderArmor(class_1792 item, IGenderArmor genderArmor) {
        GENDER_ARMORS.put(item, genderArmor);
    }

    @Nullable
    public static PlayerConfig getPlayerById(UUID uuid) {
        return WildfireGender.getPlayerById(uuid);
    }

    @NotNull
    public static Gender getPlayerGender(UUID uuid) {
        PlayerConfig cfg = WildfireGender.getPlayerById(uuid);
        if (cfg == null) {
            return (Gender)((Object)Configuration.GENDER.getDefault());
        }
        return cfg.getGender();
    }

    @Deprecated(since="4.3.3", forRemoval=true)
    @Environment(value=EnvType.CLIENT)
    public static CompletableFuture<@Nullable PlayerConfig> loadGenderInfo(UUID uuid, boolean markForSync) {
        return WildfireGenderClient.loadGenderInfo(uuid, markForSync, false);
    }

    @Deprecated(since="4.3.5", forRemoval=true)
    public static Map<class_1792, IGenderArmor> getGenderArmors() {
        return GENDER_ARMORS;
    }
}

