/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.wildfire.gui.GuiUtils;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11876;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WildfireButton
extends class_4185 {
    @Nullable
    private final ButtonRenderer renderer;
    private final Supplier<class_2561> messageSupplier;
    public boolean transparent = false;

    private WildfireButton(int x, int y, int w, int h, Supplier<class_2561> text, class_4185.class_4241 onPress, class_4185.class_7841 narrationSupplier, @Nullable ButtonRenderer renderer) {
        super(x, y, w, h, text.get(), onPress, narrationSupplier);
        this.messageSupplier = text;
        this.renderer = renderer;
    }

    public void updateMessage() {
        this.method_25355(this.messageSupplier.get());
    }

    protected void drawInner(class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        if (this.renderer != null) {
            this.renderer.render(this, ctx, mouseX, mouseY, partialTicks);
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        int textColor = this.field_22763 ? 0xFFFFFF : 0x666666;
        int i = this.method_46426() + 2;
        int j = this.method_46426() + this.method_25368() - 2;
        GuiUtils.drawScrollableTextWithoutShadow(GuiUtils.Justify.CENTER, ctx, font, this.method_25369(), i, this.method_46427(), j, this.method_46427() + this.method_25364(), textColor);
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        int clr = 0x54444444;
        if (this.method_25367()) {
            clr = 0x54666666;
        }
        if (!this.field_22763) {
            clr = 0x54222222;
        }
        if (!this.transparent) {
            ctx.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), clr);
        }
        this.drawInner(ctx, mouseX, mouseY, partialTicks);
        if (this.method_49606()) {
            ctx.method_74037(this.field_22763 ? class_11876.field_62455 : class_11876.field_62459);
        }
    }

    public WildfireButton setTransparent(boolean b) {
        this.transparent = b;
        return this;
    }

    public WildfireButton setActive(boolean b) {
        this.field_22763 = b;
        return this;
    }

    static /* synthetic */ class_4185.class_7841 access$000() {
        return field_40754;
    }

    @FunctionalInterface
    public static interface ButtonRenderer {
        public void render(WildfireButton var1, class_332 var2, int var3, int var4, float var5);
    }

    @FunctionalInterface
    public static interface PressAction
    extends class_4185.class_4241 {
        default public void onPress(class_4185 button) {
            this.onPress((WildfireButton)button);
        }

        public void onPress(WildfireButton var1);
    }

    public static final class Builder {
        private Supplier<class_2561> messageSupplier;
        private int x;
        private int y;
        private int width;
        private int height;
        private PressAction onPress;
        private class_4185.class_7841 narrationSupplier = WildfireButton.access$000();
        private class_7919 tooltip = null;
        private ButtonRenderer renderer = null;
        private boolean active = true;

        public Builder message(@NotNull Supplier<class_2561> messageSupplier) {
            this.messageSupplier = messageSupplier;
            return this;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder onPress(@NotNull PressAction onPress) {
            this.onPress = onPress;
            return this;
        }

        public Builder narration(@NotNull class_4185.class_7841 narrationSupplier) {
            this.narrationSupplier = narrationSupplier;
            return this;
        }

        public Builder tooltip(@Nullable class_7919 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder renderer(@Nullable ButtonRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public WildfireButton build() {
            WildfireButton built = new WildfireButton(this.x, this.y, this.width, this.height, this.messageSupplier, this.onPress, this.narrationSupplier, this.renderer);
            built.setActive(this.active);
            if (this.tooltip != null) {
                built.method_47400(this.tooltip);
            }
            return built;
        }
    }
}

