/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui;

import com.wildfire.gui.GuiUtils;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.config.types.FloatConfigKey;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.FloatConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WildfireSlider
extends class_339 {
    private double value;
    private final double minValue;
    private final double maxValue;
    private final FloatConsumer valueUpdate;
    private final Float2ObjectFunction<class_2561> messageUpdate;
    private final FloatConsumer onSave;
    private float lastValue;
    private boolean changed;
    private boolean dragging;
    private double mouseStep = 0.0;
    private double arrowKeyStep = 0.05;

    private WildfireSlider(int xPos, int yPos, int width, int height, double minVal, double maxVal, double currentVal, FloatConsumer valueUpdate, Float2ObjectFunction<class_2561> messageUpdate, FloatConsumer onSave) {
        super(xPos, yPos, width, height, (class_2561)class_2561.method_43473());
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.valueUpdate = valueUpdate;
        this.messageUpdate = messageUpdate;
        this.onSave = onSave;
        this.setValueInternal(currentVal);
    }

    public void setArrowKeyStep(double arrowKeyStep) {
        this.arrowKeyStep = arrowKeyStep;
    }

    private void setMouseStep(double mouseStep) {
        this.mouseStep = mouseStep;
    }

    protected void updateMessage() {
        this.method_25355((class_2561)this.messageUpdate.get(this.lastValue));
    }

    protected void applyValue() {
        float newValue = this.getFloatValue();
        if (this.lastValue != newValue) {
            this.valueUpdate.accept(newValue);
            this.lastValue = newValue;
            this.changed = true;
        }
    }

    public void save() {
        if (this.changed) {
            this.onSave.accept(this.lastValue);
            this.changed = false;
        }
    }

    public void method_25357(class_11909 event) {
        this.dragging = false;
        this.save();
    }

    public void method_25348(class_11909 event, boolean doubleClick) {
        this.dragging = true;
        this.setValueFromMouse(event.comp_4798());
    }

    public boolean method_25404(class_11908 event) {
        int keyCode = event.comp_4795();
        if (keyCode == 263 || keyCode == 262) {
            this.value += keyCode == 263 ? -this.arrowKeyStep : this.arrowKeyStep;
            this.value = WildfireHelper.snapToStep(class_3532.method_15350((double)this.value, (double)0.0, (double)1.0), this.arrowKeyStep);
            this.applyValue();
            this.updateMessage();
            return true;
        }
        return super.method_25404(event);
    }

    protected void method_25349(class_11909 event, double d, double e) {
        this.setValueFromMouse(event.comp_4798());
    }

    public boolean method_16803(class_11908 event) {
        int keyCode = event.comp_4795();
        if (keyCode == 263 || keyCode == 262) {
            this.save();
            return true;
        }
        return super.method_16803(event);
    }

    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        int textColor;
        if (!this.field_22764) {
            return;
        }
        int xP = this.method_46426() + 2;
        ctx.method_25294(xP - 2, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -2145246686);
        int xPos = this.method_46426() + 2 + (int)(this.value * (double)(this.field_22758 - 3));
        ctx.method_25294(this.method_46426() + 1, this.method_46427() + 1, xPos - 1, this.method_46427() + this.field_22759 - 1, this.field_22763 ? -1272831386 : -1273949901);
        if (this.field_22763) {
            int xPos2 = this.method_46426() + 3 + (int)(this.value * (double)(this.field_22758 - 4));
            ctx.method_25294(xPos2 - 2, this.method_46427() + 1, xPos2, this.method_46427() + this.field_22759 - 1, 0x78FFFFFF);
        }
        class_327 font = class_310.method_1551().field_1772;
        int i = this.method_46426() + 2;
        int j = this.method_46426() + this.method_25368() - 2;
        int n = textColor = this.method_25367() && this.field_22763 || this.changed ? 0xFFFF55 : 0xFFFFFF;
        if (!this.field_22763) {
            textColor = 0x666666;
        }
        GuiUtils.drawScrollableTextWithoutShadow(GuiUtils.Justify.CENTER, ctx, font, this.method_25369(), i, this.method_46427(), j, this.method_46427() + this.method_25364(), textColor);
        if (this.method_49606() || this.dragging) {
            if (!this.field_22763) {
                ctx.method_74037(class_11876.field_62459);
            } else {
                ctx.method_74037(this.dragging ? class_11876.field_62457 : class_11876.field_62455);
            }
        }
    }

    public float getFloatValue() {
        return (float)this.getValue();
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double value) {
        this.setValueInternal(value);
        this.applyValue();
    }

    private void setValueInternal(double value) {
        this.value = class_3532.method_15350((double)((value - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
        this.lastValue = (float)value;
        this.updateMessage();
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(mouseX);
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()}));
        if (this.field_22763) {
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
            } else {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
            }
        }
    }

    private void setValueFromMouse(double mouseX) {
        this.value = (mouseX - (double)(this.method_46426() + 4)) / (double)(this.method_25368() - 8);
        this.value = class_3532.method_15350((double)this.value, (double)0.0, (double)1.0);
        if (this.mouseStep > 0.0) {
            double snapped = (double)Math.round(this.value / this.mouseStep) * this.mouseStep;
            this.value = class_3532.method_15350((double)snapped, (double)0.0, (double)1.0);
        }
        this.applyValue();
        this.updateMessage();
    }

    public static final class Builder {
        private int x;
        private int y;
        private int width;
        private int height;
        private float min;
        private float max;
        private double value;
        private Double step = null;
        private Double mouseStep = null;
        private boolean active = true;
        private Float2ObjectFunction<class_2561> messageSupplier;
        private FloatConsumer onUpdate;
        private FloatConsumer onSave;

        public Builder message(@NotNull Float2ObjectFunction<class_2561> messageSupplier) {
            this.messageSupplier = messageSupplier;
            return this;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder update(@NotNull FloatConsumer onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        public Builder save(@NotNull FloatConsumer onSave) {
            this.onSave = onSave;
            return this;
        }

        public Builder range(@NotNull FloatConfigKey key) {
            return this.range(key.getMinInclusive(), key.getMaxInclusive());
        }

        public Builder range(float min, float max) {
            this.min = min;
            this.max = max;
            return this;
        }

        public Builder current(double value) {
            this.value = value;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder step(double step) {
            this.step = step;
            return this;
        }

        public Builder mouseStep(double step) {
            this.mouseStep = step;
            return this;
        }

        public WildfireSlider build() {
            WildfireSlider built = new WildfireSlider(this.x, this.y, this.width, this.height, this.min, this.max, this.value, this.onUpdate, this.messageSupplier, this.onSave);
            built.field_22763 = this.active;
            if (this.step != null) {
                built.setArrowKeyStep(this.step);
            }
            if (this.mouseStep != null) {
                built.setMouseStep(this.mouseStep);
            }
            return built;
        }
    }
}

