/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.wildfire.gui.GuiUtils;
import com.wildfire.gui.SyncedPlayerList;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.gui.screen.WildfireBreastCustomizationScreen;
import com.wildfire.gui.screen.WildfireCloudSyncScreen;
import com.wildfire.gui.screen.WildfireCreditsScreen;
import com.wildfire.gui.screen.WildfireFirstTimeSetupScreen;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.cloud.SyncUnavailable;
import com.wildfire.main.config.ClientConfig;
import com.wildfire.main.config.enums.Gender;
import com.wildfire.main.config.enums.ShowPlayerListMode;
import com.wildfire.main.contributors.Contributors;
import com.wildfire.main.entitydata.PlayerConfig;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import net.minecraft.class_8030;
import net.minecraft.class_9110;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class WardrobeBrowserScreen
extends BaseWildfireScreen {
    private static final class_2960 BACKGROUND_MALE = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/wardrobe_bg_male.png");
    private static final class_2960 BACKGROUND_FEMALE = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/wardrobe_bg_female.png");
    private static final class_2960 BACKGROUND_OTHER = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/wardrobe_bg_other.png");
    private static final class_2960 TXTR_RIBBON = class_2960.method_60655((String)"wildfire_gender", (String)"textures/bc_ribbon.png");
    private static final class_2960 CLOUD_ICON = class_2960.method_60655((String)"wildfire_gender", (String)"textures/cloud.png");
    private static final boolean isBreastCancerAwarenessMonth = Calendar.getInstance().get(2) == 9;
    private final class_9110 contribTooltip = new class_9110();

    public WardrobeBrowserScreen(class_437 parent, UUID uuid) {
        super((class_2561)class_2561.method_43471((String)"wildfire_gender.wardrobe.title"), parent, uuid);
    }

    public static BaseWildfireScreen create(class_746 player, @Nullable class_437 parent) {
        if (ClientConfig.INSTANCE.get(ClientConfig.FIRST_TIME_LOAD).booleanValue() && CloudSync.isAvailable()) {
            return new WildfireFirstTimeSetupScreen(parent, player.method_5667());
        }
        return new WardrobeBrowserScreen(parent, player.method_5667());
    }

    public static void open(class_310 client, class_746 player) {
        client.method_1507((class_437)WardrobeBrowserScreen.create(player, null));
    }

    public void method_25426() {
        class_310 client = Objects.requireNonNull(this.field_22787, "client");
        int y = this.field_22790 / 2;
        PlayerConfig plr = Objects.requireNonNull(this.getPlayer(), "getPlayer()");
        this.addButton(builder -> builder.message(() -> class_2561.method_43469((String)"wildfire_gender.always_show_list", (Object[])new Object[]{ClientConfig.INSTANCE.get(ClientConfig.ALWAYS_SHOW_LIST).text()})).tooltip(ClientConfig.INSTANCE.get(ClientConfig.ALWAYS_SHOW_LIST).tooltip()).position(126, 4).size(185, 10).onPress(button -> {
            ClientConfig config = ClientConfig.INSTANCE;
            ShowPlayerListMode newVal = config.get(ClientConfig.ALWAYS_SHOW_LIST).next();
            config.set(ClientConfig.ALWAYS_SHOW_LIST, newVal);
            config.save();
            button.updateMessage();
            button.method_47400(newVal.tooltip());
        }));
        this.addButton(builder -> builder.message(() -> plr.getGender().getDisplayName()).position(this.field_22789 / 2 - 130, this.field_22790 / 2 + 33).size(80, 15).onPress(button -> {
            plr.updateGender(plr.getGender().next());
            plr.save();
            this.method_41843();
        }));
        this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.appearance_settings.title").method_27693("...")).position(this.field_22789 / 2 - 36, this.field_22790 / 2 - 63).size(157, 20).onPress(button -> client.method_1507((class_437)new WildfireBreastCustomizationScreen(this, this.playerUUID))).active(plr.getGender().canHaveBreasts()));
        this.addButton(builder -> {
            builder.message(() -> class_2561.method_43471((String)"wildfire_gender.cloud_settings"));
            builder.position(this.field_22789 / 2 - 36, y + 30);
            builder.size(24, 18);
            builder.renderer((button, ctx, mouseX, mouseY, partialTicks) -> ctx.method_25302(class_10799.field_56883, CLOUD_ICON, button.method_46426() + 2, button.method_46427() + 2, 0.0f, 0.0f, 20, 14, 32, 26, 32, 26));
            builder.onPress(button -> client.method_1507((class_437)new WildfireCloudSyncScreen(this, this.playerUUID)));
            SyncUnavailable cloudUnavailable = CloudSync.unavailableReason();
            if (cloudUnavailable != null) {
                builder.tooltip(class_7919.method_47407((class_2561)cloudUnavailable.text()));
                builder.active(false);
            } else {
                builder.tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.tooltip")));
            }
        });
        this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.credits.title").method_27693("...")).position(this.field_22789 / 2 + 2, this.field_22790 / 2 + 33).size(78, 15).onPress(button -> client.method_1507((class_437)new WildfireCreditsScreen(this, this.playerUUID))));
    }

    public void method_25420(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_52752(ctx);
        PlayerConfig plr = this.getPlayer();
        if (plr == null) {
            return;
        }
        class_2960 backgroundTexture = switch (plr.getGender()) {
            default -> throw new MatchException(null, null);
            case Gender.MALE -> BACKGROUND_MALE;
            case Gender.FEMALE -> BACKGROUND_FEMALE;
            case Gender.OTHER -> BACKGROUND_OTHER;
        };
        ctx.method_25290(class_10799.field_56883, backgroundTexture, (this.field_22789 - 272) / 2, (this.field_22790 - 138) / 2, 0.0f, 0.0f, 268, 124, 512, 512);
        this.renderPlayerInFrame(ctx, this.field_22789 / 2 - 90, this.field_22790 / 2 + 18, mouseX, mouseY);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        ctx.method_51439(this.field_22793, this.method_25440(), x - this.field_22793.method_27525((class_5348)this.method_25440()) / 2, y - 82, 0xFFFFFF, false);
        this.drawCreatorContributorText(ctx, mouseX, mouseY, y + 65 + (isBreastCancerAwarenessMonth ? 30 : 0));
        if (isBreastCancerAwarenessMonth) {
            int bcaY = y - 45;
            ctx.method_25294(x - 159, bcaY + 106, x + 159, bcaY + 136, 0x55000000);
            ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.cancer_awareness.title").method_27695(new class_124[]{class_124.field_1067, class_124.field_1056}), this.field_22789 / 2 - 148, bcaY + 117, -1);
            ctx.method_25302(class_10799.field_56883, TXTR_RIBBON, x + 130, bcaY + 109, 0.0f, 0.0f, 26, 26, 20, 20, 20, 20);
        }
        SyncedPlayerList.drawSyncedPlayers(ctx, this.field_22793);
    }

    private void drawCreatorContributorText(class_332 ctx, int mouseX, int mouseY, int creatorY) {
        class_5250 text;
        class_310 client = Objects.requireNonNull(this.field_22787);
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        Map entries = client.field_1724.field_3944.method_2880().stream().collect(Collectors.toMap(entry -> entry.method_2966().id(), Function.identity()));
        boolean withCreator = entries.containsKey(Contributors.CREATOR_UUID);
        List<class_640> foundContributors = Contributors.getContributorUUIDs().stream().filter(it -> !it.equals(Contributors.CREATOR_UUID)).map(entries::get).filter(Objects::nonNull).toList();
        if (!withCreator && foundContributors.isEmpty()) {
            return;
        }
        ArrayList<class_640> toList = new ArrayList<class_640>(foundContributors);
        if (withCreator && !foundContributors.isEmpty()) {
            text = class_2561.method_43471((String)"wildfire_gender.label.with_both");
            toList.addFirst((class_640)entries.get(Contributors.CREATOR_UUID));
        } else {
            text = withCreator ? class_2561.method_43471((String)"wildfire_gender.label.with_creator") : class_2561.method_43471((String)"wildfire_gender.label.with_contributor");
        }
        int textWidth = this.field_22793.method_27525((class_5348)text);
        GuiUtils.drawCenteredTextWrapped(ctx, this.field_22793, (class_5348)text, this.field_22789 / 2, creatorY, 300, class_9848.method_61334((int)0xFF00FF));
        int lines = (int)Math.ceil((double)textWidth / 300.0);
        if (!toList.isEmpty() && mouseX > this.field_22789 / 2 - textWidth / 2 && mouseX < this.field_22789 / 2 + textWidth / 2 && mouseY > creatorY - 2 && mouseY < creatorY + 9 * lines) {
            List<class_5250> contributorNames = toList.stream().filter(Objects::nonNull).map(entry -> class_268.method_1142((class_270)entry.method_2955(), (class_2561)class_2561.method_30163((String)entry.method_2966().name()))).toList();
            this.contribTooltip.method_56138(class_7919.method_47407((class_2561)class_2564.method_37112(contributorNames, (class_2561)class_2561.method_43470((String)"\n"))));
            this.contribTooltip.method_56142(ctx, mouseX, mouseY, true, true, class_8030.method_48248());
        }
    }
}

