/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.wildfire.gui.GuiUtils;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireLocalization;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.cloud.SyncLog;
import com.wildfire.main.cloud.SyncingTooFrequentlyException;
import com.wildfire.main.config.ClientConfig;
import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class WildfireCloudSyncScreen
extends BaseWildfireScreen {
    private static final class_2960 BACKGROUND = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/sync_bg_v2.png");

    protected WildfireCloudSyncScreen(class_437 parent, UUID uuid) {
        super((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud_settings"), parent, uuid);
    }

    public void method_25426() {
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        int yPos = y - 47;
        int xPos = x - 78 - 1;
        ClientConfig config = ClientConfig.INSTANCE;
        var ref = new Object(this){
            WildfireButton btnSyncNow;
            WildfireButton btnDelete;
            WildfireButton btnAutomaticSync;
        };
        this.addButton(builder -> builder.message(() -> class_2561.method_43469((String)"wildfire_gender.cloud.status", (Object[])new Object[]{CloudSync.isEnabled() ? WildfireLocalization.ENABLED : WildfireLocalization.DISABLED})).position(xPos, yPos).size(157, 20).onPress(button -> {
            boolean enabled = config.toggle(ClientConfig.CLOUD_SYNC_ENABLED);
            boolean available = CloudSync.isAvailable();
            button.updateMessage();
            ref.btnAutomaticSync.setActive(enabled);
            ref.btnSyncNow.field_22764 = enabled && available;
            ref.btnDelete.field_22764 = !enabled && available;
            ref.btnAutomaticSync.updateMessage();
        }));
        ref.btnAutomaticSync = this.addButton(builder -> builder.message(() -> {
            Object[] objectArray = new Object[1];
            objectArray[0] = CloudSync.isEnabled() ? (ClientConfig.INSTANCE.get(ClientConfig.AUTOMATIC_CLOUD_SYNC).booleanValue() ? WildfireLocalization.ENABLED : WildfireLocalization.DISABLED) : WildfireLocalization.OFF;
            return class_2561.method_43469((String)"wildfire_gender.cloud.automatic", (Object[])objectArray);
        }).position(xPos, yPos + 20).size(157, 20).onPress(button -> {
            boolean newVal = config.get(ClientConfig.AUTOMATIC_CLOUD_SYNC) == false;
            config.set(ClientConfig.AUTOMATIC_CLOUD_SYNC, newVal);
            button.updateMessage();
        }).tooltip(class_7919.method_47407((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.automatic.tooltip.line1")).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.automatic.tooltip.line2")))).active(CloudSync.isEnabled()));
        ref.btnSyncNow = this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.cloud.sync")).position(xPos + 98, yPos + 42).size(60, 15).onPress(this::sync));
        ref.btnSyncNow.field_22764 = CloudSync.isEnabled();
        (ref.btnDelete = this.addButton((Consumer<WildfireButton.Builder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$init$9(int int com.wildfire.gui.WildfireButton$Builder ), (Lcom/wildfire/gui/WildfireButton$Builder;)V)((WildfireCloudSyncScreen)this, (int)xPos, (int)yPos))).field_22764 = !CloudSync.isEnabled();
        this.addButton(builder -> builder.message(() -> class_2561.method_43470((String)"X")).position(this.field_22789 / 2 + 73, yPos - 11).size(9, 9).onPress(button -> this.method_25419()).narration(text -> GuiUtils.doneNarrationText()));
    }

    private void sync(class_4185 button) {
        button.field_22763 = false;
        button.method_25355((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.syncing"));
        CompletableFuture.runAsync(() -> {
            try {
                CloudSync.sync(Objects.requireNonNull(this.getPlayer())).join();
                button.method_25355((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.syncing.success"));
            }
            catch (Exception e) {
                Exception actualException;
                if (e instanceof CompletionException) {
                    CompletionException ce = (CompletionException)e;
                    v0 = ce.getCause();
                } else {
                    v0 = actualException = e;
                }
                if (actualException instanceof SyncingTooFrequentlyException) {
                    WildfireGender.LOGGER.warn("Failed to sync settings as we've already synced too recently");
                    SyncLog.add(WildfireLocalization.SYNC_LOG_SYNC_TOO_FREQUENTLY);
                } else {
                    WildfireGender.LOGGER.error("Failed to sync settings", (Throwable)actualException);
                }
                button.method_25355((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.syncing.fail"));
            }
        });
    }

    private void delete(class_4185 widget) {
        widget.field_22763 = false;
        CompletableFuture.runAsync(() -> {
            try {
                CloudSync.deleteProfile(Objects.requireNonNull(this.getPlayer())).join();
                widget.method_25355((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.deleted"));
            }
            catch (Exception e) {
                WildfireGender.LOGGER.error("Failed to delete cloud sync profile", (Throwable)e);
                widget.method_25355((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.delete_failed"));
            }
        });
    }

    public void method_25420(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_52752(ctx);
        ctx.method_25290(class_10799.field_56883, BACKGROUND, (this.field_22789 - 172) / 2, (this.field_22790 - 124) / 2, 0.0f, 0.0f, 172, 144, 256, 256);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            return;
        }
        super.method_25394(ctx, mouseX, mouseY, delta);
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        GuiUtils.drawScrollableTextWithoutShadow(GuiUtils.Justify.LEFT, ctx, this.field_22793, this.method_25440(), x - 79, (y -= 47) - 12, x - 79 + 141, y - 11 + 10, 0x444444);
        GuiUtils.drawScrollableTextWithoutShadow(GuiUtils.Justify.LEFT, ctx, this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.cloud.status_log"), x - 79, y + 47, x - 79 + 95, y + 48 + 10, 0x444444);
        for (int i = SyncLog.SYNC_LOG.size() - 1; i >= 0; --i) {
            int reverseIndex = SyncLog.SYNC_LOG.size() - 1 - i;
            SyncLog.Entry entry = SyncLog.SYNC_LOG.get(i);
            if (reverseIndex >= 6) continue;
            int ey = y + 110 - reverseIndex * 10;
            GuiUtils.drawScrollableTextWithoutShadow(GuiUtils.Justify.LEFT, ctx, this.field_22793, entry.text(), x - 78, ey, x - 78 + 156, ey + 10, entry.color());
        }
    }

    @Override
    public void method_25419() {
        ClientConfig.INSTANCE.save();
        super.method_25419();
    }

    private /* synthetic */ void lambda$init$9(int xPos, int yPos, WildfireButton.Builder builder) {
        builder.message(() -> class_2561.method_43471((String)"wildfire_gender.cloud.delete").method_27692(class_124.field_1061)).position(xPos + 98, yPos + 42).size(60, 15).onPress(this::delete);
    }
}

