/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.wildfire.gui.FakeGUIPlayer;
import com.wildfire.gui.GuiUtils;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.main.GenderConfigs;
import com.wildfire.main.contributors.Contributor;
import com.wildfire.main.contributors.Contributors;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;
import org.joml.Vector2fc;

@Environment(value=EnvType.CLIENT)
public class WildfireCreditsScreen
extends BaseWildfireScreen {
    private static final class_2960 CREDIT_CONTAINER = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/credits/credit_container.png");
    private static final class_2960 CREDIT_OUTLINE = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/credits/credit_outline.png");
    private static final class_2960 BUTTON_CONTAINER = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/credits/button_container.png");
    private static final class_2960 TAB_CONTAINER = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/credits/tab_container.png");
    private final FakeGUIPlayer[] C_GENERAL = (FakeGUIPlayer[])Contributors.getContributors().entrySet().stream().filter(it -> ((Contributor)it.getValue()).name() != null).filter(it -> Boolean.TRUE.equals(((Contributor)it.getValue()).showInCredits())).filter(it -> ((Contributor)it.getValue()).getRole() != Contributor.Role.TRANSLATOR).sorted(Comparator.comparing(it -> ((Contributor)it.getValue()).name())).sorted(Comparator.comparing(it -> ((Contributor)it.getValue()).getRole())).map(it -> new FakeGUIPlayer(((Contributor)it.getValue()).name(), (UUID)it.getKey(), GenderConfigs.DEFAULT_FEMALE)).toArray(FakeGUIPlayer[]::new);
    private final FakeGUIPlayer[] C_TRANSLATORS = (FakeGUIPlayer[])Contributors.getContributors().entrySet().stream().filter(it -> ((Contributor)it.getValue()).name() != null).filter(it -> Boolean.TRUE.equals(((Contributor)it.getValue()).showInCredits())).filter(it -> ((Contributor)it.getValue()).getRole() == Contributor.Role.TRANSLATOR).sorted(Comparator.comparing(it -> ((Contributor)it.getValue()).name())).sorted(Comparator.comparing(it -> ((Contributor)it.getValue()).getRole())).map(it -> new FakeGUIPlayer(((Contributor)it.getValue()).name(), (UUID)it.getKey(), GenderConfigs.DEFAULT_FEMALE)).toArray(FakeGUIPlayer[]::new);
    private final int boxesPerPage = 12;
    private Category categoryTab = Category.GENERAL;
    private int creditsPage = 0;
    private int navigationY;

    public WildfireCreditsScreen(class_437 parent, UUID uuid) {
        super((class_2561)class_2561.method_43471((String)"wildfire_gender.credits.title"), parent, uuid);
    }

    public void method_25426() {
        var ref = new Object(this){
            class_339 prevPage;
            class_339 nextPage;
            class_339 generalTab;
            class_339 translatorTab;
        };
        this.navigationY = this.field_22790 / 2 + 82;
        ref.generalTab = this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.credits.general")).position(this.field_22789 / 2 - 89, this.navigationY + 34).size(87, 13).active(this.categoryTab == Category.TRANSLATORS).onPress(button -> {
            this.categoryTab = Category.GENERAL;
            this.creditsPage = 0;
            ref.prevPage.field_22763 = false;
            ref.nextPage.field_22763 = this.creditsPage < this.getTotalPages() - 1;
            ref.generalTab.field_22763 = false;
            ref.translatorTab.field_22763 = true;
        }));
        ref.translatorTab = this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.credits.translators")).position(this.field_22789 / 2 + 2, this.navigationY + 34).size(87, 13).active(this.categoryTab == Category.GENERAL).onPress(button -> {
            this.categoryTab = Category.TRANSLATORS;
            this.creditsPage = 0;
            ref.prevPage.field_22763 = false;
            ref.nextPage.field_22763 = this.creditsPage < this.getTotalPages() - 1;
            ref.generalTab.field_22763 = true;
            ref.translatorTab.field_22763 = false;
        }));
        this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.details.go_back")).position(this.field_22789 / 2 - 25, this.navigationY + 6).size(50, 13).onPress(button -> this.method_25419()));
        ref.nextPage = this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.details.next_page")).position(this.field_22789 / 2 + 29, this.navigationY + 6).size(60, 13).active(this.creditsPage < this.getTotalPages() - 1).onPress(button -> {
            if (this.creditsPage < this.getTotalPages() - 1) {
                ++this.creditsPage;
            }
            ref.prevPage.field_22763 = this.creditsPage != 0;
            ref.nextPage.field_22763 = this.creditsPage < this.getTotalPages() - 1;
        }));
        ref.prevPage = this.addButton(builder -> builder.message(() -> class_2561.method_43471((String)"wildfire_gender.details.prev_page")).position(this.field_22789 / 2 - 89, this.navigationY + 6).size(60, 13).active(this.creditsPage != 0).onPress(button -> {
            if (this.creditsPage > 0) {
                --this.creditsPage;
            }
            ref.prevPage.field_22763 = this.creditsPage != 0;
            ref.nextPage.field_22763 = this.creditsPage < this.getTotalPages();
        }));
    }

    public void method_25393() {
        for (FakeGUIPlayer player : this.getActiveBoxes()) {
            player.tick();
        }
    }

    private int getTotalPages() {
        return (int)Math.ceil((double)this.getActiveBoxes().length / 12.0);
    }

    private FakeGUIPlayer[] getActiveBoxes() {
        return this.categoryTab == Category.TRANSLATORS ? this.C_TRANSLATORS : this.C_GENERAL;
    }

    public void method_25420(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_52752(ctx);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        Matrix3x2fStack mStack = ctx.method_51448();
        mStack.pushMatrix();
        GuiUtils.drawCenteredText(ctx, this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.credits.title"), this.field_22789 / 2, this.field_22790 / 2 - 100, class_9848.method_61334((int)0xFFFFFF));
        GuiUtils.drawCenteredText(ctx, this.field_22793, (class_2561)class_2561.method_43471((String)"wildfire_gender.credits.description"), this.field_22789 / 2, this.field_22790 / 2 - 85, class_9848.method_61334((int)0x888888));
        mStack.popMatrix();
        ctx.method_25290(class_10799.field_56883, BUTTON_CONTAINER, this.field_22789 / 2 - 95, this.navigationY, 0.0f, 0.0f, 190, 25, 190, 25);
        ctx.method_25290(class_10799.field_56883, TAB_CONTAINER, this.field_22789 / 2 - 95, this.navigationY + 28, 0.0f, 0.0f, 190, 25, 190, 25);
        int columns = 6;
        int boxW = 60;
        int boxH = 74;
        int startIndex = this.creditsPage * 12;
        int endIndex = Math.min(startIndex + 12, this.getActiveBoxes().length);
        int startY = this.field_22790 / 2 - 2 * boxH / 2 + 4;
        for (int i = startIndex; i < endIndex; ++i) {
            FakeGUIPlayer creditBox = this.getActiveBoxes()[i];
            int localIndex = i - startIndex;
            int col = localIndex % columns;
            int row = localIndex / columns;
            int remaining = Math.min(endIndex - startIndex - row * columns, columns);
            int rowWidth = remaining * boxW;
            int startX = this.field_22789 / 2 - rowWidth / 2 + 4;
            int creditBoxX = startX + col * boxW;
            int creditBoxY = startY + row * boxH;
            ctx.method_25290(class_10799.field_56883, CREDIT_CONTAINER, creditBoxX, creditBoxY, 0.0f, 0.0f, 52, 68, 52, 68);
            ctx.method_51448().pushMatrix();
            ctx.method_25291(class_10799.field_56883, CREDIT_OUTLINE, creditBoxX + 3, creditBoxY + 3, 0.0f, 0.0f, 46, 53, 46, 53, class_9848.method_61334((int)creditBox.getRole().getColor()));
            ctx.method_51448().popMatrix();
            int xP = creditBoxX + 26;
            int yP = creditBoxY + 34;
            ctx.method_44379(xP - 21, yP - 79, xP + 21, yP + 20);
            GuiUtils.drawEntityOnScreenNoScissor(ctx, xP - 38, yP - 29, xP + 38, yP + 59, 40, mouseX, mouseY + 35, (class_1309)creditBox.getEntity());
            ctx.method_44380();
            mStack.pushMatrix();
            mStack.translate((float)xP, (float)(yP + 47));
            mStack.scale((Vector2fc)new Vector2f(0.55f, 0.55f));
            mStack.translate((float)(-xP), (float)(-yP - 47));
            GuiUtils.drawCenteredTextWrapped(ctx, this.field_22793, (class_5348)class_2561.method_43470((String)creditBox.getName()), xP, yP + 7, 72, class_9848.method_61334((int)0xFFFFFF));
            mStack.popMatrix();
            if (mouseX <= xP - 24 || mouseX >= xP + 23 || mouseY <= yP + 22 || mouseY >= yP + 31) continue;
            ArrayList<class_5250> txtList = new ArrayList<class_5250>();
            Contributor.Role role = creditBox.getRoleOrGeneric();
            txtList.add(role.withColor(class_2561.method_43473().method_27693(creditBox.getName()).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063)).method_10852((class_2561)role.shortName())));
            if (creditBox.getDescription() != null && !creditBox.getDescription().isEmpty()) {
                txtList.add(class_2561.method_43470((String)creditBox.getDescription()).method_27692(class_124.field_1080));
            }
            ctx.method_51434(this.field_22793, txtList, mouseX, mouseY);
        }
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    private static enum Category {
        GENERAL,
        TRANSLATORS;

    }
}

