/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.gui.screen;

import com.google.common.base.Suppliers;
import com.wildfire.gui.FakeGUIPlayer;
import com.wildfire.gui.GuiUtils;
import com.wildfire.gui.WildfireButton;
import com.wildfire.gui.screen.BaseWildfireScreen;
import com.wildfire.gui.screen.WardrobeBrowserScreen;
import com.wildfire.main.GenderConfigs;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireGenderClient;
import com.wildfire.main.config.ClientConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11903;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;
import org.joml.Vector2fc;

@Environment(value=EnvType.CLIENT)
public class WildfireFirstTimeSetupScreen
extends BaseWildfireScreen {
    private static final class_2561 TITLE = class_2561.method_43471((String)"wildfire_gender.first_time_setup.title").method_27692(class_124.field_1073);
    private static final class_2561 DESCRIPTION = class_2561.method_43471((String)"wildfire_gender.first_time_setup.description");
    private static final class_2561 NOTICE = class_2561.method_43471((String)"wildfire_gender.first_time_setup.notice");
    private static final class_2561 ENABLE_CLOUD_SYNCING = class_2561.method_43471((String)"wildfire_gender.first_time_setup.enable").method_27692(class_124.field_1060);
    private static final class_2561 DISABLE_CLOUD_SYNCING = class_2561.method_43471((String)"wildfire_gender.first_time_setup.disable").method_27692(class_124.field_1061);
    private static final class_2960 BACKGROUND = class_2960.method_60655((String)"wildfire_gender", (String)"textures/gui/first_time_bg.png");
    private static final UUID keiraUUID = UUID.fromString("372271ab-28f2-44bd-b585-95f43e010c22");
    private final Supplier<FakeGUIPlayer> fakeKeira = Suppliers.memoize(() -> new FakeGUIPlayer("KeiaraFGM", keiraUUID, GenderConfigs.DEFAULT_FEMALE));

    public WildfireFirstTimeSetupScreen(class_437 parent, UUID uuid) {
        super((class_2561)class_2561.method_43471((String)"wildfire_gender.cloud_settings"), parent, uuid);
    }

    public void method_25426() {
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        ClientConfig config = ClientConfig.INSTANCE;
        var ref = new Object(this){
            WildfireButton no = null;
        };
        this.addButton(builder -> builder.message(() -> ENABLE_CLOUD_SYNCING).position(x + 3, y + 74).size(128, 20).onPress(button -> {
            config.set(ClientConfig.CLOUD_SYNC_ENABLED, true);
            config.set(ClientConfig.AUTOMATIC_CLOUD_SYNC, true);
            config.set(ClientConfig.FIRST_TIME_LOAD, false);
            button.field_22763 = false;
            button.method_25355((class_2561)class_2561.method_43470((String)"..."));
            ref.no.setActive(false);
            WardrobeBrowserScreen nextScreen = new WardrobeBrowserScreen(null, this.playerUUID);
            this.doInitialSync().thenRun(() -> this.field_22787.execute(() -> this.field_22787.method_1507((class_437)nextScreen)));
        }).tooltip(class_7919.method_47407((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"wildfire_gender.first_time_setup.enable.tooltip.line1")).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"wildfire_gender.first_time_setup.enable.tooltip.line2")))));
        ref.no = this.addButton(builder -> builder.message(() -> DISABLE_CLOUD_SYNCING).position(x - 131, y + 74).size(128, 20).onPress(button -> {
            config.set(ClientConfig.CLOUD_SYNC_ENABLED, false);
            config.set(ClientConfig.AUTOMATIC_CLOUD_SYNC, false);
            config.set(ClientConfig.FIRST_TIME_LOAD, false);
            this.field_22787.method_1507((class_437)new WardrobeBrowserScreen(null, this.playerUUID));
        }));
    }

    private CompletableFuture<Void> doInitialSync() {
        class_310 client = Objects.requireNonNull(this.field_22787);
        UUID clientUUID = client.field_1724.method_5667();
        WildfireGender.CACHE.asMap().values().removeIf(config -> config.syncStatus == PlayerConfig.SyncStatus.UNKNOWN);
        return CompletableFuture.runAsync(() -> {
            PlayerConfig clientConfig = WildfireGender.getOrAddPlayerById(clientUUID);
            if (!clientConfig.hasLocalConfig()) {
                try {
                    WildfireGenderClient.loadGenderInfo(clientUUID, false, true).join();
                }
                catch (CompletionException ignored) {
                    return;
                }
                catch (Exception e) {
                    WildfireGender.LOGGER.error("Failed to perform initial sync from the cloud", (Throwable)e);
                    return;
                }
                clientConfig.save();
                clientConfig.needsCloudSync = false;
            } else {
                clientConfig.needsCloudSync = true;
            }
        });
    }

    public void method_25420(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.method_52752(ctx);
        ctx.method_25290(class_10799.field_56883, BACKGROUND, (this.field_22789 - 274) / 2, (this.field_22790 - 200) / 2, 0.0f, 0.0f, 274, 200, 512, 512);
    }

    public void method_25393() {
        this.fakeKeira.get().tick();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            return;
        }
        super.method_25394(ctx, mouseX, mouseY, delta);
        Matrix3x2fStack mStack = ctx.method_51448();
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        GuiUtils.drawCenteredText(ctx, this.field_22793, TITLE, x, y - 24, class_9848.method_61334((int)0x404040));
        GuiUtils.drawCenteredTextWrapped(ctx, this.field_22793, (class_5348)class_2561.method_43470((String)"Keira Emberlyn:").method_27692(class_124.field_1076), x + 32, y - 10, 191, class_9848.method_61334((int)0xFFFFFF));
        GuiUtils.drawCenteredTextWrapped(ctx, this.field_22793, (class_5348)DESCRIPTION, x + 32, y + 2, 191, class_9848.method_61334((int)0xFFFFFF));
        mStack.pushMatrix();
        mStack.translate((float)x, (float)(y + 47));
        mStack.scale((Vector2fc)new Vector2f(0.8f, 0.8f));
        mStack.translate((float)(-x), (float)(-y - 47));
        GuiUtils.drawCenteredTextWrapped(ctx, this.field_22793, (class_5348)NOTICE, x, y + 68, 295, class_9848.method_61334((int)0x404040));
        mStack.popMatrix();
        class_11903 fakeKeira = this.fakeKeira.get().getEntity();
        GuiUtils.drawEntityOnScreenNoScissor(ctx, 0.0f, 0.4f, x - 132, y - 13, x - 75, y + 60, 50, mouseX, mouseY, (class_1309)fakeKeira);
    }

    public void method_25432() {
        ClientConfig.INSTANCE.save();
    }
}

