/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.logging.LogUtils;
import com.wildfire.main.WildfireEventHandler;
import com.wildfire.main.WildfireGenderClient;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.config.ClientConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.networking.WildfireSync;
import java.time.Duration;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WildfireGender
implements ModInitializer {
    public static final String MODID = "wildfire_gender";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final LoadingCache<UUID, PlayerConfig> CACHE;

    public void onInitialize() {
        WildfireSync.register();
        WildfireEventHandler.registerCommonEvents();
        ClientConfig.INSTANCE.load();
    }

    @Nullable
    public static PlayerConfig getPlayerById(UUID id) {
        return (PlayerConfig)CACHE.getIfPresent((Object)id);
    }

    @NotNull
    public static PlayerConfig getOrAddPlayerById(UUID id) {
        return (PlayerConfig)CACHE.getUnchecked((Object)id);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MODID, (String)path);
    }

    static {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (WildfireHelper.onClient()) {
            builder.expireAfterAccess(Duration.ofMinutes(15L));
        }
        CACHE = builder.build((CacheLoader)new CacheLoader<UUID, PlayerConfig>(){

            @NotNull
            public PlayerConfig load(@NotNull UUID key) {
                PlayerConfig config = new PlayerConfig(key);
                if (WildfireHelper.onClient() && key.version() == 4) {
                    WildfireGenderClient.loadGenderInfo(config, true, false);
                }
                return config;
            }
        });
    }
}

