/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.cloud;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.util.InstantTypeAdapter;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.WildfireLocalization;
import com.wildfire.main.cloud.BulkFetch;
import com.wildfire.main.cloud.CloudAuth;
import com.wildfire.main.cloud.CloudUtils;
import com.wildfire.main.cloud.QueuedFetch;
import com.wildfire.main.cloud.SyncLog;
import com.wildfire.main.cloud.SyncUnavailable;
import com.wildfire.main.cloud.SyncingTooFrequentlyException;
import com.wildfire.main.config.ClientConfig;
import com.wildfire.main.config.enums.SyncVerbosity;
import com.wildfire.main.contributors.Contributor;
import com.wildfire.main.entitydata.PlayerConfig;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_634;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class CloudSync {
    private static Instant lastSync = Instant.EPOCH;
    private static final List<Instant> fetchErrors = new ArrayList<Instant>();
    @Nullable
    private static Instant disableFetchingUntil;
    private static CloudAuth auth;
    private static final Object AUTH_LOCK;
    private static final Object SYNC_LOCK;
    private static final Executor EXECUTOR;
    private static final Gson GSON;
    private static final HttpClient CLIENT;
    private static final String USER_AGENT;
    private static final Queue<QueuedFetch> QUEUED;
    private static final Cache<UUID, Optional<JsonObject>> FETCH_CACHE;
    private static final String DEFAULT_CLOUD_URL = "https://wfgm.celestialfault.dev";
    private static final Duration SYNC_COOLDOWN;

    private CloudSync() {
        throw new UnsupportedOperationException();
    }

    public static boolean syncOnCooldown() {
        return lastSync.plus(SYNC_COOLDOWN).isAfter(Instant.now());
    }

    @Nullable
    public static SyncUnavailable unavailableReason() {
        UUID sessionUuid = class_310.method_1551().method_1548().method_44717();
        if (sessionUuid == null || sessionUuid.version() != 4) {
            return SyncUnavailable.INVALID_ACCOUNT;
        }
        if (CloudUtils.hasTheSessionServiceBeenTamperedWith()) {
            return SyncUnavailable.INVALID_ACCOUNT;
        }
        class_310 client = class_310.method_1551();
        class_634 netHandler = client.method_1562();
        if (!client.method_1542() && netHandler != null && !netHandler.method_48296().method_10771()) {
            return SyncUnavailable.OFFLINE_SERVER;
        }
        return null;
    }

    public static boolean isAvailable() {
        return CloudSync.unavailableReason() == null;
    }

    public static boolean isEnabled() {
        return CloudSync.isAvailable() && ClientConfig.INSTANCE.get(ClientConfig.CLOUD_SYNC_ENABLED) != false;
    }

    public static String getCloudServer() {
        String url = ClientConfig.INSTANCE.get(ClientConfig.CLOUD_SERVER);
        return url.isBlank() ? DEFAULT_CLOUD_URL : url;
    }

    private static void markFetchError() {
        fetchErrors.add(Instant.now());
        fetchErrors.removeIf(e -> e.plus(30L, ChronoUnit.SECONDS).isBefore(Instant.now()));
        if (fetchErrors.size() >= 5) {
            WildfireGender.LOGGER.error("Too many recent sync errors, disabling future lookups for 5 minutes");
            disableFetchingUntil = Instant.now().plus(5L, ChronoUnit.MINUTES);
        }
    }

    private static boolean isFetchingDisabled(boolean ignoreConfig) {
        if (!CloudSync.isAvailable()) {
            return true;
        }
        if (!ignoreConfig && !CloudSync.isEnabled()) {
            return true;
        }
        return disableFetchingUntil != null && disableFetchingUntil.isAfter(Instant.now());
    }

    private static HttpRequest.Builder createRequest(URI uri) {
        WildfireGender.LOGGER.debug("Connecting to {}", (Object)uri);
        return HttpRequest.newBuilder(uri).header("User-Agent", USER_AGENT).header("Accept", "application/json").timeout(Duration.ofSeconds(5L));
    }

    @ApiStatus.Internal
    public static CompletableFuture<Map<UUID, Contributor>> getContributors() {
        return CompletableFuture.supplyAsync(() -> {
            HttpResponse<String> response;
            HttpRequest request = CloudSync.createRequest(URI.create(CloudSync.getCloudServer() + "/contributors")).GET().build();
            try {
                response = CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
                if (response.statusCode() != 200) {
                    WildfireGender.LOGGER.warn("Couldn't fetch contributor list: server responded {}", (Object)response.statusCode());
                    return Map.of();
                }
            }
            catch (Exception e) {
                WildfireGender.LOGGER.warn("Couldn't fetch contributor list", (Throwable)e);
                return Map.of();
            }
            try {
                JsonObject json = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
                Map<UUID, Contributor> interim = json.asMap().entrySet().stream().collect(Collectors.toMap(entry -> UUID.fromString((String)entry.getKey()), entry -> (Contributor)GSON.fromJson((JsonElement)entry.getValue(), Contributor.class)));
                return Collections.unmodifiableMap(interim.size() <= 8 ? new Object2ObjectArrayMap(interim) : new Object2ObjectOpenHashMap(interim));
            }
            catch (Exception e) {
                WildfireGender.LOGGER.error("Failed to parse contributor list", (Throwable)e);
                return Map.of();
            }
        }, EXECUTOR);
    }

    private static String generateServerId() {
        BigInteger intA = new BigInteger(128, new Random());
        BigInteger intB = new BigInteger(128, new Random(System.identityHashCode(new Object())));
        return intA.xor(intB).toString(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    private static String getAuthToken() {
        Object object = AUTH_LOCK;
        synchronized (object) {
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) {
                SyncLog.add(WildfireLocalization.SYNC_LOG_AUTHENTICATION_FAILED);
                throw new IllegalStateException("Cannot get a new auth token while the client player is unset");
            }
            if (auth == null || auth.isExpired() || auth.isInvalidForClientPlayer()) {
                WildfireGender.LOGGER.info("Authenticating with Mojang session servers");
                SyncLog.add(WildfireLocalization.SYNC_LOG_AUTHENTICATING_MOJANG);
                String serverId = CloudSync.generateServerId();
                class_320 session = client.method_1548();
                try {
                    CloudUtils.getSessionService().joinServer(Objects.requireNonNull(session.method_44717()), session.method_1674(), serverId);
                }
                catch (AuthenticationException e) {
                    SyncLog.add(WildfireLocalization.SYNC_LOG_AUTHENTICATION_FAILED);
                    throw new RuntimeException(e);
                }
                WildfireGender.LOGGER.info("Obtaining new authentication token from the cloud sync server");
                SyncLog.add(WildfireLocalization.SYNC_LOG_AUTHENTICATING_CLOUD_SYNC);
                String query = HttpAuthenticationService.buildQuery(Map.of("serverId", serverId, "username", session.method_1676()));
                URI uri = URI.create(CloudSync.getCloudServer() + "/auth?" + query);
                HttpRequest request = CloudSync.createRequest(uri).GET().build();
                HttpResponse<String> response = CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
                if (response.statusCode() >= 400) {
                    SyncLog.add(WildfireLocalization.SYNC_LOG_AUTHENTICATION_FAILED);
                    throw new RuntimeException("Failed to authenticate with sync server: " + response.body());
                }
                auth = (CloudAuth)GSON.fromJson(response.body(), CloudAuth.class);
                if (auth.isInvalidForClientPlayer()) {
                    WildfireGender.LOGGER.warn("Authenticated account {} does not match the current player ({}); you likely have a misbehaving account switcher mod installed!", (Object)auth.account(), (Object)client.field_1724.method_5667());
                }
                WildfireGender.LOGGER.info("Obtained authentication token for {}, expiry {}", (Object)auth.account(), (Object)auth.expires());
            }
        }
        return auth.token();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletableFuture<Void> sync(@NotNull PlayerConfig config) {
        if (!CloudSync.isEnabled()) {
            return CompletableFuture.completedFuture(null);
        }
        Object object = SYNC_LOCK;
        synchronized (object) {
            if (CloudSync.syncOnCooldown()) {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                future.completeExceptionally(new SyncingTooFrequentlyException());
                return future;
            }
            lastSync = Instant.now();
        }
        return CloudSync.syncInternal(config, false);
    }

    private static CompletableFuture<Void> syncInternal(PlayerConfig config, boolean resyncing) {
        return CompletableFuture.runAsync(() -> {
            String token = CloudSync.getAuthToken();
            URI url = URI.create(CloudSync.getCloudServer() + "/" + String.valueOf(config.uuid));
            String json = config.toJson().toString();
            SyncLog.add(WildfireLocalization.SYNC_LOG_ATTEMPTING_SYNC);
            HttpRequest request = CloudSync.createRequest(url).PUT(HttpRequest.BodyPublishers.ofString(json)).header("Content-Type", "application/json; charset=UTF-8").header("Auth-Token", token).build();
            HttpResponse<String> response = CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
            if (response.statusCode() == 401 && !resyncing) {
                SyncLog.add(WildfireLocalization.SYNC_LOG_REAUTHENTICATING);
                WildfireGender.LOGGER.warn("Auth token is invalid, attempting to reauth...");
                auth = null;
                CloudSync.syncInternal(config, true).join();
                return;
            }
            if (response.statusCode() >= 400) {
                throw new RuntimeException("Server responded " + response.statusCode() + ": " + response.body());
            }
            WildfireGender.LOGGER.debug("Server responded to update: {}", (Object)response.body());
            SyncLog.add(WildfireLocalization.SYNC_LOG_SYNC_SUCCESS);
        }, EXECUTOR);
    }

    public static CompletableFuture<Void> deleteProfile(PlayerConfig config) {
        return CompletableFuture.runAsync(() -> {
            String token = CloudSync.getAuthToken();
            URI url = URI.create(CloudSync.getCloudServer() + "/" + String.valueOf(config.uuid));
            HttpRequest request = CloudSync.createRequest(url).DELETE().header("Auth-Token", token).build();
            HttpResponse<String> response = CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
            if (response.statusCode() == 404) {
                SyncLog.add(WildfireLocalization.SYNC_LOG_NO_PROFILE_TO_DELETE);
                return;
            }
            if (response.statusCode() >= 400) {
                SyncLog.add(WildfireLocalization.SYNC_LOG_DELETION_FAILED);
                throw new RuntimeException("Server responded " + response.statusCode() + ": " + response.body());
            }
            WildfireGender.LOGGER.debug("Deleted cloud sync profile");
            SyncLog.add(WildfireLocalization.SYNC_LOG_DELETED);
        }, EXECUTOR);
    }

    public static CompletableFuture<@Nullable JsonObject> getProfile(UUID uuid) {
        return CloudSync.getProfile(uuid, false);
    }

    public static CompletableFuture<@Nullable JsonObject> getProfile(UUID uuid, boolean ignoreConfig) {
        if (CloudSync.isFetchingDisabled(ignoreConfig)) {
            return CompletableFuture.completedFuture(null);
        }
        if (uuid.version() != 4) {
            return CompletableFuture.completedFuture(null);
        }
        Optional cached = (Optional)FETCH_CACHE.getIfPresent((Object)uuid);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached.orElse(null));
        }
        return CompletableFuture.supplyAsync(() -> {
            URI url = URI.create(CloudSync.getCloudServer() + "/" + String.valueOf(uuid));
            HttpRequest request = CloudSync.createRequest(url).GET().build();
            HttpResponse<String> response = CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
            if (response.statusCode() == 404 || response.statusCode() == 204) {
                WildfireGender.LOGGER.debug("Server replied no data for {}", (Object)uuid);
                FETCH_CACHE.put((Object)uuid, Optional.empty());
                return null;
            }
            if (response.statusCode() >= 400) {
                CloudSync.markFetchError();
                throw new RuntimeException("Server responded " + response.statusCode() + ": " + response.body());
            }
            SyncLog.add(WildfireLocalization.SYNC_LOG_GET_SINGLE_PROFILE, SyncVerbosity.SHOW_FETCHES);
            JsonObject data = (JsonObject)GSON.fromJson(response.body(), JsonObject.class);
            FETCH_CACHE.put((Object)uuid, Optional.of(data));
            return data;
        }, EXECUTOR);
    }

    public static CompletableFuture<Map<UUID, JsonObject>> getMultiple(Collection<UUID> uuids) {
        return CompletableFuture.supplyAsync(() -> {
            if (CloudSync.isFetchingDisabled(false)) {
                return Collections.emptyMap();
            }
            URI url = URI.create(CloudSync.getCloudServer() + "/");
            JsonArray json = new JsonArray();
            uuids.forEach(uuid -> json.add(uuid.toString()));
            HttpRequest request = CloudSync.createRequest(url).POST(HttpRequest.BodyPublishers.ofString(json.toString())).header("Content-Type", "application/json; charset=UTF-8").build();
            HttpResponse<String> response = CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
            if (response.statusCode() >= 400) {
                CloudSync.markFetchError();
                throw new RuntimeException("Server responded " + response.statusCode() + ": " + response.body());
            }
            SyncLog.add(WildfireLocalization.SYNC_LOG_GET_MULTIPLE_PROFILES, SyncVerbosity.SHOW_FETCHES);
            Map<UUID, JsonObject> data = ((BulkFetch)GSON.fromJson(response.body(), BulkFetch.class)).users();
            uuids.forEach(uuid -> FETCH_CACHE.put(uuid, Optional.ofNullable((JsonObject)data.get(uuid))));
            return data;
        }, EXECUTOR);
    }

    public static CompletableFuture<@Nullable JsonObject> queueFetch(UUID uuid) {
        if (!CloudSync.isEnabled()) {
            return CompletableFuture.completedFuture(null);
        }
        Optional cached = (Optional)FETCH_CACHE.getIfPresent((Object)uuid);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached.orElse(null));
        }
        if (uuid.version() != 4) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<JsonObject> future = new CompletableFuture<JsonObject>();
        QUEUED.add(new QueuedFetch(uuid, future));
        return future;
    }

    @ApiStatus.Internal
    public static void sendNextQueueBatch() {
        QueuedFetch next;
        if (QUEUED.isEmpty()) {
            return;
        }
        ArrayList<QueuedFetch> toFetch = new ArrayList<QueuedFetch>();
        for (int i = 0; i < 20 && (next = QUEUED.poll()) != null; ++i) {
            toFetch.add(next);
        }
        if (toFetch.size() < 4) {
            WildfireGender.LOGGER.debug("Sending {} queued sync queries", (Object)toFetch.size());
            toFetch.forEach(queued -> CompletableFuture.runAsync(() -> {
                try {
                    queued.future().complete(CloudSync.getProfile(queued.uuid()).join());
                }
                catch (Exception e) {
                    Throwable throwable;
                    if (e instanceof CompletionException) {
                        CompletionException ce = (CompletionException)e;
                        throwable = ce.getCause();
                    } else {
                        throwable = e;
                    }
                    Exception actualException = throwable;
                    queued.future().completeExceptionally(actualException);
                }
            }));
            return;
        }
        WildfireGender.LOGGER.debug("Fetching sync data for {} players in bulk", (Object)toFetch.size());
        CompletableFuture.runAsync(() -> {
            Map<UUID, JsonObject> result;
            try {
                result = CloudSync.getMultiple(toFetch.stream().map(QueuedFetch::uuid).toList()).join();
            }
            catch (Exception e) {
                Throwable throwable;
                if (e instanceof CompletionException) {
                    CompletionException ce = (CompletionException)e;
                    throwable = ce.getCause();
                } else {
                    throwable = e;
                }
                Exception actualException = throwable;
                toFetch.forEach(queued -> queued.future().completeExceptionally(actualException));
                return;
            }
            toFetch.forEach(queued -> queued.future().complete((JsonObject)result.get(queued.uuid())));
        });
    }

    static {
        AUTH_LOCK = new Object();
        SYNC_LOCK = new Object();
        EXECUTOR = class_156.method_27958().method_64116("wildfire_gender$cloudSync");
        GSON = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantTypeAdapter()).create();
        CLIENT = (HttpClient)class_156.method_656(() -> {
            HttpClient.Builder builder = HttpClient.newBuilder();
            if (FabricLoader.getInstance().isDevelopmentEnvironment() && CloudSync.getCloudServer().startsWith("http://")) {
                builder.version(HttpClient.Version.HTTP_1_1);
            }
            builder.connectTimeout(Duration.ofSeconds(5L)).followRedirects(HttpClient.Redirect.NORMAL);
            return builder.build();
        });
        USER_AGENT = "WildfireGender/" + StringUtils.split((String)WildfireHelper.getModVersion("wildfire_gender"), (char)'+')[0] + " Minecraft/" + WildfireHelper.getModVersion("minecraft");
        QUEUED = new ConcurrentLinkedDeque<QueuedFetch>();
        FETCH_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).concurrencyLevel(6).build();
        SYNC_COOLDOWN = Duration.ofSeconds(10L);
    }
}

