/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.cloud;

import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.wildfire.main.WildfireGender;
import com.wildfire.mixins.accessors.YggdrasilMinecraftSessionServiceAccessor;
import java.util.Objects;
import net.minecraft.class_310;

public final class CloudUtils {
    private static final String EXPECTED_YGGDRASIL_BASE_URL = "https://sessionserver.mojang.com/session/minecraft/";

    private CloudUtils() {
        throw new UnsupportedOperationException();
    }

    static MinecraftSessionService getSessionService() {
        return class_310.method_1551().method_73361().comp_837();
    }

    static boolean hasTheSessionServiceBeenTamperedWith() {
        MinecraftSessionService sessionService = CloudUtils.getSessionService();
        if (sessionService.getClass() != YggdrasilMinecraftSessionService.class) {
            WildfireGender.LOGGER.info("Detected likely session service tampering; got {} instead of the expected Yggdrasil session service", (Object)sessionService.getClass());
            return true;
        }
        YggdrasilMinecraftSessionServiceAccessor accessor = (YggdrasilMinecraftSessionServiceAccessor)sessionService;
        if (!Objects.equals(accessor.getBaseUrl(), EXPECTED_YGGDRASIL_BASE_URL)) {
            WildfireGender.LOGGER.info("Detected likely session service tampering; Yggdrasil base URL is not the expected Mojang-provided value");
            return true;
        }
        return false;
    }
}

