/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.config.types.BooleanConfigKey;
import com.wildfire.main.config.types.ConfigKey;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfiguration {
    private static final TypeAdapter<JsonObject> ADAPTER = new Gson().getAdapter(JsonObject.class);
    private final File cfgFile;
    private final JsonObject saveValues = new JsonObject();

    protected AbstractConfiguration(String directory, String cfgName) {
        Path saveDir = FabricLoader.getInstance().getConfigDir().resolve(directory);
        if (AbstractConfiguration.supportsSaving() && !Files.isDirectory(saveDir, new LinkOption[0])) {
            try {
                Files.createDirectory(saveDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                WildfireGender.LOGGER.error("Failed to create config directory", (Throwable)e);
            }
        }
        this.cfgFile = saveDir.resolve(cfgName + ".json").toFile();
    }

    public static boolean supportsSaving() {
        return FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER;
    }

    public <TYPE> void set(ConfigKey<TYPE> key, TYPE value) {
        key.save(this.saveValues, value);
    }

    public <TYPE> TYPE get(ConfigKey<TYPE> key) {
        return key.read(this.saveValues);
    }

    public boolean toggle(BooleanConfigKey key) {
        boolean newValue = this.get(key) == false;
        this.set(key, newValue);
        return newValue;
    }

    @ApiStatus.Internal
    @Nullable
    public JsonElement get(String key) {
        return this.saveValues.get(key);
    }

    @ApiStatus.Internal
    public void set(String key, JsonElement element) {
        this.saveValues.add(key, element);
    }

    public <TYPE> void setDefault(ConfigKey<TYPE> key) {
        if (!this.saveValues.has(key.getKey())) {
            this.set(key, key.getDefault());
        }
    }

    public void removeParameter(ConfigKey<?> key) {
        this.removeParameter(key.getKey());
    }

    public void removeParameter(String key) {
        this.saveValues.remove(key);
    }

    public boolean exists() {
        return this.cfgFile.exists();
    }

    public void save() {
        if (!AbstractConfiguration.supportsSaving()) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.cfgFile);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            jsonWriter.setIndent("\t");
            ADAPTER.write(jsonWriter, (Object)this.saveValues);
        }
        catch (IOException e) {
            WildfireGender.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public void load() {
        if (!AbstractConfiguration.supportsSaving() || !this.cfgFile.exists()) {
            return;
        }
        try (FileReader configurationFile = new FileReader(this.cfgFile);){
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)configurationFile, JsonObject.class);
            for (Map.Entry entry : obj.entrySet()) {
                this.saveValues.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        catch (IOException e) {
            WildfireGender.LOGGER.error("Failed to load config file", (Throwable)e);
        }
    }

    public void migrateConfiguration(String oldDir, String oldName) {
        if (!AbstractConfiguration.supportsSaving()) {
            return;
        }
        File oldFile = FabricLoader.getInstance().getConfigDir().resolve(oldDir).resolve(oldName + ".json").toFile();
        File newFile = this.cfgFile.getParentFile().toPath().resolve(this.cfgFile.getName()).toFile();
        if (oldFile.exists() && !newFile.exists()) {
            try {
                Files.copy(oldFile.toPath(), newFile.toPath(), new CopyOption[0]);
                WildfireGender.LOGGER.info("Migrated config file from '{}' to '{}'", (Object)oldFile, (Object)newFile);
                if (oldFile.delete()) {
                    WildfireGender.LOGGER.info("Deleted old config file after migration.");
                }
            }
            catch (IOException e) {
                WildfireGender.LOGGER.error("Failed to migrate config file", (Throwable)e);
            }
        }
    }
}

