/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.JsonObject;
import com.wildfire.main.config.AbstractConfiguration;
import com.wildfire.main.config.enums.Gender;
import com.wildfire.main.config.functions.BreastGetter;
import com.wildfire.main.config.functions.BreastSetter;
import com.wildfire.main.config.functions.PlayerGetter;
import com.wildfire.main.config.functions.PlayerSetter;
import com.wildfire.main.config.types.BooleanConfigKey;
import com.wildfire.main.config.types.ConfigKey;
import com.wildfire.main.config.types.EnumConfigKey;
import com.wildfire.main.config.types.FloatConfigKey;
import com.wildfire.main.config.types.UVLayoutConfigKey;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.main.entitydata.EntityConfig;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.main.uvs.UVQuad;
import java.util.List;
import org.jetbrains.annotations.Unmodifiable;

public class Configuration
extends AbstractConfiguration {
    private static final String CONFIG_DIR = "FemaleGenderMod";
    public static final EnumConfigKey<Gender> GENDER = new EnumConfigKey<Gender>("gender", Gender.MALE, Gender.BY_ID);
    public static final FloatConfigKey BUST_SIZE = new FloatConfigKey("bust_size", 0.6f, 0.0f, 0.8f);
    public static final BooleanConfigKey HURT_SOUNDS = new BooleanConfigKey("hurt_sounds", true);
    public static final FloatConfigKey VOICE_PITCH = new FloatConfigKey("voice_pitch", 1.0f, 0.8f, 1.2f);
    public static final FloatConfigKey BREASTS_OFFSET_X = new FloatConfigKey("breasts_xOffset", 0.0f, -1.0f, 1.0f);
    public static final FloatConfigKey BREASTS_OFFSET_Y = new FloatConfigKey("breasts_yOffset", 0.0f, -1.0f, 1.0f);
    public static final FloatConfigKey BREASTS_OFFSET_Z = new FloatConfigKey("breasts_zOffset", 0.0f, -1.0f, 0.0f);
    public static final BooleanConfigKey BREASTS_UNIBOOB = new BooleanConfigKey("breasts_uniboob", true);
    public static final FloatConfigKey BREASTS_CLEAVAGE = new FloatConfigKey("breasts_cleavage", 0.0f, 0.0f, 0.1f);
    public static final BooleanConfigKey BREAST_PHYSICS = new BooleanConfigKey("breast_physics", true);
    public static final BooleanConfigKey SHOW_IN_ARMOR = new BooleanConfigKey("show_in_armor", true);
    public static final FloatConfigKey BOUNCE_MULTIPLIER = new FloatConfigKey("bounce_multiplier", 0.333f, 0.0f, 0.5f);
    public static final FloatConfigKey FLOPPY_MULTIPLIER = new FloatConfigKey("floppy_multiplier", 0.75f, 0.25f, 1.0f);
    public static final BooleanConfigKey HOLIDAY_THEMES = new BooleanConfigKey("holiday_themes", true);
    public static final ConfigKey<UVLayout> LEFT_BREAST_UV_LAYOUT = new UVLayoutConfigKey("leftBreastUVLayout", new UVLayout(new UVQuad(24, 21, 27, 26), new UVQuad(16, 21, 20, 26), new UVQuad(20, 17, 24, 21), new UVQuad(20, 25, 24, 27), new UVQuad(20, 21, 24, 26)));
    public static final ConfigKey<UVLayout> RIGHT_BREAST_UV_LAYOUT = new UVLayoutConfigKey("rightBreastUVLayout", new UVLayout(new UVQuad(28, 21, 32, 26), new UVQuad(21, 21, 24, 26), new UVQuad(24, 17, 28, 21), new UVQuad(24, 25, 28, 27), new UVQuad(24, 21, 28, 26)));
    public static final ConfigKey<UVLayout> LEFT_BREAST_OVERLAY_UV_LAYOUT = new UVLayoutConfigKey("leftBreastOverlayUVLayout", new UVLayout(new UVQuad(0, 0, 0, 0), new UVQuad(17, 37, 20, 42), new UVQuad(20, 34, 24, 37), new UVQuad(20, 42, 24, 45), new UVQuad(20, 37, 24, 42)));
    public static final ConfigKey<UVLayout> RIGHT_BREAST_OVERLAY_UV_LAYOUT = new UVLayoutConfigKey("rightBreastOverlayUVLayout", new UVLayout(new UVQuad(28, 37, 31, 42), new UVQuad(0, 0, 0, 0), new UVQuad(24, 34, 28, 37), new UVQuad(24, 42, 28, 45), new UVQuad(24, 37, 28, 42)));
    public static final ConfigKey<UVLayout> LEFT_BREAST_ARMOR_UV_LAYOUT = new UVLayoutConfigKey("leftBreastArmorUVLayout", new UVLayout(new UVQuad(24, 21, 28, 26), new UVQuad(16, 21, 20, 26), new UVQuad(20, 17, 24, 21), new UVQuad(20, 25, 24, 27), new UVQuad(20, 21, 24, 26)));
    public static final ConfigKey<UVLayout> RIGHT_BREAST_ARMOR_UV_LAYOUT = new UVLayoutConfigKey("rightBreastArmorUVLayout", new UVLayout(new UVQuad(28, 21, 32, 26), new UVQuad(20, 21, 24, 26), new UVQuad(24, 17, 28, 21), new UVQuad(24, 25, 28, 27), new UVQuad(24, 21, 28, 26)));
    public static final @Unmodifiable List<RegisteredKey<?>> KEYS = List.of(new RegisteredKey<Gender>(GENDER, EntityConfig::getGender, PlayerConfig::updateGender), new RegisteredKey<Float>(BUST_SIZE, EntityConfig::getBustSize, PlayerConfig::updateBustSize), new RegisteredKey<Boolean>(HURT_SOUNDS, PlayerConfig::hasHurtSounds, PlayerConfig::updateHurtSounds), new RegisteredKey<Float>(VOICE_PITCH, EntityConfig::getVoicePitch, PlayerConfig::updateVoicePitch), new RegisteredKey<Float>((ConfigKey<Float>)BREASTS_OFFSET_X, Breasts::getXOffset, Breasts::updateXOffset), new RegisteredKey<Float>((ConfigKey<Float>)BREASTS_OFFSET_Y, Breasts::getYOffset, Breasts::updateYOffset), new RegisteredKey<Float>((ConfigKey<Float>)BREASTS_OFFSET_Z, Breasts::getZOffset, Breasts::updateZOffset), new RegisteredKey<Boolean>((ConfigKey<Boolean>)BREASTS_UNIBOOB, Breasts::isUniboob, Breasts::updateUniboob), new RegisteredKey<Float>((ConfigKey<Float>)BREASTS_CLEAVAGE, Breasts::getCleavage, Breasts::updateCleavage), new RegisteredKey<Boolean>(BREAST_PHYSICS, EntityConfig::hasBreastPhysics, PlayerConfig::updateBreastPhysics), new RegisteredKey<Boolean>(SHOW_IN_ARMOR, PlayerConfig::showBreastsInArmor, PlayerConfig::updateShowBreastsInArmor), new RegisteredKey<Float>(BOUNCE_MULTIPLIER, EntityConfig::getBounceMultiplier, PlayerConfig::updateBounceMultiplier), new RegisteredKey<Float>(FLOPPY_MULTIPLIER, EntityConfig::getFloppiness, PlayerConfig::updateFloppiness), new RegisteredKey<Boolean>(HOLIDAY_THEMES, PlayerConfig::hasHolidayThemes, PlayerConfig::updateHolidayThemes), new RegisteredKey<UVLayout>(LEFT_BREAST_UV_LAYOUT, EntityConfig::getLeftBreastUVLayout, EntityConfig::updateLeftBreastUVLayout), new RegisteredKey<UVLayout>(RIGHT_BREAST_UV_LAYOUT, EntityConfig::getRightBreastUVLayout, EntityConfig::updateRightBreastUVLayout), new RegisteredKey<UVLayout>(LEFT_BREAST_OVERLAY_UV_LAYOUT, EntityConfig::getLeftBreastOverlayUVLayout, EntityConfig::updateLeftBreastOverlayUVLayout), new RegisteredKey<UVLayout>(RIGHT_BREAST_OVERLAY_UV_LAYOUT, EntityConfig::getRightBreastOverlayUVLayout, EntityConfig::updateRightBreastOverlayUVLayout));

    public Configuration(String cfgName) {
        super(CONFIG_DIR, cfgName);
    }

    public void setDefaults() {
        KEYS.stream().map(RegisteredKey::key).forEach(this::setDefault);
    }

    public static String getConfigFile() {
        return CONFIG_DIR;
    }

    public record RegisteredKey<T>(ConfigKey<T> key, PlayerGetter<T> getter, PlayerSetter<T> setter) {
        RegisteredKey(ConfigKey<T> key, BreastGetter<T> getter, BreastSetter<T> setter) {
            this(key, (PlayerGetter<T>)getter, (PlayerSetter<T>)setter);
        }

        public void dump(PlayerConfig config, JsonObject obj) {
            this.key.save(obj, config.getConfig().get(this.key));
        }

        public void writeToConfig(PlayerConfig player) {
            player.getConfig().set(this.key, this.getter.get(player));
        }

        public void writeToPlayer(PlayerConfig player) {
            this.setter.set(player, player.getConfig().get(this.key));
        }
    }
}

