/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.wildfire.main.config.types.ConfigKey;
import java.util.function.IntFunction;

public class EnumConfigKey<TYPE extends Enum<TYPE>>
extends ConfigKey<TYPE> {
    private final IntFunction<TYPE> ordinal;

    public EnumConfigKey(String key, TYPE defaultValue, IntFunction<TYPE> ordinalMapper) {
        super(key, defaultValue);
        this.ordinal = ordinalMapper;
    }

    @Override
    protected TYPE read(JsonElement element) {
        JsonPrimitive prim;
        if (element instanceof JsonPrimitive && (prim = (JsonPrimitive)element).isNumber()) {
            return (TYPE)((Enum)this.ordinal.apply(prim.getAsInt()));
        }
        return (TYPE)((Enum)this.defaultValue);
    }

    @Override
    public void save(JsonObject object, TYPE value) {
        object.addProperty(this.key, (Number)((Enum)value).ordinal());
    }
}

