/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.contributors;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public record Contributor(int roles, @Nullable Integer color, @Nullable String name, @SerializedName(value="show_in_credits") @Nullable Boolean showInCredits) {
    private static final int DEFAULT_COLOR = Objects.requireNonNull(class_124.field_1065.method_532());

    public int getColor() {
        if (this.color != null) {
            return this.color;
        }
        return this.getRole().getColor();
    }

    @Nullable
    public class_2561 asText() {
        return this.getRole().nametag().method_54663(this.getColor());
    }

    @NotNull
    public Role getRole() {
        if (this.roles == 0) {
            return Role.GENERIC;
        }
        for (Role role : Role.values()) {
            if (!role.isIn(this.roles)) continue;
            return role;
        }
        return Role.GENERIC;
    }

    public static enum Role {
        MOD_CREATOR(class_124.field_1076.method_532()),
        FABRIC_MAINTAINER(10981375),
        NEOFORGE_MAINTAINER(10981375),
        DEVELOPER,
        TRANSLATOR(0x66CCFF),
        MASCOT,
        VOICE_ACTOR_FEMALE,
        GENERIC;

        @Nullable
        private final Integer color;

        private Role(Integer color) {
            this.color = color;
        }

        private Role() {
            this(null);
        }

        public int bit() {
            return 1 << this.ordinal();
        }

        public boolean isIn(int bitmask) {
            return (bitmask & this.bit()) == this.bit();
        }

        public int getColor() {
            return this.color == null ? DEFAULT_COLOR : this.color;
        }

        @NotNull
        public class_5250 withColor(@NotNull class_5250 text) {
            Preconditions.checkNotNull((Object)text);
            if (this.color != null) {
                return text.method_54663(this.color.intValue());
            }
            return text;
        }

        @NotNull
        public class_5250 withColor(@NotNull class_5250 text, @NotNull class_124 defaultColor) {
            Preconditions.checkNotNull((Object)text);
            if (this.color != null) {
                return text.method_54663(this.color.intValue());
            }
            Preconditions.checkNotNull((Object)defaultColor.method_532());
            return text.method_54663(defaultColor.method_532().intValue());
        }

        @NotNull
        public class_5250 nametag() {
            return class_2561.method_43471((String)("wildfire_gender.contributor.role." + this.name().toLowerCase(Locale.ROOT)));
        }

        @NotNull
        public class_5250 shortName() {
            return class_2561.method_43471((String)("wildfire_gender.contributor.role." + this.name().toLowerCase(Locale.ROOT) + ".short"));
        }
    }
}

