/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.contributors;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.cloud.CloudSync;
import com.wildfire.main.contributors.Contributor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_8144;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Environment(value=EnvType.CLIENT)
public final class Contributors {
    @Language(value="RegExp")
    private static final String UUID_PATTERN = "(?i)[a-z0-9]{8}-[a-z0-9]{4}-4[0-9a-z]{3}-[a-z0-9]{4}-[a-z0-9]{12}";
    public static final UUID CREATOR_UUID = UUID.fromString("23b6feed-2dfe-4f2e-9429-863fd4adb946");
    private static final Map<UUID, Contributor> CONTRIBUTORS = new LinkedHashMap<UUID, Contributor>();
    private static final Supplier<CompletableFuture<Map<UUID, Contributor>>> MERGED_CONTRIBUTORS;

    private Contributors() {
        throw new UnsupportedOperationException();
    }

    public static @Unmodifiable Map<UUID, Contributor> getContributors() {
        return Collections.unmodifiableMap(MERGED_CONTRIBUTORS.get().getNow(CONTRIBUTORS));
    }

    public static @Unmodifiable Set<UUID> getContributorUUIDs() {
        return Contributors.getContributors().keySet();
    }

    @Nullable
    private static <T> T map(UUID uuid, Function<Contributor, T> mapping) {
        return (T)class_8144.method_49077((Object)Contributors.getContributors().get(uuid), mapping);
    }

    @Nullable
    public static Contributor.Role getRole(UUID uuid) {
        return Contributors.map(uuid, Contributor::getRole);
    }

    @Nullable
    public static class_2561 getNametag(UUID uuid) {
        return Contributors.map(uuid, Contributor::asText);
    }

    @Nullable
    public static Integer getColor(UUID uuid) {
        return Contributors.map(uuid, Contributor::getColor);
    }

    private static void addContributor(@Pattern(value="(?i)[a-z0-9]{8}-[a-z0-9]{4}-4[0-9a-z]{3}-[a-z0-9]{4}-[a-z0-9]{12}") @NotNull String uuid, @NotNull String name, @NotNull Contributor.Role role, boolean showInCredits) {
        UUID parsedUuid = UUID.fromString(uuid);
        Preconditions.checkArgument((!CONTRIBUTORS.containsKey(parsedUuid) ? 1 : 0) != 0, (String)"Contributor with UUID '%s' is already present", (Object)uuid);
        CONTRIBUTORS.put(parsedUuid, new Contributor(role.bit(), null, name, showInCredits));
    }

    private static void addContributor(@Pattern(value="(?i)[a-z0-9]{8}-[a-z0-9]{4}-4[0-9a-z]{3}-[a-z0-9]{4}-[a-z0-9]{12}") @NotNull String uuid, @NotNull String name, @NotNull Contributor.Role role) {
        Contributors.addContributor(uuid, name, role, true);
    }

    private static LinkedHashMap<UUID, Contributor> merge(Map<UUID, Contributor> toMerge) {
        LinkedHashMap<UUID, Contributor> merged = new LinkedHashMap<UUID, Contributor>(CONTRIBUTORS);
        for (Map.Entry<UUID, Contributor> entry : toMerge.entrySet()) {
            merged.merge(entry.getKey(), entry.getValue(), (a, b) -> a.name() != null && b.name() == null ? a : b);
        }
        return merged;
    }

    static {
        Contributors.addContributor("23b6feed-2dfe-4f2e-9429-863fd4adb946", "WildfireFGM", Contributor.Role.MOD_CREATOR);
        Contributors.addContributor("70336328-0de7-430e-8cba-2779e2a05ab5", "celeste", Contributor.Role.FABRIC_MAINTAINER);
        Contributors.addContributor("64e57307-72e5-4f43-be9c-181e8e35cc9b", "pupnewfster", Contributor.Role.NEOFORGE_MAINTAINER);
        Contributors.addContributor("9a60e979-c890-4b43-a4c0-32d8a9f6b6b9", "SavLeftUs", Contributor.Role.VOICE_ACTOR_FEMALE);
        Contributors.addContributor("618a8390-51b1-43b2-a53a-ab72c1bbd8bd", "Kichura", Contributor.Role.DEVELOPER);
        Contributors.addContributor("ad8ee68c-0aa1-47f9-b29f-f92fa1ef66dc", "DiaDemiEmi", Contributor.Role.DEVELOPER);
        Contributors.addContributor("3f36f7e9-7459-43fe-87ce-4e8a5d47da80", "IzzyBizzy45", Contributor.Role.DEVELOPER);
        Contributors.addContributor("ad3cb52d-524b-41b4-b9d6-b91ec440811d", "RacoonDog", Contributor.Role.DEVELOPER);
        Contributors.addContributor("525b0455-15e9-49b7-b61d-f291e8ee6c5b", "Powerless001", Contributor.Role.GENERIC);
        Contributors.addContributor("33feda66-c706-4725-8983-f62e5e6cbee7", "Bluelight", Contributor.Role.TRANSLATOR);
        Contributors.addContributor("8fb5e95d-7f41-4b4c-b8c5-4f15ea3fa2c1", "ArcticWah", Contributor.Role.TRANSLATOR);
        Contributors.addContributor("e31edb15-d8bd-44ac-8ec3-b54114e9d595", "PinguinLars", Contributor.Role.TRANSLATOR);
        Contributors.addContributor("242c1a3a-83ee-4aa6-a3de-568cdac082a4", "le0n_lol", Contributor.Role.TRANSLATOR);
        Contributors.addContributor("4c3e3225-aec0-499c-b563-2b17cdb017f8", "Betawolfy", Contributor.Role.TRANSLATOR);
        Contributors.addContributor("372271ab-28f2-44bd-b585-95f43e010c22", "KeiraFGM", Contributor.Role.MASCOT, false);
        MERGED_CONTRIBUTORS = Suppliers.memoize(() -> CompletableFuture.supplyAsync(() -> {
            Map<UUID, Contributor> contributors;
            try {
                contributors = CloudSync.getContributors().join();
            }
            catch (Exception e) {
                WildfireGender.LOGGER.error("Failed to retrieve contributors", (Throwable)e);
                return CONTRIBUTORS;
            }
            WildfireGender.LOGGER.debug("Retrieved contributor map from Cloud Sync: {}", contributors);
            return Contributors.merge(contributors);
        }));
    }
}

