/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.mojang.datafixers.util.Function8;
import com.wildfire.main.config.enums.Gender;
import com.wildfire.main.entitydata.Breasts;
import com.wildfire.main.entitydata.PlayerConfig;
import com.wildfire.main.uvs.UVDirection;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.main.uvs.UVQuad;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.UUID;
import net.minecraft.class_4844;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

abstract class AbstractSyncPacket {
    protected final UUID uuid;
    protected final Gender gender;
    protected final float bustSize;
    protected final boolean hurtSounds;
    protected final float voicePitch;
    protected final BreastPhysics physics;
    protected final Breasts breasts;
    protected final UVLayouts uvLayouts;
    static final class_9139<ByteBuf, UVLayout> UV_CODEC = class_9135.method_57992(size -> new EnumMap(UVDirection.class), UVDirection.PACKET_CODEC, UVQuad.PACKET_CODEC, (int)UVDirection.values().length).method_56432(UVLayout::new, UVLayout::getQuads);
    static final class_9139<ByteBuf, UVLayouts.Layer> UV_LAYER_CODEC = class_9139.method_56435(UV_CODEC, UVLayouts.Layer::left, UV_CODEC, UVLayouts.Layer::right, UVLayouts.Layer::new);
    static final class_9139<ByteBuf, UVLayouts> UV_LAYOUTS_CODEC = class_9139.method_56435(UV_LAYER_CODEC, UVLayouts::skin, UV_LAYER_CODEC, UVLayouts::overlay, UVLayouts::new);

    protected static <T extends AbstractSyncPacket> class_9139<ByteBuf, T> codec(SyncPacketConstructor<T> constructor) {
        return class_9139.method_65036((class_9139)class_4844.field_48453, p -> p.uuid, Gender.CODEC, p -> p.gender, (class_9139)class_9135.field_48552, p -> Float.valueOf(p.bustSize), (class_9139)class_9135.field_48547, p -> p.hurtSounds, (class_9139)class_9135.field_48552, p -> Float.valueOf(p.voicePitch), BreastPhysics.CODEC, p -> p.physics, Breasts.CODEC, p -> p.breasts, UV_LAYOUTS_CODEC, p -> p.uvLayouts, constructor);
    }

    protected AbstractSyncPacket(UUID uuid, Gender gender, float bustSize, boolean hurtSounds, float voicePitch, BreastPhysics physics, Breasts breasts, UVLayouts uvLayouts) {
        this.uuid = uuid;
        this.gender = gender;
        this.bustSize = bustSize;
        this.hurtSounds = hurtSounds;
        this.voicePitch = voicePitch;
        this.physics = physics;
        this.breasts = breasts;
        this.uvLayouts = uvLayouts;
    }

    protected AbstractSyncPacket(PlayerConfig plr) {
        this(plr.uuid, plr.getGender(), plr.getBustSize(), plr.hasHurtSounds(), plr.getVoicePitch(), new BreastPhysics(plr), plr.getBreasts(), UVLayouts.from(plr));
    }

    protected void updatePlayerFromPacket(PlayerConfig plr) {
        plr.updateGender(this.gender);
        plr.updateBustSize(this.bustSize);
        plr.updateHurtSounds(this.hurtSounds);
        plr.updateVoicePitch(this.voicePitch);
        this.physics.applyTo(plr);
        plr.getBreasts().copyFrom(this.breasts);
        this.uvLayouts.applyTo(plr);
    }

    protected record BreastPhysics(boolean physics, boolean showInArmor, float bounceMultiplier, float floppyMultiplier) {
        public static final class_9139<ByteBuf, BreastPhysics> CODEC = class_9139.method_56905((class_9139)class_9135.field_48547, BreastPhysics::physics, (class_9139)class_9135.field_48547, BreastPhysics::showInArmor, (class_9139)class_9135.field_48552, BreastPhysics::bounceMultiplier, (class_9139)class_9135.field_48552, BreastPhysics::floppyMultiplier, BreastPhysics::new);

        private BreastPhysics(PlayerConfig plr) {
            this(plr.hasBreastPhysics(), plr.showBreastsInArmor(), plr.getBounceMultiplier(), plr.getFloppiness());
        }

        private void applyTo(PlayerConfig plr) {
            plr.updateBreastPhysics(this.physics);
            plr.updateShowBreastsInArmor(this.showInArmor);
            plr.updateBounceMultiplier(this.bounceMultiplier);
            plr.updateFloppiness(this.floppyMultiplier);
        }
    }

    public record UVLayouts(Layer skin, Layer overlay) {
        public static UVLayouts from(PlayerConfig plr) {
            return new UVLayouts(new Layer(plr.getLeftBreastUVLayout().copy(), plr.getRightBreastUVLayout().copy()), new Layer(plr.getLeftBreastOverlayUVLayout().copy(), plr.getRightBreastOverlayUVLayout().copy()));
        }

        private void applyTo(PlayerConfig plr) {
            plr.updateLeftBreastUVLayout(this.skin.left);
            plr.updateRightBreastUVLayout(this.skin.right);
            plr.updateLeftBreastOverlayUVLayout(this.overlay.left);
            plr.updateRightBreastOverlayUVLayout(this.overlay.right);
        }

        public record Layer(UVLayout left, UVLayout right) {
        }
    }

    @FunctionalInterface
    protected static interface SyncPacketConstructor<T extends AbstractSyncPacket>
    extends Function8<UUID, Gender, Float, Boolean, Float, BreastPhysics, Breasts, UVLayouts, T> {
    }
}

