/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.uvs;

import com.wildfire.main.uvs.UVDirection;
import com.wildfire.main.uvs.UVQuad;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

public class UVLayout {
    private final EnumMap<UVDirection, UVQuad> quads = new EnumMap(UVDirection.class);

    public UVLayout(Map<UVDirection, UVQuad> map) {
        this.quads.putAll(map);
        this.fillMissing();
    }

    public UVLayout(UVQuad east, UVQuad west, UVQuad down, UVQuad up, UVQuad north) {
        this.quads.put(UVDirection.EAST, east);
        this.quads.put(UVDirection.WEST, west);
        this.quads.put(UVDirection.DOWN, down);
        this.quads.put(UVDirection.UP, up);
        this.quads.put(UVDirection.NORTH, north);
    }

    public UVLayout() {
        this(Collections.emptyMap());
    }

    private void fillMissing() {
        this.quads.putIfAbsent(UVDirection.EAST, null);
        this.quads.putIfAbsent(UVDirection.WEST, null);
        this.quads.putIfAbsent(UVDirection.DOWN, null);
        this.quads.putIfAbsent(UVDirection.UP, null);
        this.quads.putIfAbsent(UVDirection.NORTH, null);
    }

    public void put(UVDirection dir, UVQuad quad) {
        this.quads.put(dir, quad);
    }

    public UVQuad get(UVDirection dir) {
        return this.quads.get((Object)dir);
    }

    public boolean has(UVDirection dir) {
        return this.quads.containsKey((Object)dir) && this.quads.get((Object)dir) != null;
    }

    @ApiStatus.Internal
    public EnumMap<UVDirection, UVQuad> getQuads() {
        return this.quads.clone();
    }

    public Map<UVDirection, UVQuad> getAllSides() {
        return Collections.unmodifiableMap(this.quads);
    }

    public UVLayout copy() {
        UVLayout copy = new UVLayout();
        copy.quads.putAll(this.quads);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UVLayout)) {
            return false;
        }
        UVLayout other = (UVLayout)obj;
        return this.quads.equals((Object)other.quads);
    }
}

