/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.wildfire.api.IBreastArmorTexture;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.main.uvs.UVQuad;
import com.wildfire.mixins.accessors.EquipmentRendererAccessor;
import com.wildfire.render.BreastRenderCommand;
import com.wildfire.render.BreastSide;
import com.wildfire.render.GenderLayer;
import com.wildfire.render.GenderRenderState;
import com.wildfire.render.WildfireModelRenderer;
import com.wildfire.render.ducks.MissingTextureLogger;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_10197;
import net.minecraft.class_10201;
import net.minecraft.class_10394;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_11659;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5321;
import net.minecraft.class_572;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import net.minecraft.class_9998;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class GenderArmorLayer<S extends class_10034, M extends class_572<S>>
extends GenderLayer<S, M> {
    private final class_10197 equipmentRenderer;
    private final class_10201 equipmentModelLoader;
    protected WildfireModelRenderer.BreastModelBox lBoobArmor;
    protected WildfireModelRenderer.BreastModelBox rBoobArmor;
    protected static final WildfireModelRenderer.BreastModelBox lTrim;
    protected static final WildfireModelRenderer.BreastModelBox rTrim;
    private GenderRenderState genderRenderState;
    @NotNull
    private IBreastArmorTexture textureData = IBreastArmorTexture.DEFAULT;

    private static boolean textureExists(class_2960 texture) {
        class_1060 texManager = class_310.method_1551().method_1531();
        return !((MissingTextureLogger)texManager).wildfire_gender$missingTextures().contains(texture);
    }

    public GenderArmorLayer(class_3883<S, M> render, class_10201 equipmentModelLoader, class_10197 equipmentRenderer) {
        super(render);
        this.equipmentRenderer = equipmentRenderer;
        this.equipmentModelLoader = equipmentModelLoader;
    }

    @Override
    public void render(class_4587 matrixStack, class_11659 queue, int light, S state, float limbAngle, float limbDistance) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        this.genderRenderState = GenderRenderState.get(state);
        if (this.genderRenderState == null) {
            return;
        }
        class_1799 chestplate = ((class_10034)state).field_53418;
        class_10192 component = (class_10192)chestplate.method_58694(class_9334.field_54196);
        if (component == null || component.comp_3174() != class_1304.field_6174) {
            return;
        }
        class_5321 asset = component.comp_3176().orElse(null);
        if (asset == null) {
            return;
        }
        List layers = this.equipmentModelLoader.method_64087(asset).method_63996(class_10186.class_10190.field_54125);
        if (layers.isEmpty()) {
            return;
        }
        try {
            if (!this.setupRender(state, this.genderRenderState)) {
                return;
            }
            if (state instanceof class_9998 && !this.genderArmor.armorStandsCopySettings()) {
                return;
            }
            int color = class_9282.method_57470((class_1799)chestplate, (int)0);
            boolean glint = chestplate.method_7958();
            this.renderSides(state, (class_572)this.method_17165(), matrixStack, side -> {
                layers.forEach(layer -> {
                    int layerColor = class_10197.method_64076((class_10186.class_10189)layer, (int)color);
                    class_2960 texture = layer.method_64007(class_10186.class_10190.field_54125);
                    this.renderBreastArmor(texture, matrixStack, queue, state, (BreastSide)((Object)side), layerColor, glint);
                });
                class_8053 trim = (class_8053)this.armorStack.method_58694(class_9334.field_49607);
                if (trim != null) {
                    this.renderArmorTrim((class_5321<class_10394>)asset, matrixStack, queue, state, trim, (BreastSide)((Object)side), glint);
                }
            });
        }
        catch (Exception e) {
            WildfireGender.LOGGER.error("Failed to render breast armor", (Throwable)e);
        }
    }

    @Override
    protected boolean isLayerVisible(S state) {
        return this.genderArmor.coversBreasts();
    }

    @Override
    protected void resizeBox(GenderRenderState state, float breastSize) {
        if (this.lBoobArmor == null || this.rBoobArmor == null) {
            this.lBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, state.leftBreastArmorUVLayout);
            this.rBoobArmor = new WildfireModelRenderer.BreastModelBox(64, 32, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, state.rightBreastArmorUVLayout);
        }
    }

    @Override
    protected void setupTransformations(S state, M model, class_4587 matrixStack, BreastSide side) {
        super.setupTransformations(state, model, matrixStack, side);
        if (this.genderRenderState.hasJacketLayer) {
            matrixStack.method_46416(0.0f, 0.0f, -0.015f);
            matrixStack.method_22905(1.05f, 1.05f, 1.05f);
        }
        matrixStack.method_46416(side.isLeft ? 0.001f : -0.001f, 0.015f, -0.015f);
        matrixStack.method_22905(1.05f, 1.0f, 1.0f);
    }

    protected void renderBreastArmor(class_2960 texture, class_4587 matrixStack, class_11659 queue, S state, BreastSide side, int color, boolean glint) {
        if (!GenderArmorLayer.textureExists(texture)) {
            return;
        }
        WildfireModelRenderer.BreastModelBox model = side.isLeft ? this.lBoobArmor : this.rBoobArmor;
        class_1921 layer = class_1921.method_25448((class_2960)texture);
        queue.method_73483(matrixStack, layer, (class_11659.class_11660)new BreastRenderCommand(model, (class_10042)state, class_4608.field_21444, class_9848.method_61334((int)color)));
        if (glint) {
            this.renderGlint(matrixStack, queue, state, model);
        }
    }

    protected void renderArmorTrim(class_5321<class_10394> armorModel, class_4587 matrixStack, class_11659 queue, S state, class_8053 trim, BreastSide side, boolean glint) {
        WildfireModelRenderer.BreastModelBox model = side.isLeft ? lTrim : rTrim;
        class_10197.class_10199 key = new class_10197.class_10199(trim, class_10186.class_10190.field_54125, armorModel);
        class_1058 sprite = ((EquipmentRendererAccessor)this.equipmentRenderer).getTrimSprites().apply(key);
        class_1921 layer = class_4722.method_48480((boolean)((class_8056)trim.comp_3180().comp_349()).comp_1905());
        queue.method_73483(matrixStack, layer, (class_11659.class_11660)BreastRenderCommand.trim(model, state, sprite));
        if (glint) {
            this.renderGlint(matrixStack, queue, state, model);
        }
    }

    protected void renderGlint(class_4587 matrixStack, class_11659 renderQueue, S state, WildfireModelRenderer.BreastModelBox box) {
        class_1921 glintLayer = class_1921.method_27949();
        renderQueue.method_73483(matrixStack, glintLayer, (class_11659.class_11660)new BreastRenderCommand(box, (class_10042)state, class_4608.field_21444, -1));
    }

    static {
        UVLayout left = new UVLayout(new UVQuad(24, 21, 28, 26), new UVQuad(16, 21, 20, 26), new UVQuad(20, 17, 24, 21), new UVQuad(20, 25, 24, 27), new UVQuad(20, 21, 24, 26));
        UVLayout right = new UVLayout(new UVQuad(28, 21, 32, 26), new UVQuad(20, 21, 24, 26), new UVQuad(24, 17, 28, 21), new UVQuad(24, 25, 28, 27), new UVQuad(24, 21, 28, 26));
        lTrim = new WildfireModelRenderer.BreastModelBox(64, 32, -4.0f, 0.0f, 0.0f, 4, 5, 4, 0.001f, left);
        rTrim = new WildfireModelRenderer.BreastModelBox(64, 32, 0.0f, 0.0f, 0.0f, 4, 5, 4, 0.001f, right);
    }
}

