/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.wildfire.api.IGenderArmor;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.config.ClientConfig;
import com.wildfire.main.uvs.UVLayout;
import com.wildfire.mixins.accessors.LivingEntityRendererAccessor;
import com.wildfire.render.BreastRenderCommand;
import com.wildfire.render.BreastSide;
import com.wildfire.render.GenderRenderState;
import com.wildfire.render.WildfireModelRenderer;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_922;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class GenderLayer<S extends class_10034, M extends class_572<S>>
extends class_3887<S, M> {
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private WildfireModelRenderer.BreastModelBox lBreast;
    private WildfireModelRenderer.BreastModelBox rBreast;
    private WildfireModelRenderer.OverlayModelBox lBreastWear;
    private WildfireModelRenderer.OverlayModelBox rBreastWear;
    private UVLayout prevLeftBreastUVLayout;
    private UVLayout prevRightBreastUVLayout;
    private UVLayout prevLeftBreastOverlayUVLayout;
    private UVLayout prevRightBreastOverlayUVLayout;
    private final class_3883<S, M> context;
    private boolean isUniboob;
    protected class_1799 armorStack;
    protected IGenderArmor genderArmor;
    protected boolean isChestplateOccupied;
    protected boolean bounceEnabled;
    protected boolean breathingAnimation;
    protected float breastOffsetX;
    protected float breastOffsetY;
    protected float breastOffsetZ;
    protected float lPhysPositionY;
    protected float lPhysPositionX;
    protected float rPhysPositionY;
    protected float rPhysPositionX;
    protected float lPhysBounceRotation;
    protected float rPhysBounceRotation;
    protected float breastSize;
    protected float zOffset;
    protected float outwardAngle;

    public GenderLayer(class_3883<S, M> render) {
        super(render);
        this.context = render;
    }

    @Nullable
    private class_1921 getRenderLayer(S state) {
        boolean bodyVisible = !((class_10034)state).field_53333;
        boolean translucent = ((class_10034)state).field_53333 && !((class_10034)state).field_53461;
        boolean glowing = state.method_72997();
        class_922 renderer = (class_922)this.context;
        return ((LivingEntityRendererAccessor)renderer).invokeGetRenderLayer((class_10042)state, bodyVisible, translucent, glowing);
    }

    public void render(class_4587 matrixStack, class_11659 queue, int light, S state, float limbAngle, float limbDistance) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        GenderRenderState entityConfigState = GenderRenderState.get(state);
        if (entityConfigState == null) {
            return;
        }
        try {
            if (!this.setupRender(state, entityConfigState)) {
                return;
            }
            int overlay = class_922.method_23622(state, (float)0.0f);
            this.renderSides(state, (class_572)this.method_17165(), matrixStack, side -> this.renderBreast(state, matrixStack, queue, overlay, (BreastSide)((Object)side)));
        }
        catch (Exception e) {
            WildfireGender.LOGGER.error("Failed to render breast layer", (Throwable)e);
        }
    }

    protected boolean setupRender(S entityState, GenderRenderState genderState) {
        if (!ClientConfig.RENDER_BREASTS) {
            return false;
        }
        this.armorStack = ((class_10034)entityState).field_53418;
        this.genderArmor = WildfireHelper.getArmorConfig(this.armorStack);
        boolean bl = this.isChestplateOccupied = this.genderArmor.coversBreasts() && !genderState.armorPhysicsOverride;
        if (this.genderArmor.alwaysHidesBreasts() || !genderState.showBreastsInArmor && this.isChestplateOccupied) {
            return false;
        }
        if (!this.isLayerVisible(entityState)) {
            return false;
        }
        GenderRenderState.BreastState breasts = genderState.breasts;
        this.breastOffsetX = WildfireHelper.round(breasts.xOffset, 1.0f);
        this.breastOffsetY = -WildfireHelper.round(breasts.yOffset, 1.0f);
        this.breastOffsetZ = -WildfireHelper.round(breasts.zOffset, 1.0f);
        this.isUniboob = breasts.uniboob;
        GenderRenderState.BreastPhysicsState leftPhysicsState = genderState.leftBreastPhysics;
        float bSize = leftPhysicsState.getBreastSize();
        this.outwardAngle = Math.round(breasts.cleavage * 100.0f);
        this.outwardAngle = Math.min(this.outwardAngle, 10.0f);
        this.resizeBox(genderState, bSize);
        this.lPhysPositionY = leftPhysicsState.getPositionY();
        this.lPhysPositionX = leftPhysicsState.getPositionX();
        this.lPhysBounceRotation = leftPhysicsState.getBounceRotation();
        if (this.isUniboob) {
            this.rPhysPositionY = this.lPhysPositionY;
            this.rPhysPositionX = this.lPhysPositionX;
            this.rPhysBounceRotation = this.lPhysBounceRotation;
        } else {
            GenderRenderState.BreastPhysicsState rightPhysicsState = genderState.rightBreastPhysics;
            this.rPhysPositionY = rightPhysicsState.getPositionY();
            this.rPhysPositionX = rightPhysicsState.getPositionX();
            this.rPhysBounceRotation = rightPhysicsState.getBounceRotation();
        }
        this.breastSize = Math.min(bSize * 1.5f, 0.7f);
        if (bSize > 0.7f) {
            this.breastSize = bSize;
        }
        if (this.breastSize < 0.02f) {
            return false;
        }
        this.zOffset = 0.0625f - bSize * 0.0625f;
        this.breastSize += 0.5f * Math.abs(bSize - 0.7f) * 2.0f;
        float resistance = class_3532.method_15363((float)this.genderArmor.physicsResistance(), (float)0.0f, (float)1.0f);
        this.breathingAnimation = (genderState.armorPhysicsOverride || resistance <= 0.5f) && genderState.isBreathing;
        this.bounceEnabled = genderState.hasBreastPhysics && (!this.isChestplateOccupied || resistance < 1.0f);
        return true;
    }

    protected boolean isLayerVisible(S state) {
        return !((class_10034)state).field_53461 || state.method_72997();
    }

    protected void resizeBox(GenderRenderState state, float breastSize) {
        if (!(Objects.equals(this.prevLeftBreastUVLayout, state.leftBreastUVLayout) && Objects.equals(this.prevRightBreastUVLayout, state.rightBreastUVLayout) && Objects.equals(this.prevLeftBreastOverlayUVLayout, state.leftBreastOverlayUVLayout) && Objects.equals(this.prevRightBreastOverlayUVLayout, state.rightBreastOverlayUVLayout))) {
            this.prevLeftBreastUVLayout = state.leftBreastUVLayout;
            this.prevRightBreastUVLayout = state.rightBreastUVLayout;
            this.prevLeftBreastOverlayUVLayout = state.leftBreastOverlayUVLayout;
            this.prevRightBreastOverlayUVLayout = state.rightBreastOverlayUVLayout;
            this.lBreast = new WildfireModelRenderer.BreastModelBox(64, 64, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, state.leftBreastUVLayout);
            this.rBreast = new WildfireModelRenderer.BreastModelBox(64, 64, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, state.rightBreastUVLayout);
            this.lBreastWear = new WildfireModelRenderer.OverlayModelBox(64, 64, -4.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, state.leftBreastOverlayUVLayout);
            this.rBreastWear = new WildfireModelRenderer.OverlayModelBox(64, 64, 0.0f, 0.0f, 0.0f, 4, 5, 3, 0.0f, state.rightBreastOverlayUVLayout);
        }
    }

    protected void setupTransformations(S state, M model, class_4587 matrixStack, BreastSide side) {
        if (((class_10034)state).field_53457) {
            matrixStack.method_22905(((class_10034)state).field_53454, ((class_10034)state).field_53454, ((class_10034)state).field_53454);
            matrixStack.method_46416(0.0f, 0.75f, 0.0f);
        }
        class_630 body = ((class_572)model).field_3391;
        matrixStack.method_46416(body.field_3657 * 0.0625f, body.field_3656 * 0.0625f, body.field_3655 * 0.0625f);
        if (body.field_3674 != 0.0f || body.field_3675 != 0.0f || body.field_3654 != 0.0f) {
            matrixStack.method_22907((Quaternionfc)new Quaternionf().rotationZYX(body.field_3674, body.field_3675, body.field_3654));
        }
        if (this.bounceEnabled) {
            matrixStack.method_46416((side.isLeft ? this.lPhysPositionX : this.rPhysPositionX) / 32.0f, 0.0f, 0.0f);
            matrixStack.method_46416(0.0f, (side.isLeft ? this.lPhysPositionY : this.rPhysPositionY) / 32.0f, 0.0f);
        }
        matrixStack.method_46416((side.isLeft ? this.breastOffsetX : -this.breastOffsetX) * 0.0625f, 0.05625f + this.breastOffsetY * 0.0625f, this.zOffset - 0.125f + this.breastOffsetZ * 0.0425f);
        if (!this.isUniboob) {
            matrixStack.method_46416(-0.125f * (float)(side.isLeft ? 1 : -1), 0.0f, 0.0f);
        }
        if (this.bounceEnabled) {
            matrixStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)((double)(side.isLeft ? this.lPhysBounceRotation : this.rPhysBounceRotation) * (Math.PI / 180)), 0.0f));
        }
        if (!this.isUniboob) {
            matrixStack.method_46416(0.125f * (float)(side.isLeft ? 1 : -1), 0.0f, 0.0f);
        }
        float rotation = this.breastSize;
        if (this.bounceEnabled) {
            matrixStack.method_46416(0.0f, -0.035f * this.breastSize, 0.0f);
            rotation -= (side.isLeft ? this.lPhysPositionY : this.rPhysPositionY) / 12.0f;
        }
        rotation = Math.min(rotation, this.breastSize + 0.2f);
        rotation = Math.min(rotation, 1.0f);
        if (this.isChestplateOccupied) {
            matrixStack.method_46416(0.0f, 0.0f, 0.01f);
        }
        Quaternionf rotationTransform = new Quaternionf().rotationY((side.isLeft ? this.outwardAngle : -this.outwardAngle) * ((float)Math.PI / 180)).rotateX(-35.0f * rotation * ((float)Math.PI / 180));
        if (this.breathingAnimation) {
            float f5 = -class_3532.method_15362((float)(((class_10034)state).field_53328 * 0.09f)) * 0.45f + 0.45f;
            rotationTransform.rotateX(f5 * ((float)Math.PI / 180));
        }
        matrixStack.method_22907((Quaternionfc)rotationTransform);
        matrixStack.method_22905(0.9995f, 1.0f, 1.0f);
    }

    private void renderBreast(S state, class_4587 matrixStack, class_11659 queue, int overlay, BreastSide side) {
        class_1921 renderLayer = this.getRenderLayer(state);
        if (renderLayer == null) {
            return;
        }
        int alpha = ((class_10034)state).field_53333 ? class_9848.method_61326((float)0.15f) : 255;
        int color = class_9848.method_61324((int)alpha, (int)255, (int)255, (int)255);
        WildfireModelRenderer.BreastModelBox model = side.isLeft ? this.lBreast : this.rBreast;
        queue.method_73483(matrixStack, renderLayer, (class_11659.class_11660)new BreastRenderCommand(model, (class_10042)state, overlay, color));
        if (state instanceof class_10055) {
            class_10055 playerState = (class_10055)state;
            if (playerState.field_53544) {
                matrixStack.method_46416(0.0f, 0.0f, -0.015f);
                matrixStack.method_22905(1.05f, 1.05f, 1.05f);
                WildfireModelRenderer.OverlayModelBox jacketModel = side.isLeft ? this.lBreastWear : this.rBreastWear;
                queue.method_73483(matrixStack, renderLayer, (class_11659.class_11660)new BreastRenderCommand(jacketModel, (class_10042)state, overlay, color));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderSides(S state, M model, class_4587 matrixStack, Consumer<BreastSide> renderer) {
        matrixStack.method_22903();
        try {
            this.setupTransformations(state, model, matrixStack, BreastSide.LEFT);
            renderer.accept(BreastSide.LEFT);
        }
        finally {
            matrixStack.method_22909();
        }
        matrixStack.method_22903();
        try {
            this.setupTransformations(state, model, matrixStack, BreastSide.RIGHT);
            renderer.accept(BreastSide.RIGHT);
        }
        finally {
            matrixStack.method_22909();
        }
    }

    public static void renderBox(WildfireModelRenderer.ModelBox model, class_4587.class_4665 entry, class_4588 vertexConsumer, int light, int overlay, int color) {
        Matrix4f matrix4f = entry.method_23761();
        Matrix3f matrix3f = entry.method_23762();
        for (WildfireModelRenderer.TexturedQuad quad : model.quads) {
            if (quad.uvs[0] == 0.0f && quad.uvs[1] == 0.0f && quad.uvs[2] == 0.0f && quad.uvs[3] == 0.0f) continue;
            Vector3f vector3f = new Vector3f(quad.normal.x(), quad.normal.y(), quad.normal.z()).mul((Matrix3fc)matrix3f);
            float normalX = vector3f.x;
            float normalY = vector3f.y;
            float normalZ = vector3f.z;
            for (WildfireModelRenderer.PositionTextureVertex vertex : quad.vertexPositions) {
                float j = vertex.x() / 16.0f;
                float k = vertex.y() / 16.0f;
                float l = vertex.z() / 16.0f;
                Vector4f vector4f = new Vector4f(j, k, l, 1.0f).mul((Matrix4fc)matrix4f);
                vertexConsumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), color, vertex.u(), vertex.v(), overlay, light, normalX, normalY, normalZ);
            }
        }
    }
}

